/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.message;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.api.message.Messages;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.util.ServiceFinder;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Source;
import org.jvnet.ws.message.MessageContext;

public abstract class MessageContextFactory {
    private static final MessageContextFactory DEFAULT = new MessageContextFactory(){

        @Override
        public MessageContext doCreate() {
            return new Packet();
        }

        @Override
        public MessageContext doCreate(SOAPMessage m) {
            return this.p(m == null ? null : Messages.create(m));
        }

        @Override
        public MessageContext doCreate(Source m, SOAPVersion v) {
            return this.p(Messages.create(m, v));
        }

        private MessageContext p(Message m) {
            Packet p = new Packet();
            p.setMessage(m);
            return p;
        }
    };

    public abstract MessageContext doCreate();

    public abstract MessageContext doCreate(SOAPMessage var1);

    public abstract MessageContext doCreate(Source var1, SOAPVersion var2);

    public static MessageContext create(ClassLoader ... classLoader) {
        return MessageContextFactory.serviceFinder(classLoader, new Creator(){

            @Override
            public MessageContext create(MessageContextFactory f) {
                return f.doCreate();
            }
        });
    }

    public static MessageContext create(final SOAPMessage m, ClassLoader ... classLoader) {
        return MessageContextFactory.serviceFinder(classLoader, new Creator(){

            @Override
            public MessageContext create(MessageContextFactory f) {
                return f.doCreate(m);
            }
        });
    }

    public static MessageContext create(final Source m, final SOAPVersion v, ClassLoader ... classLoader) {
        return MessageContextFactory.serviceFinder(classLoader, new Creator(){

            @Override
            public MessageContext create(MessageContextFactory f) {
                return f.doCreate(m, v);
            }
        });
    }

    private static MessageContext serviceFinder(ClassLoader[] classLoader, Creator creator) {
        ClassLoader cl = classLoader.length == 0 ? null : classLoader[0];
        for (MessageContextFactory factory : ServiceFinder.find(MessageContextFactory.class, cl)) {
            MessageContext messageContext = creator.create(factory);
            if (messageContext == null) continue;
            return messageContext;
        }
        return creator.create(DEFAULT);
    }

    private static interface Creator {
        public MessageContext create(MessageContextFactory var1);
    }
}

