/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ModuleTree;
import com.sun.tools.javac.api.JavacTaskImpl;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.CompilerOptionsQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.Module;
import org.netbeans.modules.java.source.TreeShims;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.JavacParser;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

public final class ModuleNames {
    private static final Logger LOG = Logger.getLogger(ModuleNames.class.getName());
    private static final Pattern AUTO_NAME_PATTERN = Pattern.compile("-(\\d+(\\.|$))");
    private static final String RES_MANIFEST = "META-INF/MANIFEST.MF";
    private static final String ATTR_AUTOMATIC_MOD_NAME = "Automatic-Module-Name";
    private static final Pattern AUTOMATIC_MODULE_NAME_MATCHER = Pattern.compile("-XDautomatic-module-name:(.*)");
    private static final ModuleNames INSTANCE = new ModuleNames();
    private final Map<URL, CacheLine> cache = new ConcurrentHashMap<URL, CacheLine>();

    private ModuleNames() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @CheckForNull
    public String getModuleName(@NonNull URL rootUrl, boolean canUseSources) {
        CacheLine cacheLine;
        FileObject manifest;
        FileObject moduleInfo2;
        FileObject file;
        FileObject root;
        block38: {
            int n;
            FileObject[] fileObjectArray;
            int version;
            block39: {
                block37: {
                    CacheLine cl;
                    try {
                        CacheLine cl2 = this.cache.get(rootUrl);
                        if (cl2 != null) {
                            return cl2.getValue();
                        }
                    }
                    catch (InvalidCacheLine cl2) {
                        // empty catch block
                    }
                    LOG.log(Level.FINE, "No cache for: {0}", rootUrl);
                    if ("nbjrt".equals(rootUrl.getProtocol())) {
                        String path = rootUrl.getPath();
                        int endIndex = path.length() - 1;
                        int startIndex = path.lastIndexOf(47, endIndex - 1);
                        return this.register(rootUrl, new CacheLine(rootUrl, path.substring(startIndex + 1, endIndex)));
                    }
                    URL srcRootURL = JavaIndex.getSourceRootForClassFolder(rootUrl);
                    if (srcRootURL != null) {
                        return this.register(rootUrl, ModuleNames.getProjectModuleName(rootUrl, Collections.singletonList(srcRootURL), canUseSources));
                    }
                    SourceForBinaryQuery.Result2 sfbqRes = SourceForBinaryQuery.findSourceRoots2((URL)rootUrl);
                    if (sfbqRes.preferSources() && (cl = ModuleNames.getProjectModuleName(rootUrl, Arrays.stream(sfbqRes.getRoots()).map(FileObject::toURL).collect(Collectors.toList()), canUseSources)).getValueNoCheck() != null) {
                        return this.register(rootUrl, cl);
                    }
                    if (!FileUtil.isArchiveArtifact((URL)rootUrl)) break block37;
                    root = URLMapper.findFileObject((URL)rootUrl);
                    if (root == null) return null;
                    file = FileUtil.getArchiveFile((FileObject)root);
                    moduleInfo2 = null;
                    FileObject versions = root.getFileObject("META-INF/versions");
                    if (versions == null) break block38;
                    version = -1;
                    fileObjectArray = versions.getChildren();
                    n = fileObjectArray.length;
                    break block39;
                }
                root = URLMapper.findFileObject((URL)rootUrl);
                if (root == null) return null;
                FileObject moduleInfo = root.getFileObject("module-info", "class");
                if (moduleInfo == null) return null;
                try {
                    CacheLine cacheLine2;
                    String modName = ModuleNames.readModuleName(moduleInfo);
                    File path = FileUtil.toFile((FileObject)moduleInfo);
                    if (path != null) {
                        cacheLine2 = new FileCacheLine(rootUrl, modName, path);
                        return this.register(rootUrl, cacheLine2);
                    }
                    cacheLine2 = new FileObjectCacheLine(rootUrl, modName, moduleInfo);
                    return this.register(rootUrl, cacheLine2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            for (int i = 0; i < n; ++i) {
                FileObject c = fileObjectArray[i];
                try {
                    int currentVersion = Integer.parseInt(c.getNameExt());
                    FileObject currentMI = c.getFileObject("module-info", "class");
                    if (currentVersion <= version || currentMI == null) continue;
                    moduleInfo2 = currentMI;
                    version = currentVersion;
                    continue;
                }
                catch (NumberFormatException currentVersion) {
                    // empty catch block
                }
            }
        }
        if (moduleInfo2 == null) {
            moduleInfo2 = root.getFileObject("module-info", "class");
        }
        if (moduleInfo2 != null) {
            try {
                CacheLine cacheLine3;
                String modName = ModuleNames.readModuleName(moduleInfo2);
                File path = Optional.ofNullable(file).map(FileUtil::toFile).orElse(null);
                if (path != null) {
                    cacheLine3 = new FileCacheLine(rootUrl, modName, path);
                    return this.register(rootUrl, cacheLine3);
                }
                cacheLine3 = new FileObjectCacheLine(rootUrl, modName, moduleInfo2);
                return this.register(rootUrl, cacheLine3);
            }
            catch (IOException modName) {
                // empty catch block
            }
        }
        if ((manifest = root.getFileObject(RES_MANIFEST)) != null) {
            try (BufferedInputStream in2222 = new BufferedInputStream(manifest.getInputStream());){
                Manifest mf = new Manifest(in2222);
                String autoModName = mf.getMainAttributes().getValue(ATTR_AUTOMATIC_MOD_NAME);
                if (autoModName != null) {
                    File path = Optional.ofNullable(file).map(FileUtil::toFile).orElse(null);
                    String string = this.register(rootUrl, path != null ? new FileCacheLine(rootUrl, autoModName, path) : new FileObjectCacheLine(rootUrl, autoModName, file != null ? file : manifest));
                    return string;
                }
            }
            catch (IOException in2222) {
                // empty catch block
            }
        }
        if (file == null) return null;
        String modName = ModuleNames.autoName(file.getName());
        File path = FileUtil.toFile((FileObject)file);
        if (path != null) {
            cacheLine = new FileCacheLine(rootUrl, modName, path);
            return this.register(rootUrl, cacheLine);
        }
        cacheLine = new FileObjectCacheLine(rootUrl, modName, file);
        return this.register(rootUrl, cacheLine);
    }

    public void reset(@NonNull URL binRootURL) {
        Optional.ofNullable(this.cache.get(binRootURL)).ifPresent(CacheLine::invalidate);
    }

    private String register(@NonNull URL rootUrl, @NonNull CacheLine cacheLine) {
        this.cache.put(rootUrl, cacheLine);
        return cacheLine.getValueNoCheck();
    }

    @NonNull
    private static CacheLine getProjectModuleName(@NonNull URL artefact, @NonNull List<URL> srcRootURLs, boolean canUseSources) {
        if (srcRootURLs.isEmpty()) {
            return new CacheLine(artefact, null);
        }
        if (srcRootURLs.stream().allMatch(srcRootURL -> JavaIndex.hasSourceCache(srcRootURL, false))) {
            String modName = null;
            for (URL srcRootURL2 : srcRootURLs) {
                try {
                    modName = JavaIndex.getAttribute(srcRootURL2, "moduleName", null);
                    if (modName == null) continue;
                    break;
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            if (modName != null) {
                return new CacheLine(artefact, modName);
            }
            return ModuleNames.autoName(artefact, srcRootURLs);
        }
        if (canUseSources) {
            FileObject moduleInfo = null;
            FileObject root = null;
            for (URL srcRootUrl : srcRootURLs) {
                FileObject srcRoot = URLMapper.findFileObject((URL)srcRootUrl);
                if (srcRoot == null || (moduleInfo = srcRoot.getFileObject("module-info", "java")) == null) continue;
                root = srcRoot;
                break;
            }
            if (moduleInfo != null) {
                String modName = ModuleNames.parseModuleName(moduleInfo);
                File path = FileUtil.toFile(moduleInfo);
                return path != null ? new FileCacheLine(artefact, modName, path) : new FileObjectCacheLine(artefact, modName, moduleInfo);
            }
            return ModuleNames.autoName(artefact, srcRootURLs);
        }
        return new CacheLine(artefact, null);
    }

    @CheckForNull
    public static String parseModuleName(@NonNull FileObject moduleInfo) {
        JavacTaskImpl jt = JavacParser.createJavacTask(new ClasspathInfo.Builder(ClassPath.EMPTY).build(), null, "1.3", null, null, null, null, null, Collections.singletonList(FileObjects.fileObjectFileObject(moduleInfo, moduleInfo.getParent(), null, FileEncodingQuery.getEncoding((FileObject)moduleInfo))));
        CompilationUnitTree cu = jt.parse().iterator().next();
        ModuleTree module = TreeShims.getModule(cu);
        if (module != null) {
            return module.getName().toString();
        }
        return null;
    }

    @NonNull
    private static CacheLine autoName(@NonNull URL artefact, @NonNull List<? extends URL> srcRootURLs) {
        CompilerOptionsQuery.Result cops = null;
        String amn = null;
        block0: for (URL uRL : srcRootURLs) {
            FileObject fo = URLMapper.findFileObject((URL)uRL);
            if (fo == null) continue;
            cops = CompilerOptionsQuery.getOptions((FileObject)fo);
            for (String opt : cops.getArguments()) {
                Matcher m = AUTOMATIC_MODULE_NAME_MATCHER.matcher(opt);
                if (!m.matches()) continue;
                amn = m.group(1);
                break block0;
            }
        }
        if (amn != null) {
            return new BinCacheLine(artefact, amn, cops, null);
        }
        BinaryForSourceQuery.Result res = BinaryForSourceQuery.findBinaryRoots((URL)srcRootURLs.get(0));
        for (URL binRoot : res.getRoots()) {
            if (!"jar".equals(binRoot.getProtocol())) continue;
            String modName = ModuleNames.autoName(FileObjects.stripExtension(FileUtil.archiveOrDirForURL((URL)binRoot).getName()));
            return new BinCacheLine(artefact, modName, cops, res);
        }
        return new CacheLine(artefact, null);
    }

    @CheckForNull
    private static String autoName(@NonNull String moduleName) {
        Matcher matcher = AUTO_NAME_PATTERN.matcher(moduleName);
        if (matcher.find()) {
            int start = matcher.start();
            moduleName = moduleName.substring(0, start);
        }
        return (moduleName = moduleName.replaceAll("[^A-Za-z0-9]", ".").replaceAll("(\\.)(\\1)+", ".").replaceAll("^\\.", "").replaceAll("\\.$", "")).isEmpty() ? null : moduleName;
    }

    @CheckForNull
    private static String readModuleName(@NonNull FileObject moduleInfo) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(moduleInfo.getInputStream());){
            ClassFile clz = new ClassFile((InputStream)in, false);
            Module modle = clz.getModule();
            String string = modle != null ? modle.getName() : null;
            return string;
        }
    }

    @NonNull
    public static ModuleNames getInstance() {
        return INSTANCE;
    }

    private static final class BinCacheLine
    extends CacheLine
    implements ChangeListener {
        private final CompilerOptionsQuery.Result cops;
        private final BinaryForSourceQuery.Result res;
        private final ChangeListener copsCl;
        private final ChangeListener resCl;

        BinCacheLine(@NonNull URL artefact, @NonNull String modName, @NullAllowed CompilerOptionsQuery.Result cops, @NullAllowed BinaryForSourceQuery.Result res) {
            super(artefact, modName);
            this.cops = cops;
            this.res = res;
            if (this.cops != null) {
                this.copsCl = WeakListeners.change((ChangeListener)this, (Object)this.cops);
                this.cops.addChangeListener(this.copsCl);
            } else {
                this.copsCl = null;
            }
            if (this.res != null) {
                this.resCl = WeakListeners.change((ChangeListener)this, (Object)this.res);
                this.res.addChangeListener(this.resCl);
            } else {
                this.resCl = null;
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.invalidate();
        }

        @Override
        void invalidate() {
            super.invalidate();
            if (this.copsCl != null) {
                this.cops.removeChangeListener(this.copsCl);
            }
            if (this.resCl != null) {
                this.res.removeChangeListener(this.resCl);
            }
        }
    }

    private static final class FileObjectCacheLine
    extends CacheLine
    implements FileChangeListener {
        private final FileObject file;
        private final FileChangeListener wl;

        FileObjectCacheLine(@NonNull URL artefact, @NullAllowed String modName, @NonNull FileObject file) {
            super(artefact, modName);
            this.file = file;
            this.wl = FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.file);
            this.file.addFileChangeListener(this.wl);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.invalidate();
        }

        public void fileDataCreated(FileEvent fe) {
            this.invalidate();
        }

        public void fileChanged(FileEvent fe) {
            this.invalidate();
        }

        public void fileDeleted(FileEvent fe) {
            this.invalidate();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.invalidate();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        void invalidate() {
            super.invalidate();
            this.file.removeFileChangeListener(this.wl);
        }
    }

    private static final class FileCacheLine
    extends CacheLine
    implements FileChangeListener {
        private final File path;
        private final AtomicBoolean listens = new AtomicBoolean(true);

        FileCacheLine(@NonNull URL artefact, @NullAllowed String modName, @NonNull File path) {
            super(artefact, modName);
            this.path = path;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)path);
        }

        public void fileFolderCreated(FileEvent fe) {
            this.invalidate();
        }

        public void fileDataCreated(FileEvent fe) {
            this.invalidate();
        }

        public void fileChanged(FileEvent fe) {
            this.invalidate();
        }

        public void fileDeleted(FileEvent fe) {
            this.invalidate();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.invalidate();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        @Override
        void invalidate() {
            super.invalidate();
            if (this.listens.compareAndSet(true, false)) {
                FileUtil.removeFileChangeListener((FileChangeListener)this, (File)this.path);
            }
        }
    }

    private static class CacheLine {
        private final URL artefact;
        private final String value;
        private volatile boolean invalid;

        CacheLine(@NonNull URL artefact, @NullAllowed String value) {
            this.artefact = artefact;
            this.value = value;
            this.invalid = false;
        }

        @CheckForNull
        final String getValue() throws InvalidCacheLine {
            if (this.invalid) {
                throw InvalidCacheLine.INSTANCE;
            }
            return this.value;
        }

        @CheckForNull
        final String getValueNoCheck() {
            return this.value;
        }

        void invalidate() {
            LOG.log(Level.FINE, "Invalidated cache for: {0}", this.artefact);
            this.invalid = true;
        }
    }

    private static final class InvalidCacheLine
    extends Exception {
        static final InvalidCacheLine INSTANCE = new InvalidCacheLine();

        private InvalidCacheLine() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

