/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.html.editor.api.gsf.ErrorBadgingRule;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.util.Exceptions;

public abstract class HintsProvider {
    protected static final Rule.ErrorRule DEFAULT_ERROR_RULE = new Rule(HintSeverity.ERROR, true);
    protected static final Rule.ErrorRule DEFAULT_WARNING_RULE = new Rule(HintSeverity.WARNING, true);
    protected static final Rule.ErrorRule ERROR_RULE_BADGING = new BadgingRule(HintSeverity.ERROR, true);
    protected static final int DEFAULT_ERROR_HINT_PRIORITY = 50;

    protected static CharSequence getSourceText(Source source) {
        final AtomicReference sourceTextRef = new AtomicReference();
        try {
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    sourceTextRef.set(resultIterator.getSnapshot().getText());
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return (CharSequence)sourceTextRef.get();
    }

    public abstract List<Hint> compute(RuleContext var1);

    private static final class BadgingRule
    extends Rule
    implements ErrorBadgingRule {
        public BadgingRule(HintSeverity severity, boolean showInTaskList) {
            super(severity, showInTaskList);
        }
    }

    private static class Rule
    implements Rule.ErrorRule {
        private HintSeverity severity;
        private boolean showInTasklist;

        protected Rule(HintSeverity severity, boolean showInTaskList) {
            this.severity = severity;
            this.showInTasklist = showInTaskList;
        }

        public Set<?> getCodes() {
            return Collections.emptySet();
        }

        public boolean appliesTo(RuleContext context) {
            return true;
        }

        public String getDisplayName() {
            return "jsf";
        }

        public boolean showInTasklist() {
            return this.showInTasklist;
        }

        public HintSeverity getDefaultSeverity() {
            return this.severity;
        }
    }
}

