/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.actions;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.gradle.api.execute.ActionMapping;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ActionPersistenceUtils {
    static final String ELEMENT_ACTIONS = "actions";
    static final String ELEMENT_ACTION = "action";
    static final String ELEMENT_ARGS = "args";
    static final String ELEMENT_RELOAD = "reload";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_REPEATABLE = "repeatable";
    static final String ATTRIBUTE_RULE = "rule";
    static final String ATTRIBUTE_DISPLAY_NAME = "displayName";
    static final String SYSTEM_ID = "action-mapping.dtd";
    static final String NBACTIONS_CONFIG_PREFIX = "nb-actions-";
    static final String NBACTIONS_XML_EXT = ".xml";

    public static String getActionsFileName(String configId) {
        if (configId == null || "%%DEFAULT%%".equals(configId)) {
            return "gradle.properties";
        }
        return NBACTIONS_CONFIG_PREFIX + configId + NBACTIONS_XML_EXT;
    }

    public static FileObject findActionsFile(FileObject projectDirectory, String configId) {
        return projectDirectory.getFileObject(ActionPersistenceUtils.getActionsFileName(configId));
    }

    public static void saveDefaultActions(FileObject projectDirectory, List<ActionMapping> actions) throws IOException {
        EditableProperties props = new EditableProperties(false);
        FileObject fo = ActionPersistenceUtils.findActionsFile(projectDirectory, null);
        if (fo != null) {
            InputStream is = fo.getInputStream();
            Object object = null;
            try {
                props.load(is);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (is != null) {
                    if (object != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        Iterator it = props.keySet().iterator();
        while (it.hasNext()) {
            if (!((String)it.next()).startsWith("action.")) continue;
            it.remove();
        }
        for (ActionMapping mapping : actions) {
            String prefix = "action." + mapping.getName() + '.';
            if (mapping.getName().startsWith("custom-")) {
                props.setProperty("action." + mapping.getName(), mapping.getDisplayName());
            }
            if (!mapping.getArgs().isEmpty()) {
                props.setProperty(prefix + ELEMENT_ARGS, mapping.getArgs());
            }
            if (!mapping.getReloadArgs().isEmpty()) {
                props.setProperty(prefix + "reload.args", mapping.getReloadArgs());
            }
            if (mapping.getReloadRule() != ActionMapping.ReloadRule.DEFAULT) {
                props.setProperty(prefix + "reload.rule", mapping.getReloadRule().name());
            }
            if (mapping.isRepeatable()) continue;
            props.setProperty(prefix + ATTRIBUTE_REPEATABLE, "false");
        }
        if (props.isEmpty() && fo != null) {
            fo.delete();
        }
        try (OutputStream os = fo != null ? fo.getOutputStream() : projectDirectory.createAndOpen(ActionPersistenceUtils.getActionsFileName(null));){
            props.store(os);
        }
    }

    public static void writeActions(FileObject projectDirectory, String configId, List<ActionMapping> mappings) throws IOException {
        if ("%%DEFAULT%%".equals(configId)) {
            ActionPersistenceUtils.saveDefaultActions(projectDirectory, mappings);
            return;
        }
        FileObject fo = ActionPersistenceUtils.findActionsFile(projectDirectory, configId);
        if (mappings.isEmpty()) {
            if (fo != null && fo.isValid()) {
                fo.delete();
            }
            return;
        }
        Document doc = XMLUtil.createDocument((String)ELEMENT_ACTIONS, null, null, (String)SYSTEM_ID);
        for (ActionMapping a : mappings) {
            Element e = doc.createElement(ELEMENT_ACTION);
            e.setAttribute(ATTRIBUTE_NAME, a.getName());
            if (a.getDisplayName() != null && !a.getDisplayName().equals(a.getName())) {
                e.setAttribute(ATTRIBUTE_DISPLAY_NAME, a.getDisplayName());
            }
            if (a.isRepeatable()) {
                e.setAttribute(ATTRIBUTE_REPEATABLE, Boolean.valueOf(a.isRepeatable()).toString());
            }
            if (a.getArgs() != null && !a.getArgs().trim().isEmpty()) {
                Element args = doc.createElement(ELEMENT_ARGS);
                args.setTextContent(a.getArgs().trim());
                e.appendChild(args);
            }
            Element r = doc.createElement(ELEMENT_RELOAD);
            boolean appendReload = false;
            if (a.getReloadRule() != null && a.getReloadRule() != ActionMapping.ReloadRule.DEFAULT) {
                r.setAttribute(ATTRIBUTE_RULE, a.getReloadRule().name());
                appendReload = true;
            }
            if (a.getReloadArgs() != null && !a.getReloadArgs().trim().isEmpty()) {
                Element args = doc.createElement(ELEMENT_ARGS);
                args.setTextContent(a.getArgs().trim());
                r.appendChild(args);
                appendReload = true;
            }
            if (appendReload) {
                e.appendChild(r);
            }
            doc.getDocumentElement().appendChild(e);
        }
        try (OutputStream os = fo != null ? fo.getOutputStream() : projectDirectory.createAndOpen(ActionPersistenceUtils.getActionsFileName(configId));){
            XMLUtil.write((Document)doc, (OutputStream)os, (String)"UTF-8");
        }
    }
}

