/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.truffleinterop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.CachedContext;
import com.oracle.truffle.api.dsl.CachedLanguage;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.lang.JavaScriptLanguage;
import com.oracle.truffle.js.nodes.interop.ExportValueNode;
import com.oracle.truffle.js.nodes.interop.JSInteropExecuteNode;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.truffleinterop.InteropFunction;
import java.util.Objects;

@ExportLibrary(value=InteropLibrary.class)
public final class InteropBoundFunction
extends InteropFunction {
    final Object receiver;

    public InteropBoundFunction(DynamicObject function, Object receiver) {
        super(function);
        this.receiver = receiver;
    }

    public Object getReceiver() {
        return this.receiver;
    }

    public static boolean isInstance(TruffleObject object) {
        return object instanceof InteropBoundFunction;
    }

    public int hashCode() {
        int result = 31 + (this.function == null ? 0 : this.function.hashCode());
        result = 31 * result + (this.receiver == null ? 0 : this.receiver.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof InteropBoundFunction) {
            InteropBoundFunction other = (InteropBoundFunction)obj;
            return Objects.equals(this.function, other.function) && Objects.equals(this.receiver, other.receiver);
        }
        return false;
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ExportMessage
    Object execute(Object[] arguments, @CachedLanguage JavaScriptLanguage language, @CachedContext(value=JavaScriptLanguage.class) JSRealm realm, @Cached JSInteropExecuteNode callNode, @Cached ExportValueNode exportNode) throws UnsupportedMessageException {
        language.interopBoundaryEnter(realm);
        try {
            Object result = callNode.execute(this.function, this.receiver, arguments);
            Object object = exportNode.execute(result);
            return object;
        }
        finally {
            language.interopBoundaryExit(realm);
        }
    }
}

