/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gmbal.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.glassfish.gmbal.GmbalMBean;
import org.glassfish.gmbal.generic.FacetAccessor;
import org.glassfish.gmbal.generic.MethodMonitor;
import org.glassfish.gmbal.generic.MethodMonitorFactory;
import org.glassfish.gmbal.impl.Exceptions;
import org.glassfish.gmbal.impl.JMXRegistrationManager;
import org.glassfish.gmbal.impl.MBeanImpl;
import org.glassfish.gmbal.impl.ManagedObjectManagerInternal;

public class MBeanTree {
    private Object root = null;
    private MBeanImpl rootEntity = null;
    private Map<Object, MBeanImpl> objectMap;
    private Map<ObjectName, Object> objectNameMap;
    private String domain;
    private ObjectName rootParentName;
    private String rootParentPrefix;
    private String nullParentsParentPath;
    private String typeString;
    private ManagedObjectManagerInternal mom;
    private MethodMonitor mm;
    private JMXRegistrationManager jrm;
    private boolean suppressReport = false;
    private Map<String, String> typePartMap = new WeakHashMap<String, String>();

    private void addToObjectMaps(MBeanImpl mbean) {
        ObjectName oname = mbean.objectName();
        for (Object obj : mbean.facets()) {
            this.objectMap.put(obj, mbean);
        }
        this.objectNameMap.put(oname, mbean.target());
    }

    private void removeFromObjectMaps(MBeanImpl mbean) {
        ObjectName oname = mbean.objectName();
        for (Object obj : mbean.facets()) {
            this.objectMap.remove(obj);
        }
        this.objectNameMap.remove(oname);
    }

    public synchronized GmbalMBean setRoot(Object root, String rootName) {
        ObjectName oname;
        MBeanImpl rootMB = this.mom.constructMBean(null, root, rootName);
        try {
            oname = this.objectName(null, rootMB.type(), rootMB.name());
        }
        catch (MalformedObjectNameException ex) {
            throw Exceptions.self.noRootObjectName(ex);
        }
        rootMB.objectName(oname);
        this.addToObjectMaps(rootMB);
        this.root = root;
        this.rootEntity = rootMB;
        boolean success = false;
        try {
            this.jrm.setRoot(rootMB);
            success = true;
        }
        catch (InstanceAlreadyExistsException ex) {
            if (this.suppressReport) {
                GmbalMBean gmbalMBean = null;
                return gmbalMBean;
            }
            throw Exceptions.self.rootRegisterFail(ex, oname);
        }
        catch (Exception ex) {
            throw Exceptions.self.rootRegisterFail(ex, oname);
        }
        finally {
            if (!success) {
                this.removeFromObjectMaps(rootMB);
                this.root = null;
                this.rootEntity = null;
            }
        }
        return rootMB;
    }

    public synchronized Object getRoot() {
        return this.root;
    }

    private String parentPath(ObjectName rootParentName) {
        String pp = rootParentName.getKeyProperty("pp");
        String type = rootParentName.getKeyProperty("type");
        String name = rootParentName.getKeyProperty("name");
        if (pp == null) {
            throw Exceptions.self.ppNullInRootParent();
        }
        if (type == null) {
            throw Exceptions.self.typeNullInRootParent();
        }
        String prefix = pp.equals("/") ? pp : (pp.endsWith("/") ? pp : pp + "/");
        if (name == null) {
            return prefix + type;
        }
        return prefix + type + '[' + name + ']';
    }

    public MBeanTree(ManagedObjectManagerInternal mom, String domain, ObjectName rootParentName, String typeString) {
        this.mom = mom;
        this.domain = domain;
        this.rootParentName = rootParentName;
        if (rootParentName == null) {
            this.rootParentPrefix = null;
            this.nullParentsParentPath = "pp=/,";
        } else {
            this.rootParentPrefix = this.parentPath(rootParentName);
            this.nullParentsParentPath = "pp=" + this.rootParentPrefix + ",";
        }
        this.typeString = typeString;
        this.objectMap = new HashMap<Object, MBeanImpl>();
        this.objectNameMap = new HashMap<ObjectName, Object>();
        this.mm = MethodMonitorFactory.makeStandard(this.getClass());
        this.jrm = new JMXRegistrationManager(mom, rootParentName);
    }

    synchronized void suspendRegistration() {
        this.jrm.suspendRegistration();
    }

    synchronized void resumeRegistration() {
        this.jrm.resumeRegistration();
    }

    public synchronized FacetAccessor getFacetAccessor(Object obj) {
        return this.objectMap.get(obj);
    }

    private void checkCorrectRoot(MBeanImpl entity) {
        MBeanImpl current = entity;
        do {
            if (current != this.rootEntity) continue;
            return;
        } while ((current = current.parent()) != null);
        throw Exceptions.self.notPartOfThisTree(entity);
    }

    static String getQuotedName(String name) {
        StringBuilder buf = new StringBuilder(name.length() + 10);
        buf.append('\"');
        int len = name.length();
        boolean needsQuotes = false;
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            switch (c) {
                case '\n': {
                    c = 'n';
                    buf.append('\\');
                    needsQuotes = true;
                    break;
                }
                case '\"': 
                case '*': 
                case '?': 
                case '\\': {
                    buf.append('\\');
                    needsQuotes = true;
                    break;
                }
                case ',': 
                case ':': 
                case '=': {
                    needsQuotes = true;
                }
            }
            buf.append(c);
        }
        if (needsQuotes) {
            buf.append('\"');
            return buf.toString();
        }
        return name;
    }

    private synchronized String getTypePart(String type) {
        String result = this.typePartMap.get(type);
        if (result == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.typeString);
            sb.append("=");
            sb.append(MBeanTree.getQuotedName(type));
            result = sb.toString();
            this.typePartMap.put(type, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ObjectName objectName(MBeanImpl parent, String type, String name) throws MalformedObjectNameException {
        this.mm.enter(this.mom.registrationDebug(), "objectName", parent, type, name);
        ObjectName oname = null;
        try {
            if (parent != null) {
                this.checkCorrectRoot(parent);
            }
            StringBuilder result = new StringBuilder();
            result.append(this.domain);
            result.append(":");
            String ppPart = parent == null ? this.nullParentsParentPath : parent.getParentPathPart(this.rootParentPrefix);
            this.mm.info(this.mom.registrationDebug(), "ppPart", ppPart);
            result.append(ppPart);
            String typePart = this.getTypePart(type);
            this.mm.info(this.mom.registrationDebug(), "typePart", typePart);
            result.append(typePart);
            if (name.length() > 0) {
                result.append(',');
                result.append("name");
                result.append("=");
                result.append(MBeanTree.getQuotedName(name));
            }
            String on = result.toString();
            try {
                oname = new ObjectName(on);
            }
            catch (MalformedObjectNameException exc) {
                throw Exceptions.self.malformedObjectName(exc, on);
            }
            this.mm.exit(this.mom.registrationDebug(), oname);
        }
        catch (Throwable throwable) {
            this.mm.exit(this.mom.registrationDebug(), oname);
            throw throwable;
        }
        return oname;
    }

    public MBeanImpl getParentEntity(Object parent) {
        if (parent == null) {
            throw Exceptions.self.parentCannotBeNull();
        }
        MBeanImpl parentEntity = this.objectMap.get(parent);
        if (parentEntity == null) {
            throw Exceptions.self.parentNotFound(parent);
        }
        return parentEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized GmbalMBean register(MBeanImpl parentEntity, Object obj, MBeanImpl mb) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException, MalformedObjectNameException {
        this.mm.enter(this.mom.registrationDebug(), "register", parentEntity, obj, mb);
        try {
            MBeanImpl oldMB = this.objectMap.get(obj);
            if (oldMB != null) {
                throw Exceptions.self.objectAlreadyRegistered(obj, oldMB);
            }
            ObjectName oname = this.objectName(parentEntity, mb.type(), mb.name());
            mb.objectName(oname);
            Object oldObj = this.objectNameMap.get(oname);
            if (oldObj != null) {
                throw Exceptions.self.objectAlreadyRegistered(obj, this.objectMap.get(oldObj));
            }
            this.addToObjectMaps(mb);
            parentEntity.addChild(mb);
            this.jrm.register(mb);
            MBeanImpl mBeanImpl = mb;
            return mBeanImpl;
        }
        finally {
            this.mm.exit(this.mom.registrationDebug());
        }
    }

    public synchronized void unregister(Object obj) throws InstanceNotFoundException, MBeanRegistrationException {
        MBeanImpl mb;
        if (obj == this.root) {
            this.root = null;
            this.rootEntity = null;
        }
        if ((mb = this.objectMap.get(obj)) == null) {
            throw Exceptions.self.objectNotFound(obj);
        }
        for (Map<String, MBeanImpl> nameToMBean : mb.children().values()) {
            for (MBeanImpl child : nameToMBean.values()) {
                this.unregister(child.target());
            }
        }
        this.removeFromObjectMaps(mb);
        this.jrm.unregister(mb);
        if (mb.parent() != null) {
            mb.parent().removeChild(mb);
        }
    }

    public synchronized ObjectName getObjectName(Object obj) {
        if (obj instanceof MBeanImpl) {
            return ((MBeanImpl)obj).objectName();
        }
        MBeanImpl result = this.objectMap.get(obj);
        if (result != null) {
            return result.objectName();
        }
        return null;
    }

    public synchronized Object getObject(ObjectName oname) {
        return this.objectNameMap.get(oname);
    }

    public synchronized MBeanImpl getMBeanImpl(Object obj) {
        return this.objectMap.get(obj);
    }

    public synchronized void clear() {
        if (this.root != null) {
            try {
                this.unregister(this.root);
            }
            catch (InstanceNotFoundException ex) {
                Exceptions.self.shouldNotHappen(ex);
            }
            catch (MBeanRegistrationException ex) {
                Exceptions.self.shouldNotHappen(ex);
            }
        }
        this.objectMap.clear();
        this.objectNameMap.clear();
        this.rootEntity = null;
        this.jrm.clear();
    }

    public ObjectName getRootParentName() {
        return this.rootParentName;
    }

    synchronized void setSuppressDuplicateSetRootReport(boolean suppressReport) {
        this.suppressReport = suppressReport;
    }
}

