/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.Base64DecodingException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.ReferenceNotInitializedException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureException;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.transforms.InvalidTransformException;
import com.sun.org.apache.xml.internal.security.transforms.Transform;
import com.sun.org.apache.xml.internal.security.transforms.TransformationException;
import com.sun.org.apache.xml.internal.security.transforms.Transforms;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import com.sun.org.apache.xml.internal.security.utils.DigesterOutputStream;
import com.sun.org.apache.xml.internal.security.utils.ElementProxy;
import com.sun.org.apache.xml.internal.security.utils.IdResolver;
import com.sun.org.apache.xml.internal.security.utils.SignatureElementProxy;
import com.sun.org.apache.xml.internal.security.utils.UnsyncBufferedOutputStream;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolver;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Reference
extends SignatureElementProxy {
    private static boolean useC14N11 = false;
    public static final boolean CacheSignedNodes = false;
    static Logger log;
    public static final String OBJECT_URI = "http://www.w3.org/2000/09/xmldsig#Object";
    public static final String MANIFEST_URI = "http://www.w3.org/2000/09/xmldsig#Manifest";
    Manifest _manifest = null;
    XMLSignatureInput _transformsOutput;
    private Transforms transforms;
    private Element digestMethodElem;
    private Element digestValueElement;

    protected Reference(Document document, String string2, String string3, Manifest manifest, Transforms transforms, String string4) throws XMLSignatureException {
        super(document);
        XMLUtils.addReturnToElement(this._constructionElement);
        this._baseURI = string2;
        this._manifest = manifest;
        this.setURI(string3);
        if (transforms != null) {
            this.transforms = transforms;
            this._constructionElement.appendChild(transforms.getElement());
            XMLUtils.addReturnToElement(this._constructionElement);
        }
        MessageDigestAlgorithm messageDigestAlgorithm = MessageDigestAlgorithm.getInstance(this._doc, string4);
        this.digestMethodElem = messageDigestAlgorithm.getElement();
        this._constructionElement.appendChild(this.digestMethodElem);
        XMLUtils.addReturnToElement(this._constructionElement);
        this.digestValueElement = XMLUtils.createElementInSignatureSpace(this._doc, "DigestValue");
        this._constructionElement.appendChild(this.digestValueElement);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    protected Reference(Element element, String string2, Manifest manifest) throws XMLSecurityException {
        super(element, string2);
        this._baseURI = string2;
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        if ("Transforms".equals(element2.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(element2.getNamespaceURI())) {
            this.transforms = new Transforms(element2, this._baseURI);
            element2 = XMLUtils.getNextElement(element2.getNextSibling());
        }
        this.digestMethodElem = element2;
        this.digestValueElement = XMLUtils.getNextElement(this.digestMethodElem.getNextSibling());
        this._manifest = manifest;
    }

    public MessageDigestAlgorithm getMessageDigestAlgorithm() throws XMLSignatureException {
        if (this.digestMethodElem == null) {
            return null;
        }
        String string2 = this.digestMethodElem.getAttributeNS(null, "Algorithm");
        if (string2 == null) {
            return null;
        }
        return MessageDigestAlgorithm.getInstance(this._doc, string2);
    }

    public void setURI(String string2) {
        if (string2 != null) {
            this._constructionElement.setAttributeNS(null, "URI", string2);
        }
    }

    public String getURI() {
        return this._constructionElement.getAttributeNS(null, "URI");
    }

    public void setId(String string2) {
        if (string2 != null) {
            this._constructionElement.setAttributeNS(null, "Id", string2);
            IdResolver.registerElementById(this._constructionElement, string2);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void setType(String string2) {
        if (string2 != null) {
            this._constructionElement.setAttributeNS(null, "Type", string2);
        }
    }

    public String getType() {
        return this._constructionElement.getAttributeNS(null, "Type");
    }

    public boolean typeIsReferenceToObject() {
        return OBJECT_URI.equals(this.getType());
    }

    public boolean typeIsReferenceToManifest() {
        return MANIFEST_URI.equals(this.getType());
    }

    private void setDigestValueElement(byte[] byArray) {
        for (Node node = this.digestValueElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.digestValueElement.removeChild(node);
        }
        String string2 = Base64.encode(byArray);
        Text text = this._doc.createTextNode(string2);
        this.digestValueElement.appendChild(text);
    }

    public void generateDigestValue() throws XMLSignatureException, ReferenceNotInitializedException {
        this.setDigestValueElement(this.calculateDigest(false));
    }

    public XMLSignatureInput getContentsBeforeTransformation() throws ReferenceNotInitializedException {
        try {
            Attr attr = this._constructionElement.getAttributeNodeNS(null, "URI");
            String string2 = attr == null ? null : attr.getNodeValue();
            ResourceResolver resourceResolver = ResourceResolver.getInstance(attr, this._baseURI, this._manifest._perManifestResolvers);
            if (resourceResolver == null) {
                Object[] objectArray = new Object[]{string2};
                throw new ReferenceNotInitializedException("signature.Verification.Reference.NoInput", objectArray);
            }
            resourceResolver.addProperties(this._manifest._resolverProperties);
            XMLSignatureInput xMLSignatureInput = resourceResolver.resolve(attr, this._baseURI);
            return xMLSignatureInput;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new ReferenceNotInitializedException("empty", resourceResolverException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsInput() throws ReferenceNotInitializedException {
        XMLSignatureInput xMLSignatureInput;
        XMLSignatureInput xMLSignatureInput2 = this.getContentsBeforeTransformation();
        try {
            xMLSignatureInput = new XMLSignatureInput(xMLSignatureInput2.getBytes());
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        xMLSignatureInput.setSourceURI(xMLSignatureInput2.getSourceURI());
        return xMLSignatureInput;
    }

    private XMLSignatureInput getContentsAfterTransformation(XMLSignatureInput xMLSignatureInput, OutputStream outputStream) throws XMLSignatureException {
        try {
            Transforms transforms = this.getTransforms();
            XMLSignatureInput xMLSignatureInput2 = null;
            if (transforms != null) {
                this._transformsOutput = xMLSignatureInput2 = transforms.performTransforms(xMLSignatureInput, outputStream);
            } else {
                xMLSignatureInput2 = xMLSignatureInput;
            }
            return xMLSignatureInput2;
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getContentsAfterTransformation() throws XMLSignatureException {
        XMLSignatureInput xMLSignatureInput = this.getContentsBeforeTransformation();
        return this.getContentsAfterTransformation(xMLSignatureInput, null);
    }

    public XMLSignatureInput getNodesetBeforeFirstCanonicalization() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = xMLSignatureInput = this.getContentsBeforeTransformation();
            Transforms transforms = this.getTransforms();
            if (transforms != null) {
                Transform transform;
                String string2;
                for (int i = 0; !(i >= transforms.getLength() || (string2 = (transform = transforms.item(i)).getURI()).equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string2.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")); ++i) {
                    xMLSignatureInput2 = transform.performTransform(xMLSignatureInput2, null);
                }
                xMLSignatureInput2.setSourceURI(xMLSignatureInput.getSourceURI());
            }
            return xMLSignatureInput2;
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("empty", iOException);
        }
        catch (ResourceResolverException resourceResolverException) {
            throw new XMLSignatureException("empty", resourceResolverException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new XMLSignatureException("empty", canonicalizationException);
        }
        catch (InvalidCanonicalizerException invalidCanonicalizerException) {
            throw new XMLSignatureException("empty", invalidCanonicalizerException);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public String getHTMLRepresentation() throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.getNodesetBeforeFirstCanonicalization();
            Set set = new HashSet();
            Transforms transforms = this.getTransforms();
            ElementProxy elementProxy = null;
            if (transforms != null) {
                for (int i = 0; i < transforms.getLength(); ++i) {
                    Transform transform = transforms.item(i);
                    String string2 = transform.getURI();
                    if (!string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string2.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) continue;
                    elementProxy = transform;
                    break;
                }
            }
            if (elementProxy != null && elementProxy.length("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces") == 1) {
                InclusiveNamespaces inclusiveNamespaces = new InclusiveNamespaces(XMLUtils.selectNode(elementProxy.getElement().getFirstChild(), "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", 0), this.getBaseURI());
                set = InclusiveNamespaces.prefixStr2Set(inclusiveNamespaces.getInclusiveNamespaces());
            }
            return xMLSignatureInput.getHTMLRepresentation(set);
        }
        catch (TransformationException transformationException) {
            throw new XMLSignatureException("empty", transformationException);
        }
        catch (InvalidTransformException invalidTransformException) {
            throw new XMLSignatureException("empty", invalidTransformException);
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new XMLSignatureException("empty", xMLSecurityException);
        }
    }

    public XMLSignatureInput getTransformsOutput() {
        return this._transformsOutput;
    }

    protected XMLSignatureInput dereferenceURIandPerformTransforms(OutputStream outputStream) throws XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput;
            XMLSignatureInput xMLSignatureInput2 = this.getContentsBeforeTransformation();
            this._transformsOutput = xMLSignatureInput = this.getContentsAfterTransformation(xMLSignatureInput2, outputStream);
            return xMLSignatureInput;
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
    }

    public Transforms getTransforms() throws XMLSignatureException, InvalidTransformException, TransformationException, XMLSecurityException {
        return this.transforms;
    }

    public byte[] getReferencedBytes() throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(null);
            byte[] byArray = xMLSignatureInput.getBytes();
            return byArray;
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
        catch (CanonicalizationException canonicalizationException) {
            throw new ReferenceNotInitializedException("empty", canonicalizationException);
        }
    }

    private byte[] calculateDigest(boolean bl) throws ReferenceNotInitializedException, XMLSignatureException {
        try {
            MessageDigestAlgorithm messageDigestAlgorithm = this.getMessageDigestAlgorithm();
            messageDigestAlgorithm.reset();
            DigesterOutputStream digesterOutputStream = new DigesterOutputStream(messageDigestAlgorithm);
            UnsyncBufferedOutputStream unsyncBufferedOutputStream = new UnsyncBufferedOutputStream(digesterOutputStream);
            XMLSignatureInput xMLSignatureInput = this.dereferenceURIandPerformTransforms(unsyncBufferedOutputStream);
            if (useC14N11 && !bl && !xMLSignatureInput.isOutputStreamSet() && !xMLSignatureInput.isOctetStream()) {
                if (this.transforms == null) {
                    this.transforms = new Transforms(this._doc);
                    this._constructionElement.insertBefore(this.transforms.getElement(), this.digestMethodElem);
                }
                this.transforms.addTransform("http://www.w3.org/2006/12/xml-c14n11");
                xMLSignatureInput.updateOutputStream(unsyncBufferedOutputStream, true);
            } else {
                xMLSignatureInput.updateOutputStream(unsyncBufferedOutputStream);
            }
            ((OutputStream)unsyncBufferedOutputStream).flush();
            return digesterOutputStream.getDigestValue();
        }
        catch (XMLSecurityException xMLSecurityException) {
            throw new ReferenceNotInitializedException("empty", xMLSecurityException);
        }
        catch (IOException iOException) {
            throw new ReferenceNotInitializedException("empty", iOException);
        }
    }

    public byte[] getDigestValue() throws Base64DecodingException, XMLSecurityException {
        if (this.digestValueElement == null) {
            Object[] objectArray = new Object[]{"DigestValue", "http://www.w3.org/2000/09/xmldsig#"};
            throw new XMLSecurityException("signature.Verification.NoSignatureElement", objectArray);
        }
        byte[] byArray = Base64.decode(this.digestValueElement);
        return byArray;
    }

    public boolean verify() throws ReferenceNotInitializedException, XMLSecurityException {
        byte[] byArray;
        byte[] byArray2 = this.getDigestValue();
        boolean bl = MessageDigestAlgorithm.isEqual(byArray2, byArray = this.calculateDigest(true));
        if (!bl) {
            log.log(Level.WARNING, "Verification failed for URI \"" + this.getURI() + "\"");
            log.log(Level.WARNING, "Expected Digest: " + Base64.encode(byArray2));
            log.log(Level.WARNING, "Actual Digest: " + Base64.encode(byArray));
        } else {
            log.log(Level.INFO, "Verification successful for URI \"" + this.getURI() + "\"");
        }
        return bl;
    }

    public String getBaseLocalName() {
        return "Reference";
    }

    static {
        try {
            useC14N11 = Boolean.getBoolean("com.sun.org.apache.xml.internal.security.useC14N11");
        }
        catch (Exception exception) {
            // empty catch block
        }
        log = Logger.getLogger(Reference.class.getName());
    }
}

