/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.polyglot.GuestToHostRootNode;
import com.oracle.truffle.polyglot.PolyglotImpl;
import com.oracle.truffle.polyglot.PolyglotLanguageContext;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.Proxy;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyDate;
import org.graalvm.polyglot.proxy.ProxyDuration;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.graalvm.polyglot.proxy.ProxyInstant;
import org.graalvm.polyglot.proxy.ProxyInstantiable;
import org.graalvm.polyglot.proxy.ProxyNativeObject;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.graalvm.polyglot.proxy.ProxyTime;
import org.graalvm.polyglot.proxy.ProxyTimeZone;

@ExportLibrary(value=InteropLibrary.class)
final class PolyglotProxy
implements TruffleObject {
    static final int LIMIT = 5;
    private static final ProxyArray EMPTY = new ProxyArray(){

        public void set(long index, Value value) {
            throw new ArrayIndexOutOfBoundsException();
        }

        public long getSize() {
            return 0L;
        }

        public Object get(long index) {
            throw new ArrayIndexOutOfBoundsException();
        }
    };
    final PolyglotLanguageContext languageContext;
    final Proxy proxy;
    private static final CallTarget INSTANTIATE = GuestToHostRootNode.createGuestToHost(new InstantiateNode());
    private static final CallTarget EXECUTE = GuestToHostRootNode.createGuestToHost(new ExecuteNode());
    private static final CallTarget AS_POINTER = GuestToHostRootNode.createGuestToHost(new AsPointerNode());
    private static final CallTarget ARRAY_GET = GuestToHostRootNode.createGuestToHost(new ArrayGetNode());
    private static final CallTarget ARRAY_SET = GuestToHostRootNode.createGuestToHost(new ArraySetNode());
    private static final CallTarget ARRAY_REMOVE = GuestToHostRootNode.createGuestToHost(new ArrayRemoveNode());
    private static final CallTarget ARRAY_SIZE = GuestToHostRootNode.createGuestToHost(new ArraySizeNode());
    private static final CallTarget MEMBER_KEYS = GuestToHostRootNode.createGuestToHost(new GetMemberKeysNode());
    private static final CallTarget GET_MEMBER = GuestToHostRootNode.createGuestToHost(new GetMemberNode());
    private static final CallTarget PUT_MEMBER = GuestToHostRootNode.createGuestToHost(new PutMemberNode());
    private static final CallTarget REMOVE_MEMBER = GuestToHostRootNode.createGuestToHost(new RemoveMemberNode());
    private static final CallTarget HAS_MEMBER = GuestToHostRootNode.createGuestToHost(new HasMemberNode());
    private static final CallTarget AS_TIMEZONE = GuestToHostRootNode.createGuestToHost(new AsTimeZoneNode());
    private static final CallTarget AS_DATE = GuestToHostRootNode.createGuestToHost(new AsDateNode());
    private static final CallTarget AS_TIME = GuestToHostRootNode.createGuestToHost(new AsTimeNode());
    private static final CallTarget AS_INSTANT = GuestToHostRootNode.createGuestToHost(new AsInstantNode());
    private static final CallTarget AS_DURATION = GuestToHostRootNode.createGuestToHost(new AsDurationNode());

    PolyglotProxy(PolyglotLanguageContext context, Proxy proxy) {
        this.languageContext = context;
        this.proxy = proxy;
    }

    @ExportMessage
    boolean isInstantiable() {
        return this.proxy instanceof ProxyInstantiable;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object instantiate(Object[] arguments, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyInstantiable) {
            Value[] convertedArguments = this.languageContext.toHostValues(arguments, 0);
            Object result = GuestToHostRootNode.guestToHostCall(library, INSTANTIATE, this.languageContext, this.proxy, convertedArguments);
            return this.languageContext.toGuestValue(result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isExecutable() {
        return this.proxy instanceof ProxyExecutable;
    }

    @ExportMessage
    Object execute(Object[] arguments, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyExecutable) {
            Value[] convertedArguments = this.languageContext.toHostValues(arguments, 0);
            Object result = GuestToHostRootNode.guestToHostCall(library, EXECUTE, this.languageContext, this.proxy, convertedArguments);
            return this.languageContext.toGuestValue(result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean isPointer() {
        return this.proxy instanceof ProxyNativeObject;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long asPointer(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyNativeObject) {
            return (Long)GuestToHostRootNode.guestToHostCall(library, AS_POINTER, this.languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    boolean hasArrayElements() {
        return this.proxy instanceof ProxyArray;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readArrayElement(long index, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyArray) {
            Object result = GuestToHostRootNode.guestToHostCall(library, ARRAY_GET, this.languageContext, this.proxy, index);
            return this.languageContext.toGuestValue(result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeArrayElement(long index, Object value, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (!(this.proxy instanceof ProxyArray)) {
            throw UnsupportedMessageException.create();
        }
        Value castValue = this.languageContext.asValue(value);
        GuestToHostRootNode.guestToHostCall(library, ARRAY_SET, this.languageContext, this.proxy, index, castValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeArrayElement(long index, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException, InvalidArrayIndexException {
        if (this.proxy instanceof ProxyArray) {
            boolean result = (Boolean)GuestToHostRootNode.guestToHostCall(library, ARRAY_REMOVE, this.languageContext, this.proxy, index);
            if (!result) {
                throw InvalidArrayIndexException.create(index);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    long getArraySize(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyArray) {
            return (Long)GuestToHostRootNode.guestToHostCall(library, ARRAY_SIZE, this.languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable"), @ExportMessage(name="isArrayElementRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementExisting(long index, @CachedLibrary(value="this") InteropLibrary library) {
        if (this.proxy instanceof ProxyArray) {
            long size = (Long)GuestToHostRootNode.guestToHostCall(library, ARRAY_SIZE, this.languageContext, this.proxy);
            return index >= 0L && index < size;
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isArrayElementInsertable(long index, @CachedLibrary(value="this") InteropLibrary library) {
        if (this.proxy instanceof ProxyArray) {
            long size = (Long)GuestToHostRootNode.guestToHostCall(library, ARRAY_SIZE, this.languageContext, this.proxy);
            return index < 0L || index >= size;
        }
        return false;
    }

    @ExportMessage
    boolean hasMembers() {
        return this.proxy instanceof ProxyObject;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object getMembers(boolean includeInternal, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyObject) {
            Object result = GuestToHostRootNode.guestToHostCall(library, MEMBER_KEYS, this.languageContext, this.proxy);
            if (result == null) {
                result = EMPTY;
            }
            Object guestValue = this.languageContext.toGuestValue(result);
            if (!InteropLibrary.getFactory().getUncached().hasArrayElements(guestValue)) {
                throw this.illegalProxy("getMemberKeys() returned invalid value %s but must return an array of member key Strings.", this.languageContext.asValue(guestValue).toString());
            }
            return guestValue;
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    RuntimeException illegalProxy(String message, Object ... parameters) {
        throw PolyglotImpl.wrapHostException(this.languageContext, new IllegalStateException(String.format(message, parameters)));
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object readMember(String member, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException, UnknownIdentifierException {
        if (this.proxy instanceof ProxyObject) {
            if (!this.isMemberExisting(member, library)) {
                throw UnknownIdentifierException.create(member);
            }
            Object result = GuestToHostRootNode.guestToHostCall(library, GET_MEMBER, this.languageContext, this.proxy, member);
            return this.languageContext.toGuestValue(result);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void writeMember(String member, Object value, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (!(this.proxy instanceof ProxyObject)) {
            throw UnsupportedMessageException.create();
        }
        Value castValue = this.languageContext.asValue(value);
        GuestToHostRootNode.guestToHostCall(library, PUT_MEMBER, this.languageContext, this.proxy, member, castValue);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Object invokeMember(String member, Object[] arguments, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="executables") @CachedLibrary(limit="LIMIT") InteropLibrary executables) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
        if (this.proxy instanceof ProxyObject) {
            Object memberObject;
            if (!this.isMemberExisting(member, library)) {
                throw UnknownIdentifierException.create(member);
            }
            try {
                memberObject = this.readMember(member, library);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            memberObject = this.languageContext.toGuestValue(memberObject);
            if (executables.isExecutable(memberObject)) {
                return executables.execute(memberObject, arguments);
            }
            throw UnsupportedMessageException.create();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInvocable(String member, @CachedLibrary(value="this") InteropLibrary library, @Cached.Shared(value="executables") @CachedLibrary(limit="LIMIT") InteropLibrary executables) {
        if (this.proxy instanceof ProxyObject && this.isMemberExisting(member, library)) {
            try {
                return executables.isExecutable(this.readMember(member, library));
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                return false;
            }
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    void removeMember(String member, @CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException, UnknownIdentifierException {
        if (this.proxy instanceof ProxyObject) {
            if (!this.isMemberExisting(member, library)) {
                throw UnknownIdentifierException.create(member);
            }
            boolean result = (Boolean)GuestToHostRootNode.guestToHostCall(library, REMOVE_MEMBER, this.languageContext, this.proxy, member);
            if (!result) {
                throw UnknownIdentifierException.create(member);
            }
        } else {
            throw UnsupportedMessageException.create();
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberModifiable"), @ExportMessage(name="isMemberRemovable")})
    @CompilerDirectives.TruffleBoundary
    boolean isMemberExisting(String member, @CachedLibrary(value="this") InteropLibrary library) {
        if (this.proxy instanceof ProxyObject) {
            return (Boolean)GuestToHostRootNode.guestToHostCall(library, HAS_MEMBER, this.languageContext, this.proxy, member);
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    boolean isMemberInsertable(String member, @CachedLibrary(value="this") InteropLibrary library) {
        if (this.proxy instanceof ProxyObject) {
            return !this.isMemberExisting(member, library);
        }
        return false;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isDate() {
        return this.proxy instanceof ProxyDate;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isTime() {
        return this.proxy instanceof ProxyTime;
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isTimeZone() {
        return this.proxy instanceof ProxyTimeZone;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    ZoneId asTimeZone(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyTimeZone) {
            return (ZoneId)GuestToHostRootNode.guestToHostCall(library, AS_TIMEZONE, this.languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalDate asDate(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyDate) {
            return (LocalDate)GuestToHostRootNode.guestToHostCall(library, AS_DATE, this.languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    LocalTime asTime(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyTime) {
            return (LocalTime)GuestToHostRootNode.guestToHostCall(library, AS_TIME, this.languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    Instant asInstant(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyInstant) {
            return (Instant)GuestToHostRootNode.guestToHostCall(library, AS_INSTANT, this.languageContext, this.proxy);
        }
        if (this.isDate() && this.isTime() && this.isTimeZone()) {
            return ZonedDateTime.of(this.asDate(library), this.asTime(library), this.asTimeZone(library)).toInstant();
        }
        throw UnsupportedMessageException.create();
    }

    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    boolean isDuration() {
        return this.proxy instanceof ProxyDuration;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    Duration asDuration(@CachedLibrary(value="this") InteropLibrary library) throws UnsupportedMessageException {
        if (this.proxy instanceof ProxyDuration) {
            return (Duration)GuestToHostRootNode.guestToHostCall(library, AS_DURATION, this.languageContext, this.proxy);
        }
        throw UnsupportedMessageException.create();
    }

    public static boolean isProxyGuestObject(TruffleObject value) {
        return value instanceof PolyglotProxy;
    }

    public static boolean isProxyGuestObject(Object value) {
        return value instanceof PolyglotProxy;
    }

    public static Object withContext(PolyglotLanguageContext context, Object valueReceiver) {
        return new PolyglotProxy(context, ((PolyglotProxy)valueReceiver).proxy);
    }

    public static Proxy toProxyHostObject(TruffleObject value) {
        return ((PolyglotProxy)value).proxy;
    }

    public static TruffleObject toProxyGuestObject(PolyglotLanguageContext context, Proxy receiver) {
        return new PolyglotProxy(context, receiver);
    }

    static class AsDurationNode
    extends GuestToHostRootNode {
        protected AsDurationNode() {
            super(ProxyDuration.class, "asDuration");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            Duration duration = ((ProxyDuration)proxy).asDuration();
            if (duration == null) {
                throw new AssertionError((Object)"The returned duration must not be null.");
            }
            return duration;
        }
    }

    static class AsInstantNode
    extends GuestToHostRootNode {
        protected AsInstantNode() {
            super(ProxyInstant.class, "asInstant");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            Instant instant = ((ProxyInstant)proxy).asInstant();
            if (instant == null) {
                throw new AssertionError((Object)"The returned instant must not be null.");
            }
            return instant;
        }
    }

    static class AsTimeNode
    extends GuestToHostRootNode {
        protected AsTimeNode() {
            super(ProxyTime.class, "asTime");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            LocalTime time = ((ProxyTime)proxy).asTime();
            if (time == null) {
                CompilerDirectives.transferToInterpreter();
                throw new AssertionError((Object)"The returned time must not be null.");
            }
            return time;
        }
    }

    static class AsDateNode
    extends GuestToHostRootNode {
        protected AsDateNode() {
            super(ProxyDate.class, "asDate");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            LocalDate date = ((ProxyDate)proxy).asDate();
            if (date == null) {
                throw new AssertionError((Object)"The returned date must not be null.");
            }
            return date;
        }
    }

    static class AsTimeZoneNode
    extends GuestToHostRootNode {
        protected AsTimeZoneNode() {
            super(ProxyTimeZone.class, "asTimeZone");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            ZoneId zone = ((ProxyTimeZone)proxy).asTimeZone();
            if (zone == null) {
                throw new AssertionError((Object)"The returned zone must not be null.");
            }
            return zone;
        }
    }

    static class HasMemberNode
    extends GuestToHostRootNode {
        protected HasMemberNode() {
            super(ProxyObject.class, "hasMember");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyObject)proxy).hasMember((String)arguments[2]);
        }
    }

    static class RemoveMemberNode
    extends GuestToHostRootNode {
        protected RemoveMemberNode() {
            super(ProxyObject.class, "removeMember");
        }

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return RemoveMemberNode.removeBoundary((ProxyObject)proxy, (String)arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean removeBoundary(ProxyObject proxy, String member) {
            return proxy.removeMember(member);
        }
    }

    static class PutMemberNode
    extends GuestToHostRootNode {
        protected PutMemberNode() {
            super(ProxyObject.class, "putMember");
        }

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                PutMemberNode.boundaryPutMember((ProxyObject)proxy, (String)arguments[2], (Value)arguments[3]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static void boundaryPutMember(ProxyObject proxy, String member, Value value) {
            proxy.putMember(member, value);
        }
    }

    static class GetMemberNode
    extends GuestToHostRootNode {
        protected GetMemberNode() {
            super(ProxyObject.class, "getMember");
        }

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return GetMemberNode.boundaryGetMember((ProxyObject)proxy, (String)arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object boundaryGetMember(ProxyObject proxy, String argument) {
            return proxy.getMember(argument);
        }
    }

    static class GetMemberKeysNode
    extends GuestToHostRootNode {
        protected GetMemberKeysNode() {
            super(ProxyObject.class, "getMemberKeys");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyObject)proxy).getMemberKeys();
        }
    }

    static class ArraySizeNode
    extends GuestToHostRootNode {
        protected ArraySizeNode() {
            super(ProxyArray.class, "getSize");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyArray)proxy).getSize();
        }
    }

    static class ArrayRemoveNode
    extends GuestToHostRootNode {
        protected ArrayRemoveNode() {
            super(ProxyArray.class, "remove");
        }

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                return ArrayRemoveNode.boundaryRemove((ProxyArray)proxy, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean boundaryRemove(ProxyArray proxy, long index) {
            return proxy.remove(index);
        }
    }

    static class ArraySetNode
    extends GuestToHostRootNode {
        protected ArraySetNode() {
            super(ProxyArray.class, "set");
        }

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                ArraySetNode.boundarySet((ProxyArray)proxy, index, (Value)arguments[3]);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static void boundarySet(ProxyArray proxy, long index, Value value) {
            proxy.set(index, value);
        }
    }

    static class ArrayGetNode
    extends GuestToHostRootNode {
        protected ArrayGetNode() {
            super(ProxyArray.class, "get");
        }

        @Override
        protected Object executeImpl(Object proxy, Object[] arguments) throws InvalidArrayIndexException, UnsupportedMessageException {
            long index = (Long)arguments[2];
            try {
                return ArrayGetNode.boundaryGet((ProxyArray)proxy, index);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw InvalidArrayIndexException.create(index);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object boundaryGet(ProxyArray proxy, long index) {
            return proxy.get(index);
        }
    }

    static class AsPointerNode
    extends GuestToHostRootNode {
        protected AsPointerNode() {
            super(ProxyNativeObject.class, "asPointer");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) {
            return ((ProxyNativeObject)proxy).asPointer();
        }
    }

    static class ExecuteNode
    extends GuestToHostRootNode {
        protected ExecuteNode() {
            super(ProxyExecutable.class, "execute");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return ((ProxyExecutable)proxy).execute((Value[])arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }

    static class InstantiateNode
    extends GuestToHostRootNode {
        protected InstantiateNode() {
            super(ProxyInstantiable.class, "newInstance");
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected Object executeImpl(Object proxy, Object[] arguments) throws UnsupportedMessageException {
            try {
                return ((ProxyInstantiable)proxy).newInstance((Value[])arguments[2]);
            }
            catch (UnsupportedOperationException e) {
                throw UnsupportedMessageException.create();
            }
        }
    }
}

