/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.source;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.impl.Accessor;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Set;

final class SourceAccessor
extends Accessor {
    static final SourceAccessor ACCESSOR = new SourceAccessor();

    private SourceAccessor() {
    }

    public static void load() {
    }

    static String getMimeType(TruffleFile file, Set<String> validMimeTypes) throws IOException {
        return ACCESSOR.languageSupport().getMimeType(file, validMimeTypes);
    }

    static Charset getEncoding(TruffleFile file, String mimeType) throws IOException {
        return ACCESSOR.languageSupport().getEncoding(file, mimeType);
    }

    static Object getCurrentFileSystemContext() {
        return ACCESSOR.languageSupport().getCurrentFileSystemContext();
    }

    static TruffleFile getTruffleFile(URI uri, Object fileSystemContext) {
        return ACCESSOR.languageSupport().getTruffleFile(uri, fileSystemContext);
    }

    static TruffleFile getTruffleFile(String path, Object fileSystemContext) {
        return ACCESSOR.languageSupport().getTruffleFile(path, fileSystemContext);
    }

    static boolean isDefaultFileSystem(Object fileSystemContext) {
        return ACCESSOR.languageSupport().isDefaultFileSystem(fileSystemContext);
    }

    static final class SourceSupportImpl
    extends Accessor.SourceSupport {
        SourceSupportImpl() {
        }

        @Override
        public Source copySource(Source source) {
            return source.copy();
        }

        @Override
        public Object getSourceIdentifier(Source source) {
            return source.getSourceId();
        }

        @Override
        public org.graalvm.polyglot.Source getPolyglotSource(Source source) {
            return source.polyglotSource;
        }

        @Override
        public void setPolyglotSource(Source source, org.graalvm.polyglot.Source polyglotSource) {
            source.polyglotSource = polyglotSource;
        }

        @Override
        public String findMimeType(URL url, Object fileSystemContext) throws IOException {
            return Source.findMimeType(url, url.openConnection(), null, fileSystemContext);
        }

        @Override
        public Source.SourceBuilder newBuilder(String language, File origin) {
            return Source.newBuilder(language, origin);
        }

        @Override
        public boolean isLegacySource(Source source) {
            return source.isLegacy();
        }

        @Override
        public void setFileSystemContext(Source.SourceBuilder builder, Object fileSystemContext) {
            builder.embedderFileSystemContext(fileSystemContext);
        }
    }
}

