/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropAccessNode;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.KnownMessage;
import com.oracle.truffle.api.interop.LibraryToLegacy;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;

final class LegacyToLibraryNode
extends Node {
    private static final int LIMIT = 5;
    final Message message;
    @Node.Child
    private InteropLibrary interop;
    @Node.Child
    private InteropAccessNode legacyUnbox;
    @Node.Child
    private InteropAccessNode legacyIsBoxed;
    @Node.Child
    private InteropAccessNode legacyToNative;
    @Node.Child
    private InteropAccessNode legacyRemove;

    private LegacyToLibraryNode(Message message) {
        this.message = message;
        this.interop = this.insert(InteropLibrary.getFactory().createDispatched(5));
        this.legacyUnbox = this.insert(InteropAccessNode.create(Message.UNBOX));
        this.legacyIsBoxed = this.insert(InteropAccessNode.create(Message.IS_BOXED));
        this.legacyToNative = this.insert(InteropAccessNode.create(Message.TO_NATIVE));
        this.legacyRemove = this.insert(InteropAccessNode.create(Message.REMOVE));
    }

    static LegacyToLibraryNode create(Message message) {
        if (message instanceof KnownMessage) {
            return new AdoptRootNode().insertAccess(new LegacyToLibraryNode(message));
        }
        throw new IllegalArgumentException();
    }

    Object sendRead(TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        if (identifier instanceof String) {
            return this.interop.readMember(receiver, (String)identifier);
        }
        if (identifier instanceof Number) {
            try {
                long index = LegacyToLibraryNode.asLongIndex(identifier);
                return this.interop.readArrayElement(receiver, index);
            }
            catch (InvalidArrayIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(e.getInvalidIndex()));
            }
        }
        CompilerDirectives.transferToInterpreter();
        if (identifier instanceof TruffleObject) {
            CompilerDirectives.transferToInterpreter();
            TruffleObject identifierTO = (TruffleObject)identifier;
            if (LibraryToLegacy.sendIsBoxed(this.legacyIsBoxed, identifierTO)) {
                try {
                    return this.sendRead(receiver, LibraryToLegacy.sendUnbox(this.legacyUnbox, identifierTO));
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
        }
        throw UnsupportedMessageException.create();
    }

    private static long asLongIndex(Object identifier) {
        if (identifier instanceof Integer) {
            return ((Integer)identifier).intValue();
        }
        if (identifier instanceof Long) {
            return (Long)identifier;
        }
        return LegacyToLibraryNode.boundaryToLong(identifier);
    }

    void sendWrite(TruffleObject receiver, Object identifier, Object value) throws UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        if (identifier instanceof String) {
            this.interop.writeMember(receiver, (String)identifier, value);
        } else if (identifier instanceof Number) {
            try {
                long index = LegacyToLibraryNode.asLongIndex(identifier);
                this.interop.writeArrayElement(receiver, index, value);
            }
            catch (InvalidArrayIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(e.getInvalidIndex()));
            }
        } else {
            CompilerDirectives.transferToInterpreter();
            if (identifier instanceof TruffleObject) {
                CompilerDirectives.transferToInterpreter();
                TruffleObject identifierTO = (TruffleObject)identifier;
                if (LibraryToLegacy.sendIsBoxed(this.legacyIsBoxed, identifierTO)) {
                    try {
                        this.sendWrite(receiver, LibraryToLegacy.sendUnbox(this.legacyUnbox, identifierTO), value);
                        return;
                    }
                    catch (UnsupportedMessageException unsupportedMessageException) {
                        // empty catch block
                    }
                }
            }
            throw UnsupportedMessageException.create();
        }
    }

    boolean sendRemove(TruffleObject receiver, Object identifier) throws UnknownIdentifierException, UnsupportedMessageException {
        if (identifier instanceof String) {
            if (receiver.getForeignAccess() != null) {
                return LibraryToLegacy.sendRemove(this.legacyRemove, receiver, identifier);
            }
            this.interop.removeMember(receiver, (String)identifier);
            return true;
        }
        if (identifier instanceof Number) {
            try {
                if (receiver.getForeignAccess() != null) {
                    return LibraryToLegacy.sendRemove(this.legacyRemove, receiver, identifier);
                }
                long index = LegacyToLibraryNode.asLongIndex(identifier);
                this.interop.removeArrayElement(receiver, index);
                return true;
            }
            catch (InvalidArrayIndexException e) {
                CompilerDirectives.transferToInterpreter();
                throw UnknownIdentifierException.raise(String.valueOf(e.getInvalidIndex()));
            }
        }
        CompilerDirectives.transferToInterpreter();
        if (identifier instanceof TruffleObject) {
            CompilerDirectives.transferToInterpreter();
            TruffleObject identifierTO = (TruffleObject)identifier;
            if (LibraryToLegacy.sendIsBoxed(this.legacyIsBoxed, identifierTO)) {
                try {
                    return this.sendRemove(receiver, LibraryToLegacy.sendUnbox(this.legacyUnbox, identifierTO));
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
        }
        throw UnsupportedMessageException.create();
    }

    Object sendUnbox(TruffleObject receiver) throws UnsupportedMessageException {
        if (receiver.getForeignAccess() != null) {
            return LibraryToLegacy.sendUnbox(this.legacyUnbox, receiver);
        }
        if (this.interop.isNumber(receiver)) {
            if (this.interop.fitsInByte(receiver)) {
                return this.interop.asByte(receiver);
            }
            if (this.interop.fitsInShort(receiver)) {
                return this.interop.asShort(receiver);
            }
            if (this.interop.fitsInInt(receiver)) {
                return this.interop.asInt(receiver);
            }
            if (this.interop.fitsInLong(receiver)) {
                return this.interop.asLong(receiver);
            }
            if (this.interop.fitsInFloat(receiver)) {
                return Float.valueOf(this.interop.asFloat(receiver));
            }
            if (this.interop.fitsInDouble(receiver)) {
                return this.interop.asDouble(receiver);
            }
        } else {
            if (this.interop.isString(receiver)) {
                return this.interop.asString(receiver);
            }
            if (this.interop.isBoolean(receiver)) {
                return this.interop.asBoolean(receiver);
            }
        }
        CompilerDirectives.transferToInterpreter();
        throw UnsupportedMessageException.create();
    }

    boolean sendIsPointer(TruffleObject receiver) {
        return this.interop.isPointer(receiver);
    }

    long sendAsPointer(TruffleObject receiver) throws UnsupportedMessageException {
        return this.interop.asPointer(receiver);
    }

    Object sendToNative(TruffleObject receiver) throws UnsupportedMessageException {
        if (receiver.getForeignAccess() != null) {
            return LibraryToLegacy.sendToNative(this.legacyToNative, receiver);
        }
        this.interop.toNative(receiver);
        return receiver;
    }

    Object sendExecute(TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        return this.interop.execute(receiver, arguments);
    }

    boolean sendIsExecutable(TruffleObject receiver) {
        return this.interop.isExecutable(receiver);
    }

    boolean sendIsInstantiable(TruffleObject receiver) {
        return this.interop.isInstantiable(receiver);
    }

    Object sendInvoke(TruffleObject receiver, String identifier, Object ... arguments) throws UnsupportedTypeException, ArityException, UnknownIdentifierException, UnsupportedMessageException {
        return this.interop.invokeMember(receiver, identifier, arguments);
    }

    Object sendNew(TruffleObject receiver, Object ... arguments) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        return this.interop.instantiate(receiver, arguments);
    }

    boolean sendIsNull(TruffleObject receiver) {
        return this.interop.isNull(receiver);
    }

    boolean sendHasSize(TruffleObject receiver) {
        return this.interop.hasArrayElements(receiver);
    }

    Object sendGetSize(TruffleObject receiver) throws UnsupportedMessageException {
        return (int)this.interop.getArraySize(receiver);
    }

    boolean sendIsBoxed(TruffleObject receiver) {
        if (this.interop.isNumber(receiver)) {
            if (this.interop.fitsInLong(receiver)) {
                return true;
            }
            return this.interop.fitsInDouble(receiver);
        }
        if (this.interop.isString(receiver)) {
            return true;
        }
        return this.interop.isBoolean(receiver);
    }

    int sendKeyInfo(TruffleObject receiver, Object key) {
        int keyInfo = 0;
        if (key instanceof String) {
            String identifier = (String)key;
            if (this.interop.isMemberReadable(receiver, identifier)) {
                keyInfo |= 2;
            }
            if (this.interop.isMemberModifiable(receiver, identifier)) {
                keyInfo |= 4;
            }
            if (this.interop.isMemberInsertable(receiver, identifier)) {
                keyInfo |= 0x40;
            }
            if (this.interop.isMemberRemovable(receiver, identifier)) {
                keyInfo |= 0x20;
            }
            if (this.interop.isMemberInvocable(receiver, identifier)) {
                keyInfo |= 8;
            }
            if (this.interop.isMemberInternal(receiver, identifier)) {
                keyInfo |= 0x10;
            }
            if (this.interop.hasMemberReadSideEffects(receiver, identifier)) {
                keyInfo |= 0x80;
            }
            if (this.interop.hasMemberWriteSideEffects(receiver, identifier)) {
                keyInfo |= 0x100;
            }
        } else if (key instanceof Number) {
            long index = LegacyToLibraryNode.asLongIndex(key);
            if ((key instanceof Float || key instanceof Double) && (double)index != ((Number)key).doubleValue()) {
                return 0;
            }
            if (this.interop.isArrayElementReadable(receiver, index)) {
                keyInfo |= 2;
            }
            if (this.interop.isArrayElementModifiable(receiver, index)) {
                keyInfo |= 4;
            }
            if (this.interop.isArrayElementInsertable(receiver, index)) {
                keyInfo |= 0x40;
            }
            if (this.interop.isArrayElementRemovable(receiver, index)) {
                keyInfo |= 0x20;
            }
        } else if (key instanceof TruffleObject) {
            CompilerDirectives.transferToInterpreter();
            if (key instanceof TruffleObject) {
                CompilerDirectives.transferToInterpreter();
                TruffleObject identifierTO = (TruffleObject)key;
                if (LibraryToLegacy.sendIsBoxed(this.legacyIsBoxed, identifierTO)) {
                    try {
                        return this.sendKeyInfo(receiver, LibraryToLegacy.sendUnbox(this.legacyUnbox, identifierTO));
                    }
                    catch (UnsupportedMessageException unsupportedMessageException) {
                        // empty catch block
                    }
                }
            }
        }
        return keyInfo;
    }

    @CompilerDirectives.TruffleBoundary
    private static long boundaryToLong(Object key) {
        return ((Number)key).longValue();
    }

    boolean sendHasKeys(TruffleObject receiver) {
        return this.interop.hasMembers(receiver);
    }

    TruffleObject sendKeys(TruffleObject receiver) throws UnsupportedMessageException {
        return (TruffleObject)this.interop.getMembers(receiver);
    }

    TruffleObject sendKeys(TruffleObject receiver, boolean includeInternal) throws UnsupportedMessageException {
        return (TruffleObject)this.interop.getMembers(receiver, includeInternal);
    }

    Object send(TruffleObject receiver, Object[] a) throws InteropException {
        if (this.message instanceof KnownMessage) {
            switch (this.message.hashCode()) {
                case 423438: {
                    Object id = a.length >= 1 ? a[0] : null;
                    return this.sendRead(receiver, id);
                }
                case 423431: {
                    Object id = a.length >= 1 ? a[0] : null;
                    Object value = a.length >= 2 ? a[1] : null;
                    this.sendWrite(receiver, id, value);
                    return a[1];
                }
                case 423443: {
                    Object id = a.length >= 1 ? a[0] : null;
                    return this.sendRemove(receiver, id);
                }
                case 423440: {
                    Object id = a.length >= 1 ? a[0] : null;
                    return this.sendKeyInfo(receiver, id);
                }
                case 423429: {
                    Object[] args;
                    Object id;
                    Object object = id = a.length >= 1 ? a[0] : null;
                    if (a.length >= 2) {
                        args = new Object[a.length - 1];
                        System.arraycopy(a, 1, args, 0, args.length);
                    } else {
                        args = new Object[]{};
                    }
                    return this.sendInvoke(receiver, (String)id, args);
                }
                case 423441: {
                    return this.sendHasKeys(receiver);
                }
                case 423439: {
                    return this.sendKeys(receiver);
                }
                case 423437: {
                    return this.sendUnbox(receiver);
                }
                case 423434: {
                    return this.sendIsBoxed(receiver);
                }
                case 423433: {
                    return this.sendHasSize(receiver);
                }
                case 423432: {
                    return this.sendGetSize(receiver);
                }
                case 423430: {
                    return this.sendExecute(receiver, a);
                }
                case 423435: {
                    return this.sendIsExecutable(receiver);
                }
                case 423428: {
                    return this.sendNew(receiver, a);
                }
                case 423442: {
                    return this.sendIsInstantiable(receiver);
                }
                case 423531: {
                    return this.sendIsPointer(receiver);
                }
                case 423532: {
                    return this.sendAsPointer(receiver);
                }
                case 423533: {
                    return this.sendToNative(receiver);
                }
                case 423436: {
                    return this.sendIsNull(receiver);
                }
            }
        }
        throw UnsupportedMessageException.create();
    }

    static final class AdoptRootNode
    extends RootNode {
        AdoptRootNode() {
            super(null);
        }

        @Override
        public Object execute(VirtualFrame frame) {
            assert (false);
            return null;
        }

        LegacyToLibraryNode insertAccess(LegacyToLibraryNode node) {
            return this.insert(node);
        }
    }
}

