/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projectsui;

import java.awt.Color;
import java.awt.IllegalComponentStateException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.editor.JumpList;
import org.netbeans.modules.debugger.jpda.projects.ASTOperationCreationDelegate;
import org.netbeans.modules.debugger.jpda.projects.EditorContextSupport;
import org.netbeans.modules.debugger.jpda.projectsui.DebuggerAnnotation;
import org.netbeans.modules.debugger.jpda.projectsui.DebuggerBreakpointAnnotation;
import org.netbeans.modules.debugger.jpda.projectsui.LineTranslations;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.jpda.Evaluator;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Pair;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting", "true");
    private static final Logger logger = Logger.getLogger(EditorContextImpl.class.getName());
    private PropertyChangeSupport pcs;
    private Map<Annotation, String> annotationToURL = new HashMap<Annotation, String>();
    private final Object annotationToURLLock = new Object();
    private PropertyChangeListener dispatchListener;
    private EditorContextDispatcher contextDispatcher;

    public EditorContextImpl() {
        this.pcs = new PropertyChangeSupport((Object)this);
        this.dispatchListener = new EditorContextDispatchListener();
        this.contextDispatcher = EditorContextDispatcher.getDefault();
        this.contextDispatcher.addPropertyChangeListener("text/x-java", WeakListeners.propertyChange((PropertyChangeListener)this.dispatchListener, (Object)this.contextDispatcher));
    }

    public boolean showSource(String url, int lineNumber, Object timeStamp) {
        Line l = EditorContextImpl.showSourceLine(url, lineNumber, timeStamp);
        if (l != null) {
            this.addPositionToJumpList(url, l, 0);
        }
        return l != null;
    }

    static Line showSourceLine(String url, int lineNumber, Object timeStamp) {
        Line l = LineTranslations.getTranslations().getLine(url, lineNumber, timeStamp);
        if (l == null) {
            ErrorManager.getDefault().log(16, "Show Source: Have no line for URL = " + url + ", line number = " + lineNumber);
            return null;
        }
        Properties p = Properties.getDefault().getProperties("debugger.options.JPDA");
        boolean reuseEditorTabs = p.getBoolean("ReuseEditorTabs", true);
        if ("true".equalsIgnoreCase(fronting)) {
            if (reuseEditorTabs) {
                l.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
            } else {
                l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
        } else if (reuseEditorTabs) {
            l.show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS);
        } else {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }
        return l;
    }

    public boolean showSource(String url, int lineNumber, int column, int length, Object timeStamp) {
        Line l = LineTranslations.getTranslations().getLine(url, lineNumber, timeStamp);
        if (l == null) {
            ErrorManager.getDefault().log(16, "Show Source: Have no line for URL = " + url + ", line number = " + lineNumber);
            return false;
        }
        if ("true".equalsIgnoreCase(fronting)) {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT, column);
        } else {
            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS, column);
        }
        this.addPositionToJumpList(url, l, column);
        return true;
    }

    private void addPositionToJumpList(String url, Line l, int column) {
        EditorCookie ec;
        DataObject dataObject = EditorContextImpl.getDataObject(url);
        if (dataObject != null && (ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class)) != null) {
            try {
                StyledDocument doc = ec.openDocument();
                JEditorPane[] eps = ec.getOpenedPanes();
                if (eps != null && eps.length > 0) {
                    JumpList.addEntry((JTextComponent)eps[0], (int)(NbDocument.findLineOffset((StyledDocument)doc, (int)l.getLineNumber()) + column));
                }
            }
            catch (IOException ioex) {
                ErrorManager.getDefault().notify((Throwable)ioex);
            }
        }
    }

    public void createTimeStamp(Object timeStamp) {
        LineTranslations.getTranslations().createTimeStamp(timeStamp);
    }

    public void disposeTimeStamp(Object timeStamp) {
        LineTranslations.getTranslations().disposeTimeStamp(timeStamp);
    }

    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp) {
        return this.annotate(url, lineNumber, annotationType, timeStamp, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object annotate(String url, int lineNumber, String annotationType, Object timeStamp, JPDAThread thread) {
        Line l = LineTranslations.getTranslations().getLine(url, lineNumber, timeStamp instanceof Breakpoint ? null : timeStamp);
        if (l == null) {
            return null;
        }
        Object annotation = timeStamp instanceof Breakpoint ? new DebuggerBreakpointAnnotation(annotationType, l, (Breakpoint)timeStamp) : new DebuggerAnnotation(annotationType, l, thread);
        Object object = this.annotationToURLLock;
        synchronized (object) {
            assert (url != null);
            this.annotationToURL.put((Annotation)annotation, url);
        }
        return annotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object annotate(String url, int startPosition, int endPosition, String annotationType, Object timeStamp) {
        DebuggerAnnotation annotation;
        AttributeSet attrs = "LastOperation".equals(annotationType) ? AttributesUtilities.createImmutable((Object[])new Object[]{EditorStyleConstants.WaveUnderlineColor, EditorContextImpl.getColor(annotationType)}) : AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, EditorContextImpl.getColor(annotationType)});
        try {
            annotation = new DebuggerAnnotation(annotationType, attrs, startPosition, endPosition, URLMapper.findFileObject((URL)new URL(url)));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException("Bad URL: " + url, ex);
        }
        Object object = this.annotationToURLLock;
        synchronized (object) {
            assert (url != null);
            this.annotationToURL.put(annotation, url);
        }
        return annotation;
    }

    private static Color getColor(String annotationType) {
        if (annotationType.endsWith("_broken")) {
            annotationType = annotationType.substring(0, annotationType.length() - "_broken".length());
        }
        if ("Breakpoint".equals(annotationType)) {
            return EditorContextImpl.getHighlight(annotationType, 16555423);
        }
        if ("CurrentPC".equals(annotationType) || "StepOutOperation".equals(annotationType)) {
            return EditorContextImpl.getHighlight(annotationType, 12445354);
        }
        if ("LastOperation".equals(annotationType)) {
            return EditorContextImpl.getHighlight(annotationType, 10075018);
        }
        return new Color(255);
    }

    private static Color getHighlight(String name, int defaultRGB) {
        AttributeSet as;
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(FontColorSettings.class);
        AttributeSet attributeSet = as = fcs != null ? fcs.getFontColors(name) : null;
        if (as != null) {
            return (Color)as.getAttribute(StyleConstants.Background);
        }
        return new Color(defaultRGB);
    }

    public void removeAnnotation(Object a) {
        if (a instanceof Collection) {
            Collection annotations = (Collection)a;
            Iterator it = annotations.iterator();
            while (it.hasNext()) {
                this.removeAnnotation((Annotation)it.next());
            }
        } else {
            this.removeAnnotation((Annotation)a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAnnotation(Annotation annotation) {
        Object object = this.annotationToURLLock;
        synchronized (object) {
            String url = this.annotationToURL.remove(annotation);
            assert (url != null);
        }
        annotation.detach();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineNumber(Object annotation, Object timeStamp) {
        String url;
        if (annotation instanceof LineBreakpoint) {
            LineBreakpoint lb = (LineBreakpoint)annotation;
            return LineTranslations.getTranslations().getOriginalLineNumber(lb, timeStamp);
        }
        Line line = annotation instanceof DebuggerBreakpointAnnotation ? ((DebuggerBreakpointAnnotation)((Object)annotation)).getLine() : ((DebuggerAnnotation)((Object)annotation)).getLine();
        if (timeStamp == null) {
            return line.getLineNumber() + 1;
        }
        Object object = this.annotationToURLLock;
        synchronized (object) {
            url = this.annotationToURL.get((Annotation)annotation);
            assert (url != null);
        }
        Line.Set lineSet = LineTranslations.getTranslations().getLineSet(url, timeStamp);
        return lineSet.getOriginalLineNumber(line) + 1;
    }

    public void updateTimeStamp(Object timeStamp, String url) {
        LineTranslations.getTranslations().updateTimeStamp(timeStamp, url);
    }

    public int getCurrentLineNumber() {
        return this.contextDispatcher.getCurrentLineNumber();
    }

    public int getCurrentOffset() {
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        if (ep == null) {
            return -1;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return -1;
        }
        return caret.getDot();
    }

    public String getCurrentClassName() {
        String currentClass = this.getCurrentElement(ElementKind.CLASS);
        if (currentClass == null) {
            return "";
        }
        return currentClass;
    }

    public String getMostRecentClassName() {
        String clazz = this.getMostRecentElement(ElementKind.CLASS);
        if (clazz == null) {
            return "";
        }
        return clazz;
    }

    public String getCurrentURL() {
        return this.contextDispatcher.getCurrentURLAsString();
    }

    public String getCurrentMethodName() {
        String currentMethod = this.getCurrentElement(ElementKind.METHOD);
        if (currentMethod == null) {
            return "";
        }
        return currentMethod;
    }

    public String getMostRecentMethodName() {
        String method = this.getMostRecentElement(ElementKind.METHOD);
        if (method == null) {
            return "";
        }
        return method;
    }

    public String getCurrentMethodSignature() {
        final String[] elementSignaturePtr = new String[]{null};
        try {
            this.getCurrentElement(ElementKind.METHOD, elementSignaturePtr);
        }
        catch (IllegalComponentStateException icse) {
            throw new IllegalComponentStateException(){

                @Override
                public String getMessage() {
                    icse.getMessage();
                    return elementSignaturePtr[0];
                }
            };
        }
        return elementSignaturePtr[0];
    }

    public String getMostRecentMethodSignature() {
        final String[] elementSignaturePtr = new String[]{null};
        try {
            this.getMostRecentElement(ElementKind.METHOD, elementSignaturePtr);
        }
        catch (IllegalComponentStateException icse) {
            throw new IllegalComponentStateException(){

                @Override
                public String getMessage() {
                    icse.getMessage();
                    return elementSignaturePtr[0];
                }
            };
        }
        return elementSignaturePtr[0];
    }

    public String getCurrentFieldName() {
        String currentField = this.getCurrentElement(ElementKind.FIELD);
        if (currentField == null) {
            return "";
        }
        return currentField;
    }

    public String getMostRecentFieldName() {
        String field = this.getMostRecentElement(ElementKind.FIELD);
        if (field == null) {
            return "";
        }
        return field;
    }

    public String getSelectedIdentifier() {
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        if (ep == null) {
            return null;
        }
        Caret caret = ep.getCaret();
        if (caret == null) {
            return null;
        }
        String s = ep.getSelectedText();
        if (s == null) {
            return null;
        }
        if (Utilities.isJavaIdentifier((String)s)) {
            return s;
        }
        return null;
    }

    public String getSelectedMethodName() {
        if (SwingUtilities.isEventDispatchThread()) {
            return this.getSelectedMethodName_();
        }
        final String[] mn = new String[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    mn[0] = EditorContextImpl.this.getSelectedMethodName_();
                }
            });
        }
        catch (InvocationTargetException ex) {
            ErrorManager.getDefault().notify(ex.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return mn[0];
    }

    private String getSelectedMethodName_() {
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        if (ep == null) {
            return "";
        }
        StyledDocument doc = (StyledDocument)ep.getDocument();
        if (doc == null) {
            return "";
        }
        int offset = ep.getCaret().getDot();
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return "";
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            String t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && Character.isJavaIdentifierPart(t.charAt(identStart - 1)); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            int i = t.indexOf(40, identEnd);
            if (i < 0) {
                return "";
            }
            if (t.substring(identEnd, i).trim().length() > 0) {
                return "";
            }
            if (identStart == identEnd) {
                return "";
            }
            return t.substring(identStart, identEnd);
        }
        catch (BadLocationException ex) {
            return "";
        }
    }

    public int getFieldLineNumber(String url, String className, String fieldName) {
        return EditorContextSupport.getFieldLineNumber((String)url, (String)className, (String)fieldName);
    }

    public int getMethodLineNumber(String url, String className, String methodName, String methodSignature) {
        return EditorContextSupport.getMethodLineNumber((String)url, (String)className, (String)methodName, (String)methodSignature);
    }

    public String getCurrentClassDeclaration() {
        FileObject fo = this.contextDispatcher.getCurrentFile();
        if (fo == null) {
            return null;
        }
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        int currentOffset = ep == null ? 0 : ep.getCaretPosition();
        return EditorContextSupport.getClassDeclaredAt((FileObject)fo, (int)currentOffset);
    }

    public String[] getCurrentMethodDeclaration() {
        FileObject fo = this.contextDispatcher.getCurrentFile();
        if (fo == null) {
            return null;
        }
        JEditorPane ep = this.contextDispatcher.getCurrentEditor();
        int currentOffset = ep == null ? 0 : ep.getCaretPosition();
        return EditorContextSupport.getMethodDeclaredAt((FileObject)fo, (int)currentOffset);
    }

    public String getClassName(String url, int lineNumber) {
        return EditorContextSupport.getClassName((String)url, (int)lineNumber);
    }

    public EditorContext.Operation[] getOperations(String url, int lineNumber, EditorContext.BytecodeProvider bytecodeProvider) {
        return EditorContextSupport.getOperations((String)url, (int)lineNumber, (EditorContext.BytecodeProvider)bytecodeProvider, (ASTOperationCreationDelegate)new OperationCreationDelegateImpl());
    }

    private static int findLineOffset(StyledDocument doc, int lineNumber) {
        int offset;
        try {
            offset = NbDocument.findLineOffset((StyledDocument)doc, (int)(lineNumber - 1));
            int offset2 = NbDocument.findLineOffset((StyledDocument)doc, (int)lineNumber);
            try {
                String lineStr = doc.getText(offset, offset2 - offset);
                for (int i = 0; i < lineStr.length(); ++i) {
                    if (Character.isWhitespace(lineStr.charAt(i))) continue;
                    offset += i;
                    break;
                }
            }
            catch (BadLocationException badLocationException) {
            }
        }
        catch (IndexOutOfBoundsException ioobex) {
            return -1;
        }
        return offset;
    }

    public EditorContext.MethodArgument[] getArguments(String url, EditorContext.Operation operation) {
        return EditorContextSupport.getArguments((String)url, (EditorContext.Operation)operation, (ASTOperationCreationDelegate)new OperationCreationDelegateImpl());
    }

    public EditorContext.MethodArgument[] getArguments(String url, int methodLineNumber) {
        return EditorContextSupport.getArguments((String)url, (int)methodLineNumber, (ASTOperationCreationDelegate)new OperationCreationDelegateImpl());
    }

    public String[] getImports(String url) {
        return EditorContextSupport.getImports((String)url);
    }

    public <R, D> R interpretOrCompileCode(Evaluator.Expression<Object> expression, String url, int line, ErrorAwareTreePathScanner<Boolean, D> canInterpret, ErrorAwareTreePathScanner<R, D> interpreter, D context, boolean staticContext, Function<Pair<String, byte[]>, Boolean> compiledClassHandler, SourcePathProvider sp) throws InvalidExpressionException {
        return (R)EditorContextSupport.interpretOrCompileCode(expression, (String)url, (int)line, canInterpret, interpreter, context, (boolean)staticContext, compiledClassHandler, (SourcePathProvider)sp);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(propertyName, l);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(propertyName, l);
    }

    private String getCurrentElement(ElementKind kind) {
        return this.getCurrentElement(kind, null);
    }

    private String getMostRecentElement(ElementKind kind) {
        return this.getMostRecentElement(kind, null);
    }

    private String getCurrentElement(ElementKind kind, String[] elementSignaturePtr) throws IllegalComponentStateException {
        return this.getCurrentElement(this.contextDispatcher.getCurrentFile(), this.contextDispatcher.getCurrentEditor(), kind, elementSignaturePtr);
    }

    private String getMostRecentElement(ElementKind kind, String[] elementSignaturePtr) throws IllegalComponentStateException {
        return this.getCurrentElement(this.contextDispatcher.getMostRecentFile(), this.contextDispatcher.getMostRecentEditor(), kind, elementSignaturePtr);
    }

    private String getCurrentElement(FileObject fo, JEditorPane ep, ElementKind kind, String[] elementSignaturePtr) throws IllegalComponentStateException {
        String selectedIdentifier;
        int currentOffset;
        if (fo == null) {
            return null;
        }
        if (ep != null) {
            String s;
            Caret caret = ep.getCaret();
            if (caret == null) {
                s = null;
                currentOffset = 0;
            } else {
                s = ep.getSelectedText();
                currentOffset = ep.getCaretPosition();
                if (ep.getSelectionStart() > currentOffset || ep.getSelectionEnd() < currentOffset) {
                    s = null;
                }
            }
            selectedIdentifier = s != null && Utilities.isJavaIdentifier((String)s) ? s : null;
        } else {
            selectedIdentifier = null;
            currentOffset = 0;
        }
        return EditorContextSupport.getCurrentElement((FileObject)fo, (int)currentOffset, selectedIdentifier, (ElementKind)kind, (String[])elementSignaturePtr);
    }

    private static DataObject getDataObject(String url) {
        FileObject file;
        try {
            file = URLMapper.findFileObject((URL)new URL(url));
        }
        catch (MalformedURLException e) {
            return null;
        }
        if (file == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
    }

    private static StyledDocument findDocument(FileObject fo) {
        StyledDocument doc;
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fo);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            doc = ec.openDocument();
        }
        catch (IOException ex) {
            return null;
        }
        return doc;
    }

    private static StyledDocument findDocument(DataObject dataObject) {
        StyledDocument doc;
        EditorCookie ec = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        try {
            doc = ec.openDocument();
        }
        catch (IOException ex) {
            return null;
        }
        return doc;
    }

    private static CompilationController retrieveController(ResultIterator resIt, StyledDocument doc) throws ParseException {
        CompilationController ci;
        Parser.Result res = resIt.getParserResult();
        CompilationController compilationController = ci = res != null ? CompilationController.get((Parser.Result)res) : null;
        if (ci == null) {
            ErrorManager.getDefault().log(16, "Unable to get compilation controller " + doc);
        }
        return ci;
    }

    private class OperationCreationDelegateImpl
    implements ASTOperationCreationDelegate {
        private OperationCreationDelegateImpl() {
        }

        public EditorContext.Operation createMethodOperation(EditorContext.Position startPosition, EditorContext.Position endPosition, EditorContext.Position methodStartPosition, EditorContext.Position methodEndPosition, String methodName, String methodClassType, int bytecodeIndex, boolean isNative) {
            return EditorContextImpl.this.createMethodOperation(startPosition, endPosition, methodStartPosition, methodEndPosition, methodName, methodClassType, bytecodeIndex, isNative);
        }

        public EditorContext.Position createPosition(int offset, int line, int column) {
            return EditorContextImpl.this.createPosition(offset, line, column);
        }

        public void addNextOperationTo(EditorContext.Operation operation, EditorContext.Operation next) {
            EditorContextImpl.this.addNextOperationTo(operation, next);
        }
    }

    private class EditorContextDispatchListener
    implements PropertyChangeListener {
        private EditorContextDispatchListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditorContextImpl.this.pcs.firePropertyChange("currentNodes", null, null);
        }
    }
}

