/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.regex.tregex.nfa.NFAState;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.util.json.Json;
import com.oracle.truffle.regex.tregex.util.json.JsonArray;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;

public class NFAStateTransition
implements JsonConvertible {
    private final short id;
    @CompilerDirectives.CompilationFinal
    private NFAState source;
    private final NFAState target;
    private final GroupBoundaries groupBoundaries;

    public NFAStateTransition(short id, NFAState source, NFAState target, GroupBoundaries groupBoundaries) {
        this.id = id;
        this.source = source;
        this.target = target;
        this.groupBoundaries = groupBoundaries;
    }

    public short getId() {
        return this.id;
    }

    public NFAState getSource() {
        return this.source;
    }

    public void setSource(NFAState source) {
        this.source = source;
    }

    public NFAState getTarget() {
        return this.target;
    }

    public NFAState getTarget(boolean forward) {
        return forward ? this.target : this.source;
    }

    public NFAState getSource(boolean forward) {
        return forward ? this.source : this.target;
    }

    public GroupBoundaries getGroupBoundaries() {
        return this.groupBoundaries;
    }

    @CompilerDirectives.TruffleBoundary
    private JsonArray sourceSectionsToJson() {
        if (!this.groupBoundaries.hasIndexUpdates()) {
            return Json.array(new JsonConvertible[0]);
        }
        RegexAST ast = this.source.getStateSet().getAst();
        return Json.array(this.groupBoundaries.getUpdateIndices().stream().mapToObj(x -> {
            Group group = this.source.getStateSet().getAst().getGroupByBoundaryIndex(x);
            SourceSection sourceSection = ast.getSourceSections(group).get(x & 1);
            return Json.obj(Json.prop("start", sourceSection.getCharIndex()), Json.prop("end", sourceSection.getCharEndIndex()));
        }));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson() {
        return Json.obj(Json.prop("id", this.id), Json.prop("source", this.source.getId()), Json.prop("target", this.target.getId()), Json.prop("groupBoundaries", this.groupBoundaries), Json.prop("sourceSections", this.sourceSectionsToJson()));
    }

    @CompilerDirectives.TruffleBoundary
    public JsonValue toJson(boolean forward) {
        return Json.obj(Json.prop("id", this.id), Json.prop("source", this.getSource(forward).getId()), Json.prop("target", this.getTarget(forward).getId()), Json.prop("groupBoundaries", this.groupBoundaries), Json.prop("sourceSections", this.sourceSectionsToJson()));
    }
}

