#include "Permutation.h"
using namespace NTPoly;

////////////////////////////////////////////////////////////////////////////////
extern "C" {
#include "Permutation_c.h"
}

////////////////////////////////////////////////////////////////////////////////
namespace NTPoly {
////////////////////////////////////////////////////////////////////////////////
Permutation::Permutation(int matrix_dimension) {
  was_filled = false;
  this->matrix_dimension = matrix_dimension;
}

////////////////////////////////////////////////////////////////////////////////
void Permutation::SetDefaultPermutation() {
  was_filled = true;
  ConstructDefaultPermutation_wrp(ih_this, &matrix_dimension);
}

////////////////////////////////////////////////////////////////////////////////
void Permutation::SetReversePermutation() {
  was_filled = true;
  ConstructReversePermutation_wrp(ih_this, &matrix_dimension);
}

////////////////////////////////////////////////////////////////////////////////
void Permutation::SetRandomPermutation() {
  was_filled = true;
  ConstructRandomPermutation_wrp(ih_this, &matrix_dimension);
}

////////////////////////////////////////////////////////////////////////////////
Permutation::~Permutation() {
  if (was_filled) {
    DestructPermutation_wrp(ih_this);
  }
}
} // namespace NTPoly
