/* Copyright (C) 2000-2005 MySQL AB

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   There are special exceptions to the terms and conditions of the GPL as it
   is applied to this software. View the full text of the exception in file
   EXCEPTIONS in the directory of this software distribution.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA */

#include "MYODBCSetupDataSourceTab3c.h"

MYODBCSetupDataSourceTab3c::MYODBCSetupDataSourceTab3c( QWidget *pwidgetParent )
    : QWidget( pwidgetParent, "MYODBCSetupDataSourceTab3c" )
{
    QVBoxLayout *playoutFields = new QVBoxLayout( this );
    playoutFields->setMargin( 20 );
    playoutFields->setSpacing( 5 );

    playoutFields->addStretch( 10 );

    pcheckboxReturnTableNamesSQLDescribeCol = new MYODBCSetupCheckBox( "Return Table Names For SQLDescribeCol", this );
    QToolTip::add( pcheckboxReturnTableNamesSQLDescribeCol, "SQLDescribeCol() will return fully qualified column names." );
    pcheckboxReturnTableNamesSQLDescribeCol->setAssistText( "SQLDescribeCol() will return fully qualified column names." );
    playoutFields->addWidget( pcheckboxReturnTableNamesSQLDescribeCol );

    pcheckboxIgnoreSpaceAfterFunctionNames = new MYODBCSetupCheckBox( "Ignore Space After Function Names", this );
    QToolTip::add( pcheckboxIgnoreSpaceAfterFunctionNames, "Tell server to ignore space after function name and before `(' (needed by PowerBuilder). This will make all function names keywords." );
    pcheckboxIgnoreSpaceAfterFunctionNames->setAssistText( "Tell server to ignore space after function name and before `(' (needed by PowerBuilder). This will make all function names keywords." );
    playoutFields->addWidget( pcheckboxIgnoreSpaceAfterFunctionNames );

    pcheckboxForceUseOfNamedPipes = new MYODBCSetupCheckBox( "Force Use Of Named Pipes", this );
    QToolTip::add( pcheckboxForceUseOfNamedPipes, "Connect with named pipes to a mysqld server running on NT." );
    pcheckboxForceUseOfNamedPipes->setAssistText( "Connect with named pipes to a mysqld server running on NT." );
    playoutFields->addWidget( pcheckboxForceUseOfNamedPipes );

    pcheckboxNoCatalog = new MYODBCSetupCheckBox( "No Catalog (exp)", this );
    QToolTip::add( pcheckboxNoCatalog, "Return 'user' as Table_qualifier and Table_owner from SQLTables (experimental)." );
    pcheckboxNoCatalog->setAssistText( "Return 'user' as Table_qualifier and Table_owner from SQLTables (experimental)." );
    playoutFields->addWidget( pcheckboxNoCatalog );

    pcheckboxReadOptionsFromMyCnf = new MYODBCSetupCheckBox( "Read Options From my.cnf", this );
    QToolTip::add( pcheckboxReadOptionsFromMyCnf, "Read parameters from the [client] and [odbc] groups from `my.cnf'." );
    pcheckboxReadOptionsFromMyCnf->setAssistText( "Read parameters from the [client] and [odbc] groups from `my.cnf'." );
    playoutFields->addWidget( pcheckboxReadOptionsFromMyCnf );

    pcheckboxDisableTransactions = new MYODBCSetupCheckBox( "Disable Transactions", this );
    QToolTip::add( pcheckboxDisableTransactions, "Disable transactions." );
    pcheckboxDisableTransactions->setAssistText( "Disable transactions." );
    playoutFields->addWidget( pcheckboxDisableTransactions );

    pcheckboxForceUseOfForwardOnlyCursors = new MYODBCSetupCheckBox( "Force Use Of Forward Only Cursors", this );
    QToolTip::add( pcheckboxForceUseOfForwardOnlyCursors, "Force the use of Forward-only cursor type. In case of applications setting the default static/dynamic cursor type, and one wants driver to use non-cache result sets, then this option will ensure the forward-only cursor behavior." );
    pcheckboxForceUseOfForwardOnlyCursors->setAssistText( "Force the use of Forward-only cursor type. In case of applications setting the default static/dynamic cursor type, and one wants driver to use non-cache result sets, then this option will ensure the forward-only cursor behavior." );
    playoutFields->addWidget( pcheckboxForceUseOfForwardOnlyCursors );

    playoutFields->addStretch( 10 );
}


