#include "core/formula.h"

using namespace std;

map<int, string> tex::Formula::_symbolFormulaMappings = {
    {160, "\\ "},
    {161, "!`"},
    {169, "\\copyright"},
    {192, "\\`A"},
    {193, "\\'A"},
    {194, "\\^A"},
    {195, "\\~A"},
    {196, "\\\"A"},
    {197, "\\r A"},
    {198, "\\AE"},
    {199, "\\c C"},
    {200, "\\`E"},
    {201, "\\'E"},
    {202, "\\^E"},
    {203, "\\\"E"},
    {204, "\\`I"},
    {205, "\\'I"},
    {206, "\\^I"},
    {207, "\\\"I"},
    // ETH {208, ""},
    {209, "\\~N"},
    {210, "\\`O"},
    {211, "\\'O"},
    {212, "\\^O"},
    {213, "\\~O"},
    {214, "\\\"O"},
    {216, "\\O"},
    {217, "\\`U"},
    {218, "\\'U"},
    {219, "\\^U"},
    {220, "\\\"U"},
    {221, "\\'Y"},
    // THORN {222, ""},
    {223, "\\ss"},
    {224, "\\`a"},
    {225, "\\'a"},
    {226, "\\^a"},
    {227, "\\~a"},
    {228, "\\\"a"},
    {229, "\\aa"},
    {230, "\\ae"},
    {231, "\\c c"},
    {232, "\\`e"},
    {233, "\\'e"},
    {234, "\\^e"},
    {235, "\\\"e"},
    {236, "\\`\\i"},
    {237, "\\'\\i"},
    {238, "\\^\\i"},
    {239, "\\\"\\i"},
    {240, "\\eth"},
    {241, "\\~n"},
    {242, "\\`o"},
    {243, "\\'o"},
    {244, "\\^o"},
    {245, "\\~o"},
    {246, "\\\"o"},
    {247, "\\div"},
    {248, "\\o"},
    {249, "\\`u"},
    {250, "\\'u"},
    {251, "\\^u"},
    {252, "\\\"u"},
    {253, "\\'y"},
    // thorn {254, ""},
    {255, "\\\"y"},
    {256, "\\=A"},
    {257, "\\=a"},
    {258, "\\u A"},
    {259, "\\u a"},
    {260, "\\k A"},
    {261, "\\k a"},
    {262, "\\'C"},
    {263, "\\'c"},
    {264, "\\^C"},
    {265, "\\^c"},
    {266, "\\.C"},
    {267, "\\.c"},
    {268, "\\v C"},
    {269, "\\v c"},
    {270, "\\v D"},
    {271, "d\\text{'}"},
    {272, "\\Dstrok"},
    {273, "\\dstrok"},
    {274, "\\=E"},
    {275, "\\=e"},
    {276, "\\u E"},
    {277, "\\u e"},
    {278, "\\.E"},
    {279, "\\.e"},
    {280, "\\k E"},
    {281, "\\k e"},
    {282, "\\v E"},
    {283, "\\v e"},
    {284, "\\^G"},
    {285, "\\^g"},
    {286, "\\u G"},
    {287, "\\u g"},
    {288, "\\.G"},
    {289, "\\.g"},
    {290, "\\underaccent{,}G"},
    {291, "\\'g"},
    {292, "\\^H"},
    {293, "\\^h"},
    {294, "\\Hstrok"},
    {295, "\\hstrok"},
    {296, "\\~I"},
    {297, "\\~\\i"},
    {298, "\\=I"},
    {299, "\\=\\i"},
    {300, "\\u I"},
    {301, "\\u \\i"},
    {302, "\\k I"},
    {303, "\\k i"},
    {304, "\\.I"},
    {305, "\\i"},
    {306, "\\IJ"},
    {307, "\\ij"},
    {308, "\\^J"},
    {309, "\\^\\j"},
    {310, "\\underaccent{,}K"},
    {311, "\\underaccent{,}k"},
    // kra groenland
    {313, "\\'L"},
    {314, "\\'l"},
    {315, "\\underaccent{,}L"},
    {316, "\\underaccent{,}l"},
    {317, "\\Lcaron"},
    {318, "\\lcaron"},
    {319, "L\\cdot"},
    {320, "l\\cdot"},
    {321, "\\L"},
    {322, "\\l"},
    // L barre
    {323, "\\'N"},
    {324, "\\'n"},
    {325, "\\underaccent{,}N"},
    {326, "\\underaccent{,}n"},
    {327, "\\v N"},
    {328, "\\v n"},
    {329, "\\text{'}n"},
    // Nj
    {332, "\\=O"},
    {333, "\\=o"},
    {334, "\\u O"},
    {335, "\\u o"},
    {336, "\\H O"},
    {337, "\\H o"},
    {338, "\\OE"},
    {339, "\\oe"},
    {340, "\\'R"},
    {341, "\\'r"},
    {342, "\\underaccent{,}R"},
    {343, "\\underaccent{,}r"},
    {344, "\\v R"},
    {345, "\\v r"},
    {346, "\\'S"},
    {347, "\\'s"},
    {348, "\\^S"},
    {349, "\\^s"},
    {350, "\\c S"},
    {351, "\\c s"},
    {352, "\\v S"},
    {353, "\\v s"},
    {354, "\\c T"},
    {355, "\\c t"},
    {356, "\\v T"},
    {357, "\\tcaron"},
    {358, "\\TStroke"},
    {359, "\\tStroke"},
    {360, "\\~U"},
    {361, "\\~u"},
    {362, "\\=U"},
    {363, "\\=u"},
    {364, "\\u U"},
    {365, "\\u u"},
    {366, "\\r U"},
    {367, "\\r u"},
    {368, "\\H U"},
    {369, "\\H u"},
    {370, "\\k U"},
    {371, "\\k u"},
    {372, "\\^W"},
    {373, "\\^w"},
    {374, "\\^Y"},
    {375, "\\^y"},
    {376, "\\\"Y"},
    {377, "\\'Z"},
    {378, "\\'z"},
    {379, "\\.Z"},
    {380, "\\.z"},
    {381, "\\v Z"},
    {382, "\\v z"},
    // f avec demi-barre
    // greek capitals
    {913, "\\Alpha"},
    {914, "\\Beta"},
    {915, "\\Gamma"},
    {916, "\\Delta"},
    {917, "\\Epsilon"},
    {918, "\\Zeta"},
    {919, "\\Eta"},
    {920, "\\Theta"},
    {921, "\\Iota"},
    {922, "\\Kappa"},
    {923, "\\Lambda"},
    {924, "\\Mu"},
    {925, "\\Nu"},
    {926, "\\Xi"},
    {927, "\\Omicron"},
    {928, "\\Pi"},
    {929, "\\Rho"},
    {931, "\\Sigma"},
    {932, "\\Tau"},
    {933, "\\Upsilon"},
    {934, "\\Phi"},
    {935, "\\Chi"},
    {936, "\\Psi"},
    {937, "\\Omega"},
    // Unicode to symbols
    {8742, "\\nshortparallel"},
    {8651, "\\leftrightharpoons"},
    {8667, "\\Rrightarrow"},
    {10956, "\\supsetneqq"},
    {8805, "\\ge"},
    {8883, "\\rhd"},
    {10877, "\\leqslant"},
    {8650, "\\downdownarrows"},
    {8819, "\\gtrsim"},
    {8822, "\\lessgtr"},
    {10230, "\\longrightarrow"},
    {8660, "\\Leftrightarrow"},
    {8592, "\\leftarrow"},
    {8854, "\\ominus"},
    {8203, "\\!"},
    {8855, "\\otimes"},
    {8968, "\\lceil"},
    {8706, "\\partial"},
    {8994, "\\smallfrown"},
    {8196, "\\,"},
    {10914, "\\gg"},
    {10916, "\\mathbin{\\rlap{>}\\!<}"},
    {10917, "\\mathbin{><}"},
    {10918, "\\leftslice"},
    {10919, "\\rightslice"},
    {8194, "\\;"},
    {8197, "\\:"},
    {8463, "\\hbar"},
    {8601, "\\swarrow"},
    {8809, "\\gneqq"},
    {8800, "\\neq"},
    {215, "\\times"},
    {172, "\\lnot"},
    {10949, "\\nsubseteqq"},
    {8593, "\\uparrow"},
    {8910, "\\curlyvee"},
    {8726, "\\setminus"},
    {8727, "{}_\\ast"},
    {8843, "\\supsetneq"},
    {8602, "\\nleftarrow"},
    {8654, "\\nLeftrightarrow"},
    {9662, "\\blacktriangledown"},
    {8642, "\\downharpoonright"},
    {10949, "\\subseteqq"},
    {8707, "\\exists"},
    {8709, "\\emptyset"},
    {8921, "\\ggg"},
    {8764, "\\sim"},
    {8808, "\\lvertneqq"},
    {8214, "\\|"},
    {8744, "\\vee"},
    {8729, "\\bullet"},
    {10955, "\\subsetneqq"},
    {9663, "\\triangledown"},
    {8771, "\\simeq"},
    {8649, "\\rightrightarrows"},
    {9661, "\\bigtriangledown"},
    {8816, "\\nleqslant"},
    {8625, "\\Rsh"},
    {8600, "\\searrow"},
    {9664, "\\blacktriangleleft"},
    {8805, "\\geq"},
    {8741, "\\Vert"},
    {8941, "\\ntrianglerighteq"},
    {8596, "\\leftrightarrow"},
    {8965, "\\barwedge"},
    {8939, "\\ntriangleright"},
    {8906, "\\rtimes"},
    {8660, "\\iff"},
    {8861, "\\circleddash"},
    {8915, "\\Cup"},
    {8648, "\\upuparrows"},
    {8815, "\\ngtr"},
    {8937, "\\succnsim"},
    {10868, "\\coloncolonequals"},
    {10889, "\\lnapprox"},
    {8919, "\\gtrdot"},
    {8230, "\\ldots"},
    {8776, "\\approx"},
    {10885, "\\lessapprox"},
    {8911, "\\curlywedge"},
    {8809, "\\gvertneqq"},
    {8775, "\\ncong"},
    {8783, "\\bumpeq"},
    {10232, "\\Longleftarrow"},
    {8741, "\\parallel"},
    {8196, "\\thinspace"},
    {9002, "\\rangle"},
    {8898, "\\bigcap"},
    {9827, "\\clubsuit"},
    {8835, "\\supset"},
    {8836, "\\not\\subset"},
    {8837, "\\not\\supset"},
    {8856, "\\oslash"},
    {8756, "\\therefore"},
    {8758, "\\ratio"},
    {8759, "\\mathbin{\\ratio\\ratio}"},
    {10936, "\\succapprox"},
    {8869, "\\bot"},
    {8923, "\\gtreqless"},
    {8782, "\\Bumpeq"},
    {8661, "\\Updownarrow"},
    {1014, "\\backepsilon"},
    {8746, "\\cup"},
    {10234, "\\Longleftrightarrow"},
    {10927, "\\preceq"},
    {8915, "\\doublecup"},
    {8214, "\\lVert"},
    {8839, "\\supseteq"},
    {8817, "\\ngeqslant"},
    {8224, "\\dagger"},
    {10928, "\\nsucceq"},
    {10815, "\\amalg"},
    {10891, "\\lesseqqgtr"},
    {8806, "\\leqq"},
    {8791, "\\circeq"},
    {8792, "\\smallfrowneq"},
    {8793, "\\stackrel{\\wedge}{=}"},
    {8794, "\\stackrel{\\vee}{=}"},
    {8795, "\\stackrel{\\scalebox{0.8}{\\bigstar}}{=}"},
    {8796, "\\triangleq"},
    {8797, "\\stackrel{\\scalebox{0.75}{\\mathrm{def}}}{=}"},
    {8798, "\\stackrel{\\scalebox{0.75}{\\mathrm{m}}}{=}"},
    {8799, "\\stackrel{\\scalebox{0.75}{\\mathrm{?}}}{=}"},
    {8636, "\\leftharpoonup"},
    {8858, "\\circledcirc"},
    {8598, "\\nwarrow"},
    {8934, "\\lnsim"},
    {8995, "\\smallsmile"},
    {8857, "\\odot"},
    {8740, "\\nmid"},
    {8918, "\\lessdot"},
    {8242, "\\prime"},
    {177, "\\pm"},
    {8850, "\\sqsupseteq"},
    {8784, "\\doteq"},
    {8810, "\\ll"},
    {8807, "\\geqq"},
    {9825, "\\heartsuit"},
    {8638, "\\upharpoonright"},
    {8646, "\\leftrightarrows"},
    {8908, "\\rightthreetimes"},
    {8723, "\\mp"},
    {10927, "\\npreceq"},
    {8942, "\\vdots"},
    {8938, "\\ntriangleleft"},
    {8733, "\\varpropto"},
    {8902, "\\star"},
    {8761, "\\minuscolon"},
    {8762, "\\geoprop"},
    {8764, "\\thicksim"},
    {8882, "\\vartriangleleft"},
    {9642, "\\blacksquare"},
    {9646, "\\marker"},
    {9653, "\\triangle"},
    {10756, "\\biguplus"},
    {10938, "\\succnapprox"},
    {10890, "\\gnapprox"},
    {8800, "\\ne"},
    {9633, "\\square"},
    {8717, "\\ni"},
    {8944, "\\iddots"},
    {8945, "\\ddots"},
    {8948, "\\inplus"},
    {8876, "\\nvdash"},
    {8720, "\\coprod"},
    {8739, "\\shortmid"},
    {8617, "\\hookleftarrow"},
    {8655, "\\nRightarrow"},
    {8639, "\\upharpoonleft"},
    {8865, "\\boxdot"},
    {8841, "\\nsupseteq"},
    {8712, "\\in"},
    {8713, "\\notin"},
    {8905, "\\ltimes"},
    {8827, "\\succ"},
    {8722, "\\minus"},
    {10928, "\\succeq"},
    {8638, "\\restriction"},
    {8747, "\\int"},
    {9837, "\\flat"},
    {8513, "\\Game"},
    {8523, "\\parr"},
    {8829, "\\succcurlyeq"},
    {9001, "\\langle"},
    {8901, "\\cdot"},
    {8852, "\\sqcup"},
    {8503, "\\gimel"},
    {8859, "\\circledast"},
    {10901, "\\eqslantless"},
    {8804, "\\le"},
    {8823, "\\gtrless"},
    {8733, "\\propto"},
    {9665, "\\triangleleft"},
    {9652, "\\blacktriangle"},
    {8465, "\\Im"},
    {10753, "\\bigoplus"},
    {10764, "\\iiiint"},
    {8765, "\\backsim"},
    {8734, "\\infty"},
    {8834, "\\subset"},
    {8914, "\\Cap"},
    {8900, "\\diamond"},
    {8878, "\\nVdash"},
    {8786, "\\fallingdotseq"},
    {8788, "\\colonequals"},
    {8789, "\\equalscolon"},
    {8812, "\\between"},
    {8595, "\\downarrow"},
    {8592, "\\gets"},
    {8927, "\\curlyeqsucc"},
    {8846, "\\uplus"},
    {8714, "\\in"},
    {8840, "\\nsubseteq"},
    {8903, "\\divideontimes"},
    {8808, "\\lneqq"},
    {8936, "\\precnsim"},
    {8956, "\\niplus"},
    {8197, "\\medspace"},
    {10878, "\\geqslant"},
    {8781, "\\asymp"},
    {8966, "\\doublebarwedge"},
    {8849, "\\sqsubseteq"},
    {9136, "\\lmoustache"},
    {8769, "\\nsim"},
    {8851, "\\sqcap"},
    {10950, "\\supseteqq"},
    {8907, "\\leftthreetimes"},
    {8741, "\\shortparallel"},
    {8866, "\\vdash"},
    {8737, "\\measuredangle"},
    {8838, "\\subseteq"},
    {8920, "\\llless"},
    {8744, "\\lor"},
    {8656, "\\Leftarrow"},
    {8472, "\\wp"},
    {8768, "\\wr"},
    {10754, "\\bigotimes"},
    {8807, "\\ngeqq"},
    {8871, "\\models"},
    {8862, "\\boxplus"},
    {8611, "\\rightarrowtail"},
    {8863, "\\boxminus"},
    {8726, "\\smallsetminus"},
    {10886, "\\gtrapprox"},
    {8826, "\\prec"},
    {8643, "\\downharpoonleft"},
    {10239, "\\leadsto"},
    {8717, "\\owns"},
    {10902, "\\eqslantgtr"},
    {8773, "\\cong"},
    {8619, "\\looparrowleft"},
    {8502, "\\beth"},
    {8748, "\\iint"},
    {9653, "\\vartriangle"},
    {8869, "\\perp"},
    {8653, "\\nLeftarrow"},
    {10758, "\\bigsqcup"},
    {8711, "\\nabla"},
    {8884, "\\trianglelefteq"},
    {8847, "\\sqsubset"},
    {8708, "\\nexists"},
    {9654, "\\blacktriangleright"},
    {8743, "\\wedge"},
    {8736, "\\angle"},
    {8242, "\\'"},
    {10752, "\\bigodot"},
    {8195, "\\quad"},
    {9416, "\\circledS"},
    {8874, "\\Vvdash"},
    {8828, "\\preccurlyeq"},
    {9655, "\\triangleright"},
    {8778, "\\approxeq"},
    {8594, "\\to"},
    {10849, "\\veebar"},
    {8659, "\\Downarrow"},
    {8877, "\\nvDash"},
    {8818, "\\lesssim"},
    {8830, "\\precsim"},
    {8750, "\\oint"},
    {8842, "\\subsetneq"},
    {8873, "\\Vdash"},
    {9585, "\\diagup"},
    {8738, "\\sphericalangle"},
    {9826, "\\diamondsuit"},
    {8867, "\\dashv"},
    {8599, "\\nearrow"},
    {8603, "\\nrightarrow"},
    {10892, "\\gtreqqless"},
    {8904, "\\bowtie"},
    {8916, "\\pitchfork"},
    {9838, "\\natural"},
    {10934, "\\succneqq"},
    {8843, "\\varsupsetneq"},
    {8621, "\\leftrightsquigarrow"},
    {8745, "\\cap"},
    {9137, "\\rmoustache"},
    {8743, "\\land"},
    {8913, "\\Supset"},
    {8721, "\\sum"},
    {8888, "\\multimap"},
    {8971, "\\rfloor"},
    {8622, "\\nleftrightarrow"},
    {9674, "\\lozenge"},
    {8647, "\\leftleftarrows"},
    {8605, "\\rightsquigarrow"},
    {8864, "\\boxtimes"},
    {8644, "\\rightleftarrows"},
    {8940, "\\ntrianglelefteq"},
    {8749, "\\iiint"},
    {8868, "\\top"},
    {8594, "\\rightarrow"},
    {8476, "\\Re"},
    {8848, "\\sqsupset"},
    {8608, "\\twoheadrightarrow"},
    {9632, "\\blacksquare"},
    {10956, "\\varsupsetneqq"},
    {8630, "\\curvearrowleft"},
    {8504, "\\daleth"},
    {8194, "\\thickspace"},
    {8921, "\\gggtr"},
    {8790, "\\eqcirc"},
    {10955, "\\varsubsetneqq"},
    {8739, "\\vert"},
    {8831, "\\succsim"},
    {8657, "\\Uparrow"},
    {8806, "\\nleqq"},
    {8487, "\\mho"},
    {8491, "\\text{\\AA}"},
    {8770, "\\eqsim"},
    {8620, "\\looparrowright"},
    {8640, "\\rightharpoonup"},
    {8801, "\\equiv"},
    {8802, "\\not\\equiv"},
    {8610, "\\leftarrowtail"},
    {8882, "\\lhd"},
    {9733, "\\bigstar"},
    {8935, "\\gnsim"},
    {8872, "\\vDash"},
    {10731, "\\blacklozenge"},
    {183, "\\cdot"},
    {8814, "\\nless"},
    {8225, "\\ddagger"},
    {8787, "\\risingdotseq"},
    {8467, "\\ell"},
    {8785, "\\doteqdot"},
    {10887, "\\lneq"},
    {8658, "\\Rightarrow"},
    {10233, "\\Longrightarrow"},
    {8631, "\\curvearrowright"},
    {8618, "\\hookrightarrow"},
    {8214, "\\rVert"},
    {10231, "\\longleftrightarrow"},
    {8926, "\\curlyeqprec"},
    {10229, "\\longleftarrow"},
    {8641, "\\rightharpoondown"},
    {8463, "\\hslash"},
    {8914, "\\doublecap"},
    {8719, "\\prod"},
    {8597, "\\updownarrow"},
    {8624, "\\Lsh"},
    {8833, "\\nsucc"},
    {8725, "\\slash"},
    {8637, "\\leftharpoondown"},
    {8804, "\\leq"},
    {8500, "\\mathit{o}"},
    {8501, "\\aleph"},
    {8879, "\\nVDash"},
    {8970, "\\lfloor"},
    {8728, "\\circ"},
    {8899, "\\bigcup"},
    {8740, "\\nshortmid"},
    {10935, "\\precapprox"},
    {8885, "\\trianglerighteq"},
    {8739, "\\mid"},
    {8724, "\\dotplus"},
    {8832, "\\nprec"},
    {8943, "\\cdots"},
    {8666, "\\Lleftarrow"},
    {10933, "\\precneqq"},
    {8495, "e"},
    {8498, "\\Finv"},
    {8890, "\\intercal"},
    {8730, "\\surd"},
    {8897, "\\bigvee"},
    {10888, "\\gneq"},
    {8704, "\\forall"},
    {10937, "\\precnapprox"},
    {9824, "\\spadesuit"},
    {10236, "\\longmapsto"},
    {10214, "\\llbracket"},
    {10215, "\\rrbracket"},
    {10216, "\\langle"},
    {10217, "\\rangle"},
    {9711, "\\bigcirc"},
    {8909, "\\backsimeq"},
    {247, "\\div"},
    {125, "\\rbrace"},
    {8705, "\\complement"},
    {8757, "\\because"},
    {8760, "\\dotminus"},
    {9651, "\\triangle"},
    {8606, "\\twoheadleftarrow"},
    {1013, "\\epsilon"},
    {8741, "\\Arrowvert"},
    {9674, "\\Diamond"},
    {8842, "\\varsubsetneq"},
    {8739, "\\arrowvert"},
    {9839, "\\sharp"},
    {8896, "\\bigwedge"},
    {8709, "\\varnothing"},
    {9586, "\\diagdown"},
    {8614, "\\mapsto"},
    {8883, "\\vartriangleright"},
    {8853, "\\oplus"},
    {8776, "\\thickapprox"},
    {8969, "\\rceil"},
    {8912, "\\Subset"},
    {8652, "\\rightleftharpoons"},
    {769, "\\acute"},
    {768, "\\grave"},
    {776, "\\ddot"},
    {779, "\\doubleacute"},
    {771, "\\tilde"},
    {730, "\\bmathring"},
    {772, "\\bar"},
    {774, "\\breve"},
    {780, "\\check"},
    {770, "\\hat"},
    {8407, "\\vec"},
    {775, "\\dot"},
    {770, "\\widehat"},
    {771, "\\widetilde"},
    {8450, "\\mathbb{C}"},
    {8451, "\\sideset{^\\circ}{}\\text{C}"},
    {8455, "\\euler"},
    {8457, "\\sideset{^\\circ}{}\\text{F}"},
    {8461, "\\mathbb{H}"},
    {8469, "\\mathbb{N}"},
    {8473, "\\mathbb{P}"},
    {8474, "\\mathbb{Q}"},
    {8477, "\\mathbb{R}"},
    {8484, "\\mathbb{Z}"},
    {8488, "\\mathfrak{Z}"},
    {8459, "\\mathscr{H}"},
    {8460, "\\mathfrak{H}"},
    {8464, "\\mathscr{I}"},
    {8466, "\\mathscr{L}"},
    {8475, "\\mathscr{R}"},
    {8492, "\\mathscr{B}"},
    {8493, "\\mathfrak{C}"},
    {8496, "\\mathscr{E}"},
    {8497, "\\mathscr{F}"},
    {8499, "\\mathscr{M}"},
    {64256, "ff"},
    {64257, "fi"},
    {58290, "fj"},
    {64258, "fl"},
    {64259, "ffi"},
    {64260, "ffl"},
    {10643, "\\mathbin{\\rlap{<}\\;(}"},
    {10644, "\\mathbin{\\rlap{>}\\,)}"},
    {10677, "\\minuso"},
    {10686, "\\varocircle"},
    {10688, "\\olessthan"},
    {10689, "\\ogreaterthan"},
    {10692, "\\boxslash"},
    {10693, "\\boxbslash"},
    {10016, "\\maltese"},
    {10016, "\\checkmark"},
    {8254, "\\mathpunct{\\={\\ }}"},
    {8259, "\\hybull"},
    {8240, "\\textperthousand"},
    {8241, "\\textpertenthousand"},
    {8249, "\\guilsinglleft"},
    {8250, "\\guilsinglright"},
    {8772, "\\not\\simeq"},
    {8244, "'''"},
    {8411, "''"},
    {8216, "`"},
    {8220, "``"},
    {8217, "\\textapos"},
    {8218, ","},
    {8221, "\\textapos\\textapos"},
    {8222, ",,"},
    {8206, " "},
    {8207, " "},
    {8364, "\\euro"},
    {8208, "\\textminus"},
    {8211, "\\textendash"},
    {8212, "\\textemdash"},
    {8448, "\\sfrac{a}{c}"},
    {8449, "\\sfrac{a}{s}"},
    {8453, "\\sfrac{c}{o}"},
    {8454, "\\sfrac{c}{u}"},
    {8480, "{}^{\\text{TM}}"},
    {8988, "\\ulcorner"},
    {8989, "\\urcorner"},
    {8990, "\\llcorner"},
    {8991, "\\lrcorner"},
    {8531, "\\text{\\sfrac13}"},
    {8532, "\\text{sfrac23}"},
    {8533, "\\text{\\sfrac15}"},
    {8534, "\\text{\\sfrac25}"},
    {8535, "\\text{\\sfrac35}"},
    {8536, "\\text{\\sfrac45}"},
    {8537, "\\text{\\sfrac16}"},
    {8538, "\\text{\\sfrac56}"},
    {189, "\\text{\\sfrac12}"},
    {188, "\\text{\\sfrac14}"},
    {190, "\\text{\\sfrac34}"},
    {8539, "\\text{\\sfrac18}"},
    {8540, "\\text{\\sfrac38}"},
    {8541, "\\text{\\sfrac58}"},
    {8542, "\\text{\\sfrac78}"},
    {8543, "\\text{\\sfrac{1}{\\ }}"},
    {8544, "\\text{I}"},
    {8545, "\\text{II}"},
    {8546, "\\text{III}"},
    {8547, "\\text{IV}"},
    {8548, "\\text{V}"},
    {8549, "\\text{VI}"},
    {8550, "\\text{VII}"},
    {8551, "\\text{VIII}"},
    {8552, "\\text{IX}"},
    {8553, "\\text{X}"},
    {8554, "\\text{XI}"},
    {8555, "\\text{XII}"},
    {8556, "\\text{L}"},
    {8557, "\\text{C}"},
    {8558, "\\text{D}"},
    {8559, "\\text{M}"},
    {8560, "\\text{i}"},
    {8561, "\\text{ii}"},
    {8562, "\\text{iii}"},
    {8563, "\\text{iv}"},
    {8564, "\\text{v}"},
    {8565, "\\text{vi}"},
    {8566, "\\text{vii}"},
    {8567, "\\text{viii}"},
    {8568, "\\text{ix}"},
    {8569, "\\text{x}"},
    {8570, "\\text{xi}"},
    {8571, "\\text{xii}"},
    {8572, "\\text{l}"},
    {8573, "\\text{c}"},
    {8574, "\\text{d}"},
    {8575, "\\text{m}"},
    {9600, "\\uhblk"},
    {9601, "\\lhblk"},
    {9608, "\\block"},
    {9617, "\\fgcolor{bfbfbf}{\\block}"},
    {9618, "\\fgcolor{808080}{\\block}"},
    {9619, "\\fgcolor{404040}{\\block}"},
    {9312, "\\textcircled{\\texttt 1}"},
    {9313, "\\textcircled{\\texttt 2}"},
    {9314, "\\textcircled{\\texttt 3}"},
    {9315, "\\textcircled{\\texttt 4}"},
    {9316, "\\textcircled{\\texttt 5}"},
    {9317, "\\textcircled{\\texttt 6}"},
    {9318, "\\textcircled{\\texttt 7}"},
    {9319, "\\textcircled{\\texttt 8}"},
    {9320, "\\textcircled{\\texttt 9}"},
    {9398, "\\textcircled{\\texttt A}"},
    {9399, "\\textcircled{\\texttt B}"},
    {9400, "\\textcircled{\\texttt C}"},
    {9401, "\\textcircled{\\texttt D}"},
    {9402, "\\textcircled{\\texttt E}"},
    {9403, "\\textcircled{\\texttt F}"},
    {9404, "\\textcircled{\\texttt G}"},
    {9405, "\\textcircled{\\texttt H}"},
    {9406, "\\textcircled{\\texttt I}"},
    {9407, "\\textcircled{\\texttt J}"},
    {9408, "\\textcircled{\\texttt K}"},
    {9409, "\\textcircled{\\texttt L}"},
    {9410, "\\textcircled{\\texttt M}"},
    {9411, "\\textcircled{\\texttt N}"},
    {9412, "\\textcircled{\\texttt O}"},
    {9413, "\\textcircled{\\texttt P}"},
    {9414, "\\textcircled{\\texttt Q}"},
    {9415, "\\textcircled{\\texttt R}"},
    {9416, "\\textcircled{\\texttt S}"},
    {9417, "\\textcircled{\\texttt T}"},
    {9418, "\\textcircled{\\texttt U}"},
    {9419, "\\textcircled{\\texttt V}"},
    {9420, "\\textcircled{\\texttt W}"},
    {9421, "\\textcircled{\\texttt X}"},
    {9422, "\\textcircled{\\texttt Y}"},
    {9423, "\\textcircled{\\texttt Z}"},
    {9424, "\\textcircled{\\texttt a}"},
    {9425, "\\textcircled{\\texttt b}"},
    {9426, "\\textcircled{\\texttt c}"},
    {9427, "\\textcircled{\\texttt d}"},
    {9428, "\\textcircled{\\texttt e}"},
    {9429, "\\textcircled{\\texttt f}"},
    {9430, "\\textcircled{\\texttt g}"},
    {9431, "\\textcircled{\\texttt h}"},
    {9432, "\\textcircled{\\texttt i}"},
    {9433, "\\textcircled{\\texttt j}"},
    {9434, "\\textcircled{\\texttt k}"},
    {9435, "\\textcircled{\\texttt l}"},
    {9436, "\\textcircled{\\texttt m}"},
    {9437, "\\textcircled{\\texttt n}"},
    {9438, "\\textcircled{\\texttt o}"},
    {9439, "\\textcircled{\\texttt p}"},
    {9440, "\\textcircled{\\texttt q}"},
    {9441, "\\textcircled{\\texttt r}"},
    {9442, "\\textcircled{\\texttt s}"},
    {9443, "\\textcircled{\\texttt t}"},
    {9444, "\\textcircled{\\texttt u}"},
    {9445, "\\textcircled{\\texttt v}"},
    {9446, "\\textcircled{\\texttt w}"},
    {9447, "\\textcircled{\\texttt x}"},
    {9448, "\\textcircled{\\texttt y}"},
    {9449, "\\textcircled{\\texttt z}"},
};
