//
// UpdateNotificationController.m
//
// Copyright (c) 2011 The McBopomofo Project.
//
// Contributors:
//     Mengjuei Hsieh (@mjhsieh)
//     Weizhong Yang (@zonble)
//
// Based on the Syrup Project and the Formosana Library
// by Lukhnos Liu (@lukhnos).
// 
// Permission is hereby granted, free of charge, to any person
// obtaining a copy of this software and associated documentation
// files (the "Software"), to deal in the Software without
// restriction, including without limitation the rights to use,
// copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following
// conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
// OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
// HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// OTHER DEALINGS IN THE SOFTWARE.
//

#import "UpdateNotificationController.h"

@implementation UpdateNotificationController
@synthesize visitButton = _visitButton;
@synthesize laterButton = _laterButton;
@synthesize infoTextField = _infoTextField;
@synthesize siteURL = _siteURL;
@synthesize infoText = _infoText;

- (id)initWithWindow:(NSWindow *)window
{
    self = [super initWithWindow:window];
    if (self) {
        _infoText = @"Version info here";
    }

    return self;
}

- (void)dealloc
{
    [_siteURL release];
    [_infoText release];
    [super dealloc];
}

- (void)awakeFromNib
{
    [[self window] setTitle:NSLocalizedString(@"New Version Available", @"")];
    [_visitButton setTitle:NSLocalizedString(@"Visit Website", @"")];
    [_laterButton setTitle:NSLocalizedString(@"Check Later", @"")];
    [_infoTextField setStringValue:_infoText];

    [[self window] makeFirstResponder:_visitButton];
}

- (void)windowDidLoad
{
    [super windowDidLoad];

    // Implement this method to handle any initialization after your window controller's window has been loaded from its nib file.
}

- (IBAction)laterAction:(id)sender
{
    [[self window] performClose:self];
}

- (IBAction)visitAction:(id)sender
{
    if (_siteURL) {
        [[NSWorkspace sharedWorkspace] openURL:_siteURL];
    }
    [[self window] performClose:self];
}
@end
