'\"
'\" Generated from file 'cmdline\&.man' by tcllib/doctools with format 'nroff'
'\"
.TH "cmdline" n 1\&.5\&.3 tcllib "Command line and option processing"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
cmdline \- Procedures to process command lines and options\&.
.SH SYNOPSIS
package require \fBTcl 8\&.5 9\fR
.sp
package require \fBcmdline ?1\&.5\&.3?\fR
.sp
\fB::cmdline::getopt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR
.sp
\fB::cmdline::getKnownOpt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR
.sp
\fB::cmdline::getoptions\fR \fIargvVar\fR \fIoptlist\fR ?\fIusage\fR?
.sp
\fB::cmdline::getKnownOptions\fR \fIargvVar\fR \fIoptlist\fR ?\fIusage\fR?
.sp
\fB::cmdline::usage\fR \fIoptlist\fR ?\fIusage\fR?
.sp
\fB::cmdline::getfiles\fR \fIpatterns\fR \fIquiet\fR
.sp
\fB::cmdline::getArgv0\fR
.sp
.BE
.SH DESCRIPTION
This package provides commands to parse command lines and options\&.
.SH "::ARGV HANDLING"
One of the most common variables this package will be used with is
\fB::argv\fR, which holds the command line of the current
application\&. This variable has a companion \fB::argc\fR which is
initialized to the number of elements in \fB::argv\fR at the beginning
of the application\&.
.PP
The commands in this package will \fInot\fR modify the \fB::argc\fR
companion when called with \fB::argv\fR\&. Keeping the value consistent,
if such is desired or required, is the responsibility of the caller\&.
.SH API
.TP
\fB::cmdline::getopt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR
This command works in a fashion like the standard C based \fBgetopt\fR
function\&.  Given an option string and a pointer to an array of args
this command will process the \fIfirst argument\fR and return
info on how to proceed\&. The command returns 1 if an option was found,
0 if no more options were found, and -1 if an error occurred\&.
.sp
\fIargvVar\fR contains the name of the list of arguments to
process\&. If options are found the list is modified and the processed
arguments are removed from the start of the list\&.
.sp
\fIoptstring\fR contains a list of command options that the
application will accept\&.  If the option ends in "\&.arg" the command
will use the next argument as an argument to the option, or extract it
from the current argument, if it is of the form "option=value"\&.
Otherwise the option is a boolean that is set to 1 if present\&.
.sp
\fIoptVar\fR refers to the variable the command will store the found
option into (without the leading '-' and without the \&.arg extension)\&.
.sp
\fIvalVar\fR refers to the variable to store either the value for the
specified option into upon success or an error message in the case of
failure\&. The stored value comes from the command line for \&.arg
options, otherwise the value is 1\&.
.TP
\fB::cmdline::getKnownOpt\fR \fIargvVar\fR \fIoptstring\fR \fIoptVar\fR \fIvalVar\fR
Like \fB::cmdline::getopt\fR, except it ignores any unknown options in
the input\&.
.TP
\fB::cmdline::getoptions\fR \fIargvVar\fR \fIoptlist\fR ?\fIusage\fR?
Processes the entire set of command line options found in the list
variable named by \fIargvVar\fR and fills in defaults for those not
specified\&.  This also generates an error message that lists the
allowed flags if an incorrect flag is specified\&.
The optional \fIusage\fR-argument contains a string to include in
front of the generated message\&. If not present it defaults to
"options:"\&.
.sp
\fIargvVar\fR contains the name of the list of arguments to process\&.
If options are found the list is modified and the processed arguments
are removed from the start of the list\&.
.sp
\fIoptlist\fR contains a list of lists where each element specifies an
option in the form: \fIflag\fR \fIdefault\fR \fIcomment\fR\&.
.sp
If \fIflag\fR ends in "\&.arg" then the value is taken from the command
line\&. Otherwise it is a boolean and appears in the result if present
on the command line\&. If \fIflag\fR ends in "\&.secret", it will not be
displayed in the usage\&.
.sp
The options \fB-?\fR, \fB-help\fR, and \fB--\fR are
implicitly understood\&. The first two abort option processing by
throwing an error and force the generation of the usage message,
whereas the the last aborts option processing without an error,
leaving all arguments coming after for regular processing, even if
starting with a dash\&.
.sp
The result of the command is a dictionary mapping all options to their
values, be they user-specified or defaults\&.
.TP
\fB::cmdline::getKnownOptions\fR \fIargvVar\fR \fIoptlist\fR ?\fIusage\fR?
Like \fB::cmdline::getoptions\fR, but ignores any unknown options in the
input\&.
.TP
\fB::cmdline::usage\fR \fIoptlist\fR ?\fIusage\fR?
Generates and returns an error message that lists the allowed
flags\&. \fIoptlist\fR is defined as for
\fB::cmdline::getoptions\fR\&. The optional \fIusage\fR-argument
contains a string to include in front of the generated message\&. If not
present it defaults to "options:"\&.
.TP
\fB::cmdline::getfiles\fR \fIpatterns\fR \fIquiet\fR
Given a list of file \fIpatterns\fR this command computes the set of
valid files\&.  On windows, file globbing is performed on each argument\&.
On Unix, only file existence is tested\&.  If a file argument produces
no valid files, a warning is optionally generated (set \fIquiet\fR to
true)\&.
.sp
This code also uses the full path for each file\&.  If not given it
prepends the current working directory to the filename\&. This ensures
that these files will never conflict with files in a wrapped zip
file\&. The last sentence refers to the pro-tools\&.
.TP
\fB::cmdline::getArgv0\fR
This command returns the "sanitized" version of \fIargv0\fR\&.  It will
strip off the leading path and removes the extension "\&.bin"\&. The
latter is used by the TclPro applications because they must be wrapped
by a shell script\&.
.PP
.SS "ERROR CODES"
Starting with version 1\&.5 all errors thrown by the package have a
proper \fB::errorCode\fR for use with Tcl's \fBtry\fR command\&. This
code always has the word \fBCMDLINE\fR as its first element\&.
.SH EXAMPLES
.SS CMDLINE::GETOPTIONS
This example, taken from the package \fBfileutil\fR and slightly
modified, demonstrates how to use \fBcmdline::getoptions\fR\&.
First, a list of options is created, then the 'args' list is passed to
cmdline for processing\&.
Subsequently, different options are checked to see if they have been
passed to the script, and what their value is\&.
.PP
.CS


        package require Tcl 8\&.5
        package require try         ;# Tcllib\&.
        package require cmdline 1\&.5 ;# First version with proper error-codes\&.

        # Notes:
        # - Tcl 8\&.6+ has 'try' as a builtin command and therefore does not
        #   need the 'try' package\&.
        # - Before Tcl 8\&.5 we cannot support 'try' and have to use 'catch'\&.
        #   This then requires a dedicated test (if) on the contents of
        #   ::errorCode to separate the CMDLINE USAGE signal from actual errors\&.

        set options {
            {a          "set the atime only"}
            {m          "set the mtime only"}
            {c          "do not create non-existent files"}
            {r\&.arg  ""  "use time from ref_file"}
            {t\&.arg  -1  "use specified time"}
        }
        set usage ": MyCommandName \\[options] filename \&.\&.\&.\\noptions:"

        try {
            array set params [::cmdline::getoptions argv $options $usage]

	    # Note: argv is modified now\&. The recognized options are
	    # removed from it, leaving the non-option arguments behind\&.
        } trap {CMDLINE USAGE} {msg o} {
            # Trap the usage signal, print the message, and exit the application\&.
            # Note: Other errors are not caught and passed through to higher levels!
	    puts $msg
	    exit 1
        }

        if {  $params(a) } { set set_atime "true" }
        set has_t [expr {$params(t) != -1}]
        set has_r [expr {[string length $params(r)] > 0}]
        if {$has_t && $has_r} {
            return -code error "Cannot specify both -r and -t"
        } elseif {$has_t} {
	    \&.\&.\&.
        }

.CE
.SS CMDLINE::GETOPT
This example shows the core loop of \fBcmdline::getoptions\fR from the
previous example\&. It demonstrates how it uses \fBcmdline::get\fR to
process the options one at a time\&.
.CS


    while {[set err [getopt argv $opts opt arg]]} {
	if {$err < 0} {
            set result(?) ""
            break
	}
	set result($opt) $arg
    }

.CE
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIcmdline\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
argument processing, argv, argv0, cmdline processing, command line processing
.SH CATEGORY
Programming tools
