
[//000000001]: # (zipfile::mkzip \- Zip archive creation)
[//000000002]: # (Generated from file 'mkzip\.man' by tcllib/doctools with format 'markdown')
[//000000003]: # (Copyright &copy; 2009 Pat Thoyts)
[//000000004]: # (zipfile::mkzip\(n\) 1\.2\.4 tcllib "Zip archive creation")

<hr> [ <a href="../../../../toc.md">Main Table Of Contents</a> &#124; <a
href="../../../toc.md">Table Of Contents</a> &#124; <a
href="../../../../index.md">Keyword Index</a> &#124; <a
href="../../../../toc0.md">Categories</a> &#124; <a
href="../../../../toc1.md">Modules</a> &#124; <a
href="../../../../toc2.md">Applications</a> ] <hr>

# NAME

zipfile::mkzip \- Build a zip archive

# <a name='toc'></a>Table Of Contents

  - [Table Of Contents](#toc)

  - [Synopsis](#synopsis)

  - [Description](#section1)

  - [API](#section2)

  - [Bugs, Ideas, Feedback](#section3)

  - [Keywords](#keywords)

  - [Category](#category)

  - [Copyright](#copyright)

# <a name='synopsis'></a>SYNOPSIS

package require Tcl 8\.6 9  
package require zipfile::mkzip ?1\.2\.4?  

[__::zipfile::mkzip::mkzip__ *zipfile* ?__\-zipkit__? ?__\-runtime__ *prefix*? ?__\-comment__ *string*? ?__\-directory__ *rootpath*? ?__\-prepend\-base\-directory__ *bool*? ?__\-exclude__ *exclude*? ?__\-\-__? ?*path*\.\.\.?](#1)  

# <a name='description'></a>DESCRIPTION

This package utilizes the zlib functions in Tcl 8\.6 to build zip archives\.

# <a name='section2'></a>API

  - <a name='1'></a>__::zipfile::mkzip::mkzip__ *zipfile* ?__\-zipkit__? ?__\-runtime__ *prefix*? ?__\-comment__ *string*? ?__\-directory__ *rootpath*? ?__\-prepend\-base\-directory__ *bool*? ?__\-exclude__ *exclude*? ?__\-\-__? ?*path*\.\.\.?

    From [http://wiki\.tcl\.tk/15158](http://wiki\.tcl\.tk/15158)

    This command constructs a zip archive from a directory tree using nothing
    but Tcl 8\.6 core features\. The resulting zip file should be compatible with
    other __[zip](\.\./\.\./\.\./\.\./index\.md\#zip)__ programs \- with the
    possible exception of unicode support\. The files generated by this command
    use utf\-8 encoding for all filenames and comments and it has been noticed
    particularly on Windows the __info\-zip__ and the Windows built\-in zip
    view have rather poor support for this part of the ZIP file specification\.
    The __7\-Zip__ program does correctly display utf8 filenames however and
    the __vfs::zip__ package will use these of course\.

    If you use

    > __::mkzip::mkzip__ mystuff\.tm \-zipkit \-directory mystuff\.vfs

    it will pack your "mystuff\.vfs/" virtual filesystem tree into a zip archive
    with a suitable header such that on unix you may mark it executable and it
    should run with tclkit\. Or you can run it with __tclsh__ or __wish__
    8\.6 if you like\.

    To change the executable header, specify the __\-runtime__ "preface"
    where preface is a file containing code you want prefixed\. For instance, on
    Windows you can create a self\-extracting zip archive using

        mkzip mystuff.exe -directory mystuff.vfs -runtime unzipsfx.exe

    The "unzipsfx\.exe" is the Info\-Zip self\-extracting stub\.

    Accepted options:

      * __\-runtime__ path

        This option specifies a file to use as prefix to the actual zip archive\.
        If specified __\-zipkit__ will be ignored\.

      * __\-zipkit__

        Instructs the command to generate a prefix which makes the archive a
        zip\-based starkit\. Ignored if __\-runtime__ is present\.

      * __\-comment__ string

        This options specifies a global comment to place into the generated
        archive\.

      * __\-directory__ path

        This option specifies the directory to place into the generated archive\.
        If specified any argument *path*s are *ignored*\.

      * __\-prepend\-base\-directory__ bool

        When this option is set the tail of the __\-directory__ path is
        prepended to all paths added to the archive\.

        The option is ignored when option __\-directory__ is not specified\.

        By default this option is __false__\.

      * __\-exclude__ list

        This option specifies a list of glob patterns\. All paths matching at
        least one of the patterns are not placed into the generated archive\.
        This option defaults to

            CVS/* */CVS/* *~ ".#*" "*/.#*"

      * __\-\-__

        This option signals the end of the options, forcing processing of all
        further words as arguments, even if they begin with a dash character\.

    Accepted arguments:

      * path *path*

        Each path is a directory or file to place into the generated archive\.
        Note however that these will be ignored when option __\-directory__
        is specified\.

# <a name='section3'></a>Bugs, Ideas, Feedback

This document, and the package it describes, will undoubtedly contain bugs and
other problems\. Please report such in the category *zipfile* of the [Tcllib
Trackers](http://core\.tcl\.tk/tcllib/reportlist)\. Please also report any ideas
for enhancements you may have for either package and/or documentation\.

When proposing code changes, please provide *unified diffs*, i\.e the output of
__diff \-u__\.

Note further that *attachments* are strongly preferred over inlined patches\.
Attachments can be made by going to the __Edit__ form of the ticket
immediately after its creation, and then using the left\-most button in the
secondary navigation bar\.

# <a name='keywords'></a>KEYWORDS

[decompression](\.\./\.\./\.\./\.\./index\.md\#decompression),
[zip](\.\./\.\./\.\./\.\./index\.md\#zip)

# <a name='category'></a>CATEGORY

File

# <a name='copyright'></a>COPYRIGHT

Copyright &copy; 2009 Pat Thoyts
