//
//  NSString+MPHash.m
//  MacPass
//
//  Created by Michael Starke on 05/02/16.
//  Copyright (c) 2016 HicknHack Software GmbH. All rights reserved.
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#import "NSString+MPHash.h"

#import <CommonCrypto/CommonCrypto.h>

@implementation NSString (MPHash)

+ (NSString*)sha1HexDigest:(NSString*)input {
  if(input.length == 0) {
    return nil;
  }
  const char* str = input.UTF8String;
  unsigned char result[CC_SHA1_DIGEST_LENGTH];
  CC_SHA1(str, (CC_LONG)strlen(str), result);
  
  NSMutableString *hexDigest = [NSMutableString stringWithCapacity:CC_SHA1_DIGEST_LENGTH*2];
  for(int i = 0; i<CC_SHA1_DIGEST_LENGTH; i++) {
    [hexDigest appendFormat:@"%02x",result[i]];
  }
  return hexDigest;
}

- (NSString *)sha1HexDigest {
  return [NSString sha1HexDigest:self];
}

@end
