/////////////////////////////////////////////////////////////////////////////
// Name:      MediaFile.h
// Author:    Alex Thuering
// Created:   7.07.2012
// Copyright: (c) Alex Thuering
// Licence:   GPL
/////////////////////////////////////////////////////////////////////////////

#include "MediaFile.h"
#include "utils.h"
#include <wx/file.h>
#include <wxSVG/mediadec_ffmpeg.h>
#include "../resources/video.png.h"

/** Constructor */
MediaFile::MediaFile() {
	this->size = 0;
	this->duration = 0;
}

/** Destructor */
MediaFile::~MediaFile() {
	VECTOR_CLEAR(streams, MediaStream)
}

bool MediaFile::Init(const wxString& fileName) {
	this->fileName = fileName;
	
	if (!wxFileExists(fileName))
		return false;
	this->size = wxFile(fileName).Length()/1024;
	
	wxFfmpegMediaDecoder ffmpeg;
	if (!ffmpeg.Load(fileName))
		return false;
	this->duration = ffmpeg.GetDuration() > 0 ? ffmpeg.GetDuration() : 0;
	for (unsigned int stIdx = 0; stIdx < ffmpeg.GetStreamCount(); stIdx++) {
		MediaStream* stream = new MediaStream(ffmpeg.GetStreamType(stIdx), ffmpeg.GetCodecName(stIdx));
		if (stream->GetType() == stAUDIO) {
			stream->SetChannelNumber(ffmpeg.GetChannelNumber(stIdx));
			stream->SetSampleRate(ffmpeg.GetSampleRate(stIdx));
			stream->SetBitrate(ffmpeg.GetBitrate(stIdx));
		} else if (stream->GetType() == stVIDEO) {
			stream->SetVideoSize(ffmpeg.GetVideoSize());
			stream->SetBitrate(ffmpeg.GetBitrate(stIdx));
			stream->SetAspectRatio(ffmpeg.GetFrameAspectRatio());
			stream->SetFps(ffmpeg.GetFps());
		}
		streams.push_back(stream);
	}
	// load video frame
	if (duration > 0) {
		image = ffmpeg.GetNextFrame();
		double dpos = duration < 6000 ? duration * 0.05 : 300;
		ffmpeg.SetPosition(dpos - 1.0);
		for (int i = 0; i < 60; i++) {
			image = ffmpeg.GetNextFrame();
			if (ffmpeg.GetPosition() >= dpos)
				break;
		}
	} else {
		for (int i = 0; i < 30; i++)
			image = ffmpeg.GetNextFrame();
	}
	ffmpeg.Close();
	if (!image.IsOk())
		image = wxBITMAP_FROM_MEMORY(video).ConvertToImage();
	
	return true;
}

/** Returns video stream */
MediaStream* MediaFile::GetVideoStream() const {
	for (vector<MediaStream*>::const_iterator it = streams.begin(); it != streams.end(); it++)
		if ((*it)->GetType() == stVIDEO)
			return (*it);
	return NULL;
}

/** Checks this file has streams compatible to given one */
bool MediaFile::HasCompatibleStreams(const MediaFile* mediaFile) {
	if (GetStreams().size() != mediaFile->GetStreams().size())
		return false;
	for (unsigned int i = 0; i < GetStreams().size(); i++) {
		if (!GetStreams()[i]->IsCompatibleTo(mediaFile->GetStreams()[i]))
			return false;
	}
	return true;
}
