
#include <config.h>
#include <stdio.h>
#include <math.h>
#include "global.h"

/* generate sequence header (6.2.2.1, 6.3.3)
 * matrix download not implemented */
void putseqhdr(void)
{
	int i;

	alignbits();
	putbits(SEQ_START_CODE,32); /* sequence_header_code */
	putbits(opt_horizontal_size,12); /* horizontal_size_value */
	putbits(opt_vertical_size,12); /* vertical_size_value */
	putbits(opt_aspectratio,4); /* aspect_ratio_information */
	putbits(opt_frame_rate_code,4); /* frame_rate_code */

	/* MPEG-1 VBR is FFFF rate code. 
	   MPEG-2 VBR is a matter of mux-ing.  The ceiling bit_rate is always sent */
	   /* dvd : 9800000*/
	putbits(9800000/400,18); /* bit_rate_value */ /*mak*/
	
	putbits(1,1); /* marker_bit */
	putbits(opt_vbv_buffer_code,10); /* vbv_buffer_size_value */
	putbits(0,1); /* constrained_parameters_flag */

	putbits(opt_load_iquant,1); /* load_intra_quantizer_matrix */
	if (opt_load_iquant)
		for (i=0; i<64; i++)  /* matrices are always downloaded in zig-zag order */
			putbits(opt_intra_q[zig_zag_scan[i]],8); /* intra_quantizer_matrix */

	putbits(opt_load_niquant,1); /* load_non_intra_quantizer_matrix */
	if (opt_load_niquant)
		for (i=0; i<64; i++)
			putbits(opt_inter_q[zig_zag_scan[i]],8); /* non_intra_quantizer_matrix */
			
	putseqext();
	putseqdispext();
}

/* generate sequence extension (6.2.2.3, 6.3.5) header (MPEG-2 only) */
void putseqext(void)
{
	alignbits();
	putbits(EXT_START_CODE,32); /* extension_start_code */
	putbits(SEQ_ID,4); /* extension_start_code_identifier */
	putbits((opt_profile<<4)|opt_level,8); /* profile_and_level_indication */
	putbits(opt_prog_seq,1); /* progressive sequence */
	putbits(opt_chroma_format,2); /* chroma_format */
	putbits(opt_horizontal_size>>12,2); /* horizontal_size_extension */
	putbits(opt_vertical_size>>12,2); /* vertical_size_extension */
	putbits((9800000/400)>>18,12); /* bit_rate_extension */
	putbits(1,1); /* marker_bit */
	putbits(opt_vbv_buffer_code>>10,8); /* vbv_buffer_size_extension */
	putbits(0,1); /* low_delay  -- currently not implemented */
	putbits(0,2); /* frame_rate_extension_n */
	putbits(0,5); /* frame_rate_extension_d */
}

/* generate sequence display extension (6.2.2.4, 6.3.6) */
void putseqdispext(void)
{
	alignbits();
	putbits(EXT_START_CODE,32); /* extension_start_code */
	putbits(DISP_ID,4); /* extension_start_code_identifier */
	putbits(opt_video_format,3); /* video_format */
	putbits(1,1); /* colour_description */
	putbits(opt_color_primaries,8); /* colour_primaries */
	putbits(opt_transfer_characteristics,8); /* transfer_characteristics */
	putbits(opt_matrix_coefficients,8); /* matrix_coefficients */
	putbits(opt_display_horizontal_size,14); /* display_horizontal_size */
	putbits(1,1); /* marker_bit */
	putbits(opt_display_vertical_size,14); /* display_vertical_size */
}

/* output a zero terminated string as user data (6.2.2.2.2, 6.3.4.1)
 * string must not emulate start codes */
void putuserdata(const uint8_t *userdata, int len)
{
	int i;
	alignbits();
	putbits(USER_START_CODE,32); /* user_data_start_code */
	for( i =0; i < len; ++i )
		putbits(userdata[i],8);
}

/* generate group of pictures header (6.2.2.6, 6.3.9)
 * uses tc0 (timecode of first frame) and frame0 (number of first frame) */
void putgophdr(int frame,int closed_gop )
{
	alignbits();
	putbits(GOP_START_CODE, 32); /* group_start_code */
	
	//putbits(0,25); /* time_code */
	
	putbits(0, 1); /* drop_frame_flag */
	putbits(0, 11); /* time_code */
	putbits(1, 1); /* marker_bit */
	putbits(0, 12); /* time_code */
	
	putbits(closed_gop, 1); /* closed_gop */
	putbits(0, 1); /* broken_link */
}

/* generate picture header (6.2.3, 6.3.10) */
void putpicthdr(pict_data_s *picture)
{
	alignbits();
	putbits(PICTURE_START_CODE,32); /* picture_start_code */
	putbits(picture->temp_ref,10); /* temporal_reference */
	putbits(picture->pict_type,3); /* picture_coding_type */
	putbits(0xFFFF,16); /* vbv_delay */

	if (picture->pict_type==P_TYPE || picture->pict_type==B_TYPE)
	{
		putbits(0,1); /* full_pel_forward_vector */
		putbits(7,3); /* forward_f_code */
	}
	if (picture->pict_type==B_TYPE)
	{
		putbits(0,1); /* full_pel_backward_vector */
		putbits(7,3); /* backward_f_code */
	}

	putbits(0,1); /* extra_bit_picture */
}

/* generate picture coding extension (6.2.3.1, 6.3.11)
 * composite display information (v_axis etc.) not implemented */
void putpictcodext(pict_data_s *picture)
{
	alignbits();
	putbits(EXT_START_CODE,32); /* extension_start_code */
	putbits(CODING_ID,4); /* extension_start_code_identifier */
	putbits(picture->forw_hor_f_code,4); /* forward_horizontal_f_code */
	putbits(picture->forw_vert_f_code,4); /* forward_vertical_f_code */
	putbits(picture->back_hor_f_code,4); /* backward_horizontal_f_code */
	putbits(picture->back_vert_f_code,4); /* backward_vertical_f_code */
	putbits(picture->dc_prec,2); /* intra_dc_precision */
	putbits(picture->pict_struct,2); /* picture_structure */
	putbits(picture->topfirst, 1); /* top_field_first */
	putbits(1,1); /* frame_pred_frame_dct */
	putbits(0,1); /* concealment_motion_vectors  -- currently not implemented */
	putbits(picture->q_scale_type,1); /* q_scale_type */
	putbits(picture->intravlc,1); /* intra_vlc_format */
	putbits(picture->altscan,1); /* alternate_scan */
	putbits(picture->repeatfirst,1); /* repeat_first_field */
	putbits(picture->prog_frame,1); /* chroma_420_type */
	putbits(picture->prog_frame,1); /* progressive_frame */
	putbits(0,1); /* composite_display_flag */
}

/* generate sequence_end_code (6.2.2) */
void putseqend(void)
{
	alignbits();
	putbits(SEQ_END_CODE,32);
}
