
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "global.h"

extern FILE *outfile; /* the only global var we need here */
/* private data */
static unsigned int outbfr;
static int outcnt;
static int64_t bytecnt;

typedef unsigned char uint8;
uint8 *obuf, *buf;

#define BUF_SIZE (1024*1024)

/* initialize buffer, call once before first putbits or alignbits */
void initbits(void)
{
  outbfr = 0;
  outcnt = 8;
  bytecnt = BITCOUNT_OFFSET/8LL;
  buf = obuf = (uint8*)malloc(BUF_SIZE);
}

/* write rightmost n (0<=n<=32) bits of val to outfile */
void putbits(uint32_t val, int n)
{
  val = (n == 32) ? val : (val & (~(0xffffffffU << n)));
  while( n >= outcnt )
  {
	  outbfr = (outbfr << outcnt ) | (val >> (n-outcnt));
	  assert(buf < obuf + BUF_SIZE);
	  buf[0] = outbfr;
	  buf++;
	  n -= outcnt;
	  outcnt = 8;
	  bytecnt++;
  }
  if( n != 0 )
  {
	  outbfr = (outbfr<<n) | val;
	  outcnt -= n;
  }
}

int inline bufferSize(void)
{
	return buf - obuf;
}

void inline resetBuffer(void)
{
	bytecnt -= bufferSize();
	buf = obuf;
}

void inline writeBuffer(void)
{
	fwrite(obuf, buf - obuf, 1, outfile);
	buf = obuf;
}

/* zero bit stuffing to next byte boundary (5.2.3, 6.2.1) */
void inline alignbits(void)
{
  if (outcnt!=8) putbits(0,outcnt);
}

/* return total number of generated bits */
int64_t inline bitcount(void)
{
  return 8LL*bytecnt + (8-outcnt);
}
