# Table/List of Key Modifications of LightGBM

The list includes the commits where the major feature added is considered working with the least amount of flaws. This is useful if you are trying to get a specific commit, such as the first properly working commit for categorical support.

## Modification Table

| Date | Commit | Type | Description |
| --- | --- | --- | --- |
| 02/09/2017 | [574d780](https://github.com/microsoft/LightGBM/pull/878) | Docs | Readme Badges (Pull Request 878) |
| 14/08/2017 | [1b8910b](https://github.com/microsoft/LightGBM/pull/825) | Feature | SHAP Feature Importance (Pull Request 825) |
| 02/08/2017 | [f2bec2b](https://github.com/microsoft/LightGBM/pull/762) | Feature | Improved categorical feature support (Pull Request 762) |
| 30/07/2017 | [00cb04a](https://github.com/microsoft/LightGBM/pull/747) | Feature | Better missing value handle (Pull Request 747) |
| 13/07/2017 | [3421bc6](https://github.com/microsoft/LightGBM/pull/664) | Feature | Automatic Compiler for R-package compilation (Pull Request 664) |
| 10/07/2017 | [ce999b7](https://github.com/microsoft/LightGBM/pull/678) | Feature | Random Forest mode (Pull Request 678) |
| 22/06/2017 | [d862b3e](https://github.com/microsoft/LightGBM/pull/642) | CIntegration | Travis OSX Support (Pull Request 642) |
| 20/06/2017 | [80c641c](https://github.com/microsoft/LightGBM/pull/635) | Release | Python pip package (Pull Request 635) |
| 18/06/2017 | [4d2aa84](https://github.com/microsoft/LightGBM/pull/634) | CIntegration | AppVeyor Support (Pull Request 634) |
| 06/06/2017 | [2c9ce59](https://github.com/microsoft/LightGBM/pull/592) | Release | R-package version 0.2 (Pull Request 592) |
| 05/06/2017 | [f98d75f](https://github.com/microsoft/LightGBM/pull/584) | Feature | Use custom compiler for R-package (Pull Request 584) |
| 29/05/2017 | [993bbd5](https://github.com/microsoft/LightGBM/pull/559) | Parameter | Early Stopping for predictions (Pull Request 559) |
| 26/05/2017 | [3abff37](https://github.com/microsoft/LightGBM/commit/3abff370bb353293e4a03e516111dd02785fbd97) | Feature | Parameter to disable missing values (Commit) |
| 21/05/2017 | [4cf9376](https://github.com/microsoft/LightGBM/commit/4cf9376d6652d3d7afa82e98dfb363af9275969d) | Feature | Limitation of threads for dataset construction (Commit) |
| 15/05/2017 | [e984b0d](https://github.com/microsoft/LightGBM/pull/516) | Feature | Support for missing values (Pull Request 516) |
| 14/05/2017 | [358553d](https://github.com/microsoft/LightGBM/pull/511) | Docs | Interactive External Website (Pull Request 511) |
| 04/05/2017 | [ca30b8c](https://github.com/microsoft/LightGBM/pull/489) | Docs | Read The Docs (Pull Request 489) |
| 28/04/2017 | [8a19834](https://github.com/microsoft/LightGBM/pull/469) | Feature | If-Then-Else C++ Trees Generation (Pull Request 469) |
| 18/04/2017 | [7339ed6](https://github.com/microsoft/LightGBM/pull/426) | Feature | Whitespaces Removed from Features support (Pull Request 426) |
| 14/04/2017 | [9224a9d](https://github.com/microsoft/LightGBM/pull/415) | Release | GPU support (Pull Request 415)<br>With original ([0bb4a82](https://github.com/microsoft/LightGBM/pull/368) on 09/04/2017, Pull Request 368) |
| 13/04/2017 | [ab55910](https://github.com/microsoft/LightGBM/pull/404) | Feature | Speed Improvements for Prediction (Pull Request 404) |
| 06/04/2017 | [bfb0217](https://github.com/microsoft/LightGBM/pull/383) | Feature | Objective Transformations to the Objective (Pull Request 383) |
| 05/04/2017 | [d4c4d9a](https://github.com/microsoft/LightGBM/pull/381) | Feature | Regression Speed Improvements (Pull Request 381) |
| 03/04/2017 | [b6c973a](https://github.com/microsoft/LightGBM/pull/378) | Feature | Unloading Memory Fix support for R-package (Pull Request 378) |
| 17/03/2017 | [06a915a](https://github.com/microsoft/LightGBM/pull/347) | Feature | RDS support for R pacakge (Pull Request 347) |
| 10/03/2017 | [b7e5f07](https://github.com/microsoft/LightGBM/pull/340) | Feature | Support Self-Contained R-package (Pull Request 340) |
| 02/03/2017 | [4d6ff28](https://github.com/microsoft/LightGBM/pull/330) | Feature | Feature Contribution Plot for R-package (Pull Request 330) |
| 01/03/2017 | [166421e](https://github.com/microsoft/LightGBM/pull/328) | Feature | Feature Importance Plot for R-package (Pull Request 328) |
| 27/02/2017 | [fddb52f](https://github.com/microsoft/LightGBM/pull/323) | Feature | Feature Contribution for R-package (Pull Request 323) |
| 20/02/2017 | [10212b5](https://github.com/microsoft/LightGBM/pull/300) | Release | v2 (Pull Request 300) |
| 12/02/2017 | [ea6bc0a](https://github.com/microsoft/LightGBM/pull/290) | Release | v1 (Pull Request 290) |
| 02/02/2017 | [8c8ed6c](https://github.com/microsoft/LightGBM/pull/275) | Feature | Docker support (Pull Request 275) |
| 30/01/2017 | [4f3e9d8](https://github.com/microsoft/LightGBM/pull/270) | Feature | Poisson Objective support (Pull Request 270) |
| 28/01/2017 | [5856554](https://github.com/microsoft/LightGBM/pull/266) | Feature | Plot Metric support for Python-package (Pull Request 266) |
| 25/01/2017 | [8980fc7](https://github.com/microsoft/LightGBM/pull/262) | Feature | Plot Tree support for Python-package (Pull Request 262)<br>With original ([fafbcb3](https://github.com/microsoft/LightGBM/pull/258) on 25/01/2017, Pull Request 258) |
| 20/01/2017 | [abaefb5](https://github.com/microsoft/LightGBM/pull/237) | Feature | Feature Importance Plot for Python-package (Pull Request 237) |
| 16/01/2017 | [a2ae838](https://github.com/microsoft/LightGBM/pull/229) | Feature | Categorical Feature support for R-package (Pull Request 229) |
| 16/01/2017 | [57d5527](https://github.com/microsoft/LightGBM/pull/218) | Feature | Pandas Categorical support for Python-package (Pull Request 193)<br>With original ([a2ae838](https://github.com/microsoft/LightGBM/pull/193) on 12/01/2017, Pull Request 193) |
| 10/01/2017 | [fb732c3](https://github.com/microsoft/LightGBM/pull/180) | Feature | Fair Loss Objective support (Pull Request 180) |
| 09/01/2017 | [27d3eb3](https://github.com/microsoft/LightGBM/pull/178) | Feature | Huber Loss Objective support (Pull Request 178)<br>With original ([a87af87](https://github.com/microsoft/LightGBM/pull/174) on 09/01/2017, Pull Request 174) |
| 09/01/2017 | [9b2558d](https://github.com/microsoft/LightGBM/pull/177) | Feature | devtools R Installation support (Pull Request 177) |
| 09/01/2017 | [6219df7](https://github.com/microsoft/LightGBM/pull/175) | Feature | L1 Loss Objective support (Pull Request 175) |
| 08/01/2017 | [551d59c](https://github.com/microsoft/LightGBM/pull/168) | Release | R support (Pull Request 168) |
| 05/01/2017 | [96d08f4](https://github.com/microsoft/LightGBM/pull/153) | Feature | PMML support (Pull Request 153) |
| 01/01/2017 | [a034cee](https://github.com/microsoft/LightGBM/pull/151) | Feature | Pickle support for Python-package (Pull Request 151) |
| 26/12/2016 | [96cba41](https://github.com/microsoft/LightGBM/pull/139) | Parameter | DART xgboost support (Pull Request 139) |
| 19/12/2016 | [99b483d](https://github.com/microsoft/LightGBM/pull/133) | Parameter | Learning Rate in DART support (Pull Request 133) |
| 01/12/2016 | [16d1853](https://github.com/microsoft/LightGBM/pull/94) | Release | Python support (Pull Request 94) |
| 11/11/2016 | [98be7e3](https://github.com/microsoft/LightGBM/pull/67) | Feature | DART booster support (Pull Request 67) |
| 08/11/2016 | [785398a](https://github.com/microsoft/LightGBM/pull/69) | Parameter | L1 Regularization, L2 Regularization, Minimum Gain to Split support (Pull Request 69) |
| 05/11/2016 | [1466f90](https://github.com/microsoft/LightGBM/pull/108) | Release | Categorical Feature support (Pull Request 108) |
| 01/11/2016 | [aa796a8](https://github.com/microsoft/LightGBM/pull/53) | Feature | Multiclass classification support (Pull Request 53) |
| 28/10/2016 | [c45d1d9](https://github.com/microsoft/LightGBM/pull/42) | Feature | Feature Importance support (Pull Request 42) |
| 25/10/2016 | [a6a75fe](https://github.com/microsoft/LightGBM/pull/35) | Parameter | Maximum Depth support (Pull Request 35) |
| 24/10/2016 | [9fe0dea](https://github.com/microsoft/LightGBM/pull/30) | Parameter | Leaf Index Prediction support (Pull Request 30) |
| 21/10/2016 | [7aaba32](https://github.com/microsoft/LightGBM/pull/27) | Parameter | Early Stopping support (Pull Request 27)<br>With original ([7d4b6d4](https://github.com/microsoft/LightGBM/pull/21) on 20/10/2017, Pull Request 21) |
| 17/10/2016 | [65ddd85](https://github.com/guFalcon/LightGBM/commit/65ddd852d8d160d86080c45512bd435d15837927) | Release | LightGBM compilable (Commit) |

## Modification List

* 02/09/2017 [Microsoft/LightGBM@574d780](https://github.com/microsoft/LightGBM/pull/878): Docs: Readme Badges (Pull Request 878)
* 14/08/2017 [Microsoft/LightGBM@1b8910b](https://github.com/microsoft/LightGBM/pull/825): Feature: SHAP Feature Importance (Pull Request 825)
* 02/08/2017 [Microsoft/LightGBM@f2bec2b](https://github.com/microsoft/LightGBM/pull/762): Feature: Improved categorical feature support (Pull Request 762)
* 30/07/2017 [Microsoft/LightGBM@00cb04a](https://github.com/microsoft/LightGBM/pull/747): Feature: Better missing value handle (Pull Request 747)
* 13/07/2017 [Microsoft/LightGBM@3421bc6](https://github.com/microsoft/LightGBM/pull/664): Feature: Automatic Compiler for R-package compilation (Pull Request 664)
* 10/07/2017 [Microsoft/LightGBM@ce999b7](https://github.com/microsoft/LightGBM/pull/678): Feature: Random Forest mode (Pull Request 678)
* 22/06/2017 [Microsoft/LightGBM@d862b3e](https://github.com/microsoft/LightGBM/pull/642): CIntegration: Travis OSX Support (Pull Request 642)
* 20/06/2017 [Microsoft/LightGBM@80c641c](https://github.com/microsoft/LightGBM/pull/635): Release: Python pip package (Pull Request 635)
* 18/06/2017 [Microsoft/LightGBM@4d2aa84](https://github.com/microsoft/LightGBM/pull/634): CIntegration: AppVeyor Support (Pull Request 634)
* 06/06/2017 [Microsoft/LightGBM@2c9ce59](https://github.com/microsoft/LightGBM/pull/592): Release: R-package version 0.2 (Pull Request 592)
* 05/06/2017 [Microsoft/LightGBM@f98d75f](https://github.com/microsoft/LightGBM/pull/584): Feature: Use custom compiler for R-package (Pull Request 584)
* 29/05/2017 [Microsoft/LightGBM@993bbd5](https://github.com/microsoft/LightGBM/pull/559): Parameter: Early Stopping for predictions (Pull Request 559)
* 26/05/2017 [Microsoft/LightGBM@3abff37](https://github.com/microsoft/LightGBM/commit/3abff370bb353293e4a03e516111dd02785fbd97): Feature: Parameter to disable missing values (Commit)
* 21/05/2017 [Microsoft/LightGBM@4cf9376](https://github.com/microsoft/LightGBM/commit/4cf9376d6652d3d7afa82e98dfb363af9275969d): Feature: Limitation of threads for dataset construction (Commit)
* 15/05/2017 [Microsoft/LightGBM@e984b0d](https://github.com/microsoft/LightGBM/pull/516): Feature: Support for missing values (Pull Request 516)
* 14/05/2017 [Microsoft/LightGBM@358553d](https://github.com/microsoft/LightGBM/pull/511): Docs: Interactive External Website (Pull Request 511)
* 04/05/2017 [Microsoft/LightGBM@ca30b8c](https://github.com/microsoft/LightGBM/pull/489): Docs: Read The Docs (Pull Request 489)
* 28/04/2017 [Microsoft/LightGBM@8a19834](https://github.com/microsoft/LightGBM/pull/469): Feature: If-Then-Else C++ Trees Generation (Pull Request 469)
* 18/04/2017 ([Microsoft/LightGBM@7339ed6](https://github.com/microsoft/LightGBM/pull/426)): Feature: Whitespaces Removed from Features support (Pull Request 426)
* 14/04/2017 ([Microsoft/LightGBM@9224a9d](https://github.com/microsoft/LightGBM/pull/415)): Release: GPU support (Pull Request 415) with original ([Microsoft/LightGBM@0bb4a82](https://github.com/microsoft/LightGBM/pull/368) on 09/04/2017, Pull Request 368)
* 13/04/2017 ([Microsoft/LightGBM@ab55910](https://github.com/microsoft/LightGBM/pull/404)): Feature: Speed Improvements for Prediction (Pull Request 404)
* 06/04/2017 ([Microsoft/LightGBM@bfb0217](https://github.com/microsoft/LightGBM/pull/383)): Feature: Objective Transformations to the Objective (Pull Request 383)
* 05/04/2017 ([Microsoft/LightGBM@d4c4d9a](https://github.com/microsoft/LightGBM/pull/381)): Feature: Regression Speed Improvements (Pull Request 381)
* 03/04/2017 ([Microsoft/LightGBM@b6c973a](https://github.com/microsoft/LightGBM/pull/378)): Feature: Unloading Memory Fix support for R-package (Pull Request 378)
* 17/03/2017 ([Microsoft/LightGBM@06a915a](https://github.com/microsoft/LightGBM/pull/347)): Feature: RDS support for R pacakge (Pull Request 347)
* 10/03/2017 ([Microsoft/LightGBM@b7e5f07](https://github.com/microsoft/LightGBM/pull/340)): Feature: Support Self-Contained R-package (Pull Request 340)
* 02/03/2017 ([Microsoft/LightGBM@4d6ff28](https://github.com/microsoft/LightGBM/pull/330)): Feature: Feature Contribution Plot for R-package (Pull Request 330)
* 01/03/2017 ([Microsoft/LightGBM@166421e](https://github.com/microsoft/LightGBM/pull/328)): Feature: Feature Importance Plot for R-package (Pull Request 328)
* 27/02/2017 ([Microsoft/LightGBM@fddb52f](https://github.com/microsoft/LightGBM/pull/323)): Feature: Feature Contribution for R-package (Pull Request 323)
* 20/02/2017 ([Microsoft/LightGBM@10212b5](https://github.com/microsoft/LightGBM/pull/300)): Release: v2 (Pull Request 300)
* 12/02/2017 ([Microsoft/LightGBM@ea6bc0a](https://github.com/microsoft/LightGBM/pull/290)): Release: v1 (Pull Request 290)
* 02/02/2017 ([Microsoft/LightGBM@8c8ed6c](https://github.com/microsoft/LightGBM/pull/275)): Feature: Docker support (Pull Request 275)
* 30/01/2017 ([Microsoft/LightGBM@4f3e9d8](https://github.com/microsoft/LightGBM/pull/270)): Feature: Poisson Objective support (Pull Request 270)
* 28/01/2017 ([Microsoft/LightGBM@5856554](https://github.com/microsoft/LightGBM/pull/266)): Feature: Plot Metric support for Python-package (Pull Request 266)
* 25/01/2017 ([Microsoft/LightGBM@8980fc7](https://github.com/microsoft/LightGBM/pull/262)): Feature: Plot Tree support for Python-package (Pull Request 262) with original ([Microsoft/LightGBM@fafbcb3](https://github.com/microsoft/LightGBM/pull/258) on 25/01/2017, Pull Request 258)
* 20/01/2017 ([Microsoft/LightGBM@abaefb5](https://github.com/microsoft/LightGBM/pull/237)): Feature: Feature Importance Plot for Python-package (Pull Request 237)
* 16/01/2017 ([Microsoft/LightGBM@a2ae838](https://github.com/microsoft/LightGBM/pull/229)): Feature: Categorical Feature support for R-package (Pull Request 229)
* 16/01/2017 ([Microsoft/LightGBM@57d5527](https://github.com/microsoft/LightGBM/pull/218)): Feature: Pandas Categorical support for Python-package (Pull Request 193) with original ([Microsoft/LightGBM@a2ae838](https://github.com/microsoft/LightGBM/pull/193) on 12/01/2017, Pull Request 193)
* 10/01/2017 ([Microsoft/LightGBM@fb732c3](https://github.com/microsoft/LightGBM/pull/180)): Feature: Fair Loss Objective support (Pull Request 180)
* 09/01/2017 ([Microsoft/LightGBM@27d3eb3](https://github.com/microsoft/LightGBM/pull/178)): Feature: Huber Loss Objective support (Pull Request 178) with original ([Microsoft/LightGBM@a87af87](https://github.com/microsoft/LightGBM/pull/174) on 09/01/2017, Pull Request 174)
* 09/01/2017 ([Microsoft/LightGBM@9b2558d](https://github.com/microsoft/LightGBM/pull/177)): Feature: devtools R Installation support (Pull Request 177)
* 09/01/2017 ([Microsoft/LightGBM@6219df7](https://github.com/microsoft/LightGBM/pull/175)): Feature: L1 Loss Objective support (Pull Request 175)
* 08/01/2017 ([Microsoft/LightGBM@551d59c](https://github.com/microsoft/LightGBM/pull/168)): Release: R support (Pull Request 168)
* 05/01/2017 ([Microsoft/LightGBM@96d08f4](https://github.com/microsoft/LightGBM/pull/153)): Feature: PMML support (Pull Request 153)
* 01/01/2017 ([Microsoft/LightGBM@a034cee](https://github.com/microsoft/LightGBM/pull/151)): Feature: Pickle support for Python-package (Pull Request 151)
* 26/12/2016 ([Microsoft/LightGBM@96cba41](https://github.com/microsoft/LightGBM/pull/139)): Parameter: DART xgboost support (Pull Request 139)
* 19/12/2016 ([Microsoft/LightGBM@99b483d](https://github.com/microsoft/LightGBM/pull/133)): Parameter: Learning Rate in DART support (Pull Request 133)
* 01/12/2016 ([Microsoft/LightGBM@16d1853](https://github.com/microsoft/LightGBM/pull/94)): Release: Python support (Pull Request 94)
* 11/11/2016 ([Microsoft/LightGBM@98be7e3](https://github.com/microsoft/LightGBM/pull/67)): Feature: DART booster support (Pull Request 67)
* 08/11/2016 ([Microsoft/LightGBM@785398a](https://github.com/microsoft/LightGBM/pull/69)): Parameter: L1 Regularization, L2 Regularization, Minimum Gain to Split support (Pull Request 69)
* 05/11/2016 ([Microsoft/LightGBM@1466f90](https://github.com/microsoft/LightGBM/pull/108)): Release: Categorical Feature support (Pull Request 108)
* 01/11/2016 ([Microsoft/LightGBM@aa796a8](https://github.com/microsoft/LightGBM/pull/53)): Feature: Multiclass classification support (Pull Request 53)
* 28/10/2016 ([Microsoft/LightGBM@c45d1d9](https://github.com/microsoft/LightGBM/pull/42)): Feature: Feature Importance support (Pull Request 42)
* 25/10/2016 ([Microsoft/LightGBM@a6a75fe](https://github.com/microsoft/LightGBM/pull/35)): Parameter: Maximum Depth support (Pull Request 35)
* 24/10/2016 ([Microsoft/LightGBM@9fe0dea](https://github.com/microsoft/LightGBM/pull/30)): Parameter: Leaf Index Prediction support (Pull Request 30)
* 21/10/2016 ([Microsoft/LightGBM@7aaba32](https://github.com/microsoft/LightGBM/pull/27)): Parameter: Early Stopping support (Pull Request 27) with original ([Microsoft/LightGBM@7d4b6d4](https://github.com/microsoft/LightGBM/pull/21) on 20/10/2017, Pull Request 21)
* 17/10/2016 ([Microsoft/LightGBM@65ddd85](https://github.com/guFalcon/LightGBM/commit/65ddd852d8d160d86080c45512bd435d15837927)): Release: LightGBM compilable (Commit)
