/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class LemmaSample
implements Serializable {
    private List<String> tokens;
    private List<String> tags;
    private final List<String> lemmas;

    public LemmaSample(String[] tokens, String[] tags, String[] lemmas) {
        this.validateArguments(tokens.length, tags.length, lemmas.length);
        this.tokens = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(tokens)));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(tags)));
        this.lemmas = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(lemmas)));
    }

    public LemmaSample(List<String> tokens, List<String> tags, List<String> lemmas) {
        this.validateArguments(tokens.size(), tags.size(), lemmas.size());
        this.tokens = Collections.unmodifiableList(new ArrayList<String>(tokens));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(tags));
        this.lemmas = Collections.unmodifiableList(new ArrayList<String>(lemmas));
    }

    public String[] getTokens() {
        return this.tokens.toArray(new String[this.tokens.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[] getLemmas() {
        return this.lemmas.toArray(new String[this.lemmas.size()]);
    }

    private void validateArguments(int tokensSize, int tagsSize, int lemmasSize) throws IllegalArgumentException {
        if (tokensSize != tagsSize || tagsSize != lemmasSize) {
            throw new IllegalArgumentException("All arrays must have the same length: sentenceSize: " + tokensSize + ", tagsSize: " + tagsSize + ", predsSize: " + lemmasSize + "!");
        }
    }

    public String toString() {
        StringBuilder lemmaString = new StringBuilder();
        for (int ci = 0; ci < this.lemmas.size(); ++ci) {
            lemmaString.append(this.tokens.get(ci)).append("\t").append(this.tags.get(ci)).append("\t").append(this.lemmas.get(ci)).append("\n");
        }
        return lemmaString.toString();
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.getTokens()), Arrays.hashCode(this.getTags()), Arrays.hashCode(this.getLemmas()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LemmaSample) {
            LemmaSample a = (LemmaSample)obj;
            return Arrays.equals(this.getTokens(), a.getTokens()) && Arrays.equals(this.getTags(), a.getTags()) && Arrays.equals(this.getLemmas(), a.getLemmas());
        }
        return false;
    }
}

