/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.languagetool.AnalyzedSentence;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SameRuleGroupFilter;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleTransformer;

public class RepeatedPatternRuleTransformer
implements PatternRuleTransformer {
    protected int maxDistance = 350;
    protected final Language transformerLanguage;

    public RepeatedPatternRuleTransformer(Language lang) {
        this.transformerLanguage = lang;
    }

    @Override
    public PatternRuleTransformer.TransformedRules apply(List<AbstractPatternRule> patternRules) {
        ArrayList<AbstractPatternRule> remaining = new ArrayList<AbstractPatternRule>();
        HashMap<String, List> toTransform = new HashMap<String, List>();
        for (AbstractPatternRule abstractPatternRule : patternRules) {
            if (abstractPatternRule.getMinPrevMatches() > 0) {
                toTransform.compute(abstractPatternRule.getId(), (id, rules) -> {
                    if (rules == null) {
                        return new ArrayList<AbstractPatternRule>(Collections.singletonList(abstractPatternRule));
                    }
                    rules.add(abstractPatternRule);
                    return rules;
                });
                continue;
            }
            remaining.add(abstractPatternRule);
        }
        List<Rule> transformed = toTransform.values().stream().map(group -> new RepeatedPatternRule((List<AbstractPatternRule>)group, this.transformerLanguage)).collect(Collectors.toList());
        return new PatternRuleTransformer.TransformedRules(remaining, transformed);
    }

    public class RepeatedPatternRule
    extends TextLevelRule {
        protected final Language ruleLanguage;
        private final List<AbstractPatternRule> rules;

        RepeatedPatternRule(List<AbstractPatternRule> rules, Language lang) {
            this.rules = Collections.unmodifiableList(rules);
            this.ruleLanguage = lang;
        }

        public List<AbstractPatternRule> getWrappedRules() {
            return this.rules;
        }

        @Override
        public String getId() {
            return this.rules.get(0).getId();
        }

        @Override
        public String getDescription() {
            return this.rules.get(0).getDescription();
        }

        @Override
        public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
            ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
            int offset = 0;
            int prevFromPos = 0;
            int prevMatches = 0;
            for (AnalyzedSentence s : sentences) {
                List<RuleMatch> sentenceMatches = new ArrayList<RuleMatch>();
                for (AbstractPatternRule rule : this.rules) {
                    RuleMatch[] ruleMatches = rule.match(s);
                    sentenceMatches.addAll(Arrays.asList(ruleMatches));
                }
                sentenceMatches = new SameRuleGroupFilter().filter(sentenceMatches);
                for (RuleMatch m : sentenceMatches) {
                    int fromPos = m.getFromPos() + offset;
                    int toPos = m.getToPos() + offset;
                    m.setOffsetPosition(fromPos, toPos);
                    if (fromPos - prevFromPos <= RepeatedPatternRuleTransformer.this.maxDistance && prevMatches >= m.getRule().getMinPrevMatches()) {
                        matches.add(m);
                    }
                    prevFromPos = fromPos;
                    ++prevMatches;
                }
                offset += s.getText().length();
            }
            return matches.toArray(new RuleMatch[0]);
        }

        @Override
        public int minToCheckParagraph() {
            return 0;
        }

        @Override
        public boolean supportsLanguage(Language language) {
            return language.equalsConsiderVariantsIfSpecified(this.ruleLanguage);
        }
    }
}

