/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.masterslave;

import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisException;
import io.lettuce.core.RedisURI;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.masterslave.MasterSlaveChannelWriter;
import io.lettuce.core.masterslave.MasterSlaveConnectionProvider;
import io.lettuce.core.masterslave.MasterSlaveConnector;
import io.lettuce.core.masterslave.MasterSlaveTopologyRefresh;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnection;
import io.lettuce.core.masterslave.StatefulRedisMasterSlaveConnectionImpl;
import io.lettuce.core.masterslave.StaticMasterSlaveTopologyProvider;
import io.lettuce.core.models.role.RedisNodeDescription;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import reactor.core.publisher.Mono;

class StaticMasterSlaveConnector<K, V>
implements MasterSlaveConnector<K, V> {
    private final RedisClient redisClient;
    private final RedisCodec<K, V> codec;
    private final Iterable<RedisURI> redisURIs;

    StaticMasterSlaveConnector(RedisClient redisClient, RedisCodec<K, V> codec, Iterable<RedisURI> redisURIs) {
        this.redisClient = redisClient;
        this.codec = codec;
        this.redisURIs = redisURIs;
    }

    @Override
    public CompletableFuture<StatefulRedisMasterSlaveConnection<K, V>> connectAsync() {
        HashMap initialConnections = new HashMap();
        StaticMasterSlaveTopologyProvider topologyProvider = new StaticMasterSlaveTopologyProvider(this.redisClient, this.redisURIs);
        RedisURI seedNode = this.redisURIs.iterator().next();
        MasterSlaveTopologyRefresh refresh = new MasterSlaveTopologyRefresh(this.redisClient, topologyProvider);
        MasterSlaveConnectionProvider<K, V> connectionProvider = new MasterSlaveConnectionProvider<K, V>(this.redisClient, this.codec, seedNode, initialConnections);
        return refresh.getNodes(seedNode).flatMap(nodes -> {
            if (nodes.isEmpty()) {
                return Mono.error((Throwable)new RedisException(String.format("Cannot determine topology from %s", this.redisURIs)));
            }
            return this.initializeConnection(this.codec, seedNode, connectionProvider, (List<RedisNodeDescription>)nodes);
        }).onErrorMap(ExecutionException.class, Throwable::getCause).toFuture();
    }

    private Mono<StatefulRedisMasterSlaveConnection<K, V>> initializeConnection(RedisCodec<K, V> codec, RedisURI seedNode, MasterSlaveConnectionProvider<K, V> connectionProvider, List<RedisNodeDescription> nodes) {
        connectionProvider.setKnownNodes(nodes);
        MasterSlaveChannelWriter channelWriter = new MasterSlaveChannelWriter(connectionProvider, this.redisClient.getResources());
        StatefulRedisMasterSlaveConnectionImpl<K, V> connection = new StatefulRedisMasterSlaveConnectionImpl<K, V>(channelWriter, codec, seedNode.getTimeout());
        connection.setOptions(this.redisClient.getOptions());
        return Mono.just(connection);
    }
}

