/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core;

import io.lettuce.core.internal.LettuceAssert;
import java.time.Duration;

public class RestoreArgs {
    long ttl;
    boolean replace;

    public RestoreArgs ttl(long milliseconds) {
        this.ttl = milliseconds;
        return this;
    }

    public RestoreArgs ttl(Duration ttl) {
        LettuceAssert.notNull((Object)ttl, "Time to live must not be null");
        return this.ttl(ttl.toMillis());
    }

    public RestoreArgs replace() {
        return this.replace(true);
    }

    public RestoreArgs replace(boolean replace) {
        this.replace = replace;
        return this;
    }

    public static class Builder {
        private Builder() {
        }

        public static RestoreArgs ttl(long milliseconds) {
            return new RestoreArgs().ttl(milliseconds);
        }

        public static RestoreArgs ttl(Duration ttl) {
            LettuceAssert.notNull((Object)ttl, "Time to live must not be null");
            return Builder.ttl(ttl.toMillis());
        }
    }
}

