/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.morfologik.MorfologikMultiSpeller;
import org.languagetool.rules.spelling.suggestions.SuggestionsChanges;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrderer;
import org.languagetool.rules.spelling.suggestions.SuggestionsOrdererFeatureExtractor;
import org.languagetool.rules.spelling.suggestions.XGBoostSuggestionsOrderer;
import org.languagetool.rules.translation.TranslationEntry;
import org.languagetool.rules.translation.Translator;
import org.languagetool.tools.Tools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MorfologikSpellerRule
extends SpellingCheckRule {
    private static Logger logger = LoggerFactory.getLogger(MorfologikSpellerRule.class);
    protected MorfologikMultiSpeller speller1;
    protected MorfologikMultiSpeller speller2;
    protected MorfologikMultiSpeller speller3;
    protected Locale conversionLocale;
    protected final Language motherTongue;
    protected final GlobalConfig globalConfig;
    private final SuggestionsOrderer suggestionsOrderer;
    private final boolean runningExperiment;
    private boolean ignoreTaggedWords = false;
    private boolean checkCompound = false;
    private Pattern compoundRegex = Pattern.compile("-");
    private final UserConfig userConfig;
    static final int MAX_FREQUENCY_FOR_SPLITTING = 21;

    public abstract String getFileName();

    @Override
    public abstract String getId();

    public MorfologikSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig) throws IOException {
        this(messages, language, userConfig, Collections.emptyList());
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, null, userConfig, altLanguages, null, null);
    }

    public MorfologikSpellerRule(ResourceBundle messages, Language language, GlobalConfig globalConfig, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel, Language motherTongue) throws IOException {
        super(messages, language, userConfig, altLanguages, languageModel);
        this.globalConfig = globalConfig;
        this.userConfig = userConfig;
        this.motherTongue = motherTongue;
        super.setCategory(Categories.TYPOS.getCategory(messages));
        this.conversionLocale = this.conversionLocale != null ? this.conversionLocale : Locale.getDefault();
        this.init();
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
        if (SuggestionsChanges.isRunningExperiment("NewSuggestionsOrderer")) {
            this.suggestionsOrderer = new SuggestionsOrdererFeatureExtractor(language, this.languageModel);
            this.runningExperiment = true;
        } else {
            this.runningExperiment = false;
            this.suggestionsOrderer = new XGBoostSuggestionsOrderer(language, languageModel);
        }
    }

    @Override
    public String getDescription() {
        return this.messages.getString("desc_spelling");
    }

    public void setLocale(Locale locale) {
        this.conversionLocale = locale;
    }

    public void setIgnoreTaggedWords() {
        this.ignoreTaggedWords = true;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = this.getSentenceWithImmunization(sentence).getTokensWithoutWhitespace();
        if (this.initSpellers()) {
            return this.toRuleMatchArray(ruleMatches);
        }
        int idx = -1;
        for (AnalyzedTokenReadings token : tokens) {
            int hiddenCharOffset;
            if (this.canBeIgnored(tokens, ++idx, token)) continue;
            int startPos = token.getStartPos();
            String word = token.getAnalyzedToken(0).getToken();
            int newRuleIdx = ruleMatches.size();
            if (this.tokenizingPattern() == null) {
                ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches, idx, tokens));
            } else {
                int index = 0;
                Matcher m = this.tokenizingPattern().matcher(word);
                while (m.find()) {
                    String match = word.subSequence(index, m.start()).toString();
                    ruleMatches.addAll(this.getRuleMatches(match, startPos + index, sentence, ruleMatches, idx, tokens));
                    index = m.end();
                }
                if (index == 0) {
                    ruleMatches.addAll(this.getRuleMatches(word, startPos, sentence, ruleMatches, idx, tokens));
                } else {
                    ruleMatches.addAll(this.getRuleMatches(word.subSequence(index, word.length()).toString(), startPos + index, sentence, ruleMatches, idx, tokens));
                }
            }
            if (ruleMatches.size() <= newRuleIdx || (hiddenCharOffset = token.getToken().length() - word.length()) <= 0) continue;
            for (int i = newRuleIdx; i < ruleMatches.size(); ++i) {
                RuleMatch ruleMatch = (RuleMatch)ruleMatches.get(i);
                if (token.getEndPos() < ruleMatch.getToPos()) continue;
                ruleMatch.setOffsetPosition(ruleMatch.getFromPos(), ruleMatch.getToPos() + hiddenCharOffset);
            }
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Nullable
    protected Translator getTranslator(GlobalConfig globalConfig) throws IOException {
        return null;
    }

    private boolean initSpellers() throws IOException {
        if (this.speller1 == null) {
            String binaryDict = null;
            if (JLanguageTool.getDataBroker().resourceExists(this.getFileName()) || Paths.get(this.getFileName(), new String[0]).toFile().exists()) {
                binaryDict = this.getFileName();
            }
            if (binaryDict != null) {
                this.initSpeller(binaryDict);
            } else {
                return true;
            }
        }
        return false;
    }

    private void initSpeller(String binaryDict) throws IOException {
        ArrayList<String> plainTextDicts = new ArrayList<String>();
        String languageVariantPlainTextDict = null;
        if (this.getSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getSpellingFileName())) {
            plainTextDicts.add(this.getSpellingFileName());
        }
        for (String fileName : this.getAdditionalSpellingFileNames()) {
            if (!JLanguageTool.getDataBroker().resourceExists(fileName)) continue;
            plainTextDicts.add(fileName);
        }
        if (this.getLanguageVariantSpellingFileName() != null && JLanguageTool.getDataBroker().resourceExists(this.getLanguageVariantSpellingFileName())) {
            languageVariantPlainTextDict = this.getLanguageVariantSpellingFileName();
        }
        this.speller1 = new MorfologikMultiSpeller(binaryDict, plainTextDicts, languageVariantPlainTextDict, this.userConfig, 1);
        this.speller2 = new MorfologikMultiSpeller(binaryDict, plainTextDicts, languageVariantPlainTextDict, this.userConfig, 2);
        this.speller3 = new MorfologikMultiSpeller(binaryDict, plainTextDicts, languageVariantPlainTextDict, this.userConfig, 3);
        this.setConvertsCase(this.speller1.convertsCase());
    }

    private boolean canBeIgnored(AnalyzedTokenReadings[] tokens, int idx, AnalyzedTokenReadings token) throws IOException {
        return token.isSentenceStart() || token.isImmunized() || token.isIgnoredBySpeller() || this.isUrl(token.getToken()) || this.isEMail(token.getToken()) || this.ignoreTaggedWords && token.isTagged() && !this.isProhibited(token.getToken()) || this.ignoreToken(tokens, idx);
    }

    @Override
    @Experimental
    public boolean isMisspelled(String word) throws IOException {
        this.initSpellers();
        return this.isMisspelled(this.speller1, word);
    }

    protected boolean isMisspelled(MorfologikMultiSpeller speller, String word) {
        if (!speller.isMisspelled(word)) {
            return false;
        }
        if (this.checkCompound && this.compoundRegex.matcher(word).find()) {
            String[] words;
            for (String singleWord : words = this.compoundRegex.split(word)) {
                if (!speller.isMisspelled(singleWord)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected int getFrequency(MorfologikMultiSpeller speller, String word) {
        return speller.getFrequency(word);
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        boolean fullResults;
        String nextWord;
        String sugg;
        String sugg2b;
        String sugg2a;
        String sugg1b;
        String sugg1a;
        String prevWord;
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        RuleMatch ruleMatch = null;
        if (!this.isMisspelled(this.speller1, word) && !this.isProhibited(word)) {
            return ruleMatches;
        }
        if (ruleMatchesSoFar.size() > 0 && ruleMatchesSoFar.get(ruleMatchesSoFar.size() - 1).getToPos() > startPos) {
            return ruleMatches;
        }
        String beforeSuggestionStr = "";
        String afterSuggestionStr = "";
        if (idx > 0 && (prevWord = tokens[idx - 1].getToken()).length() > 0 && !prevWord.matches(".*\\d.*") && this.getFrequency(this.speller1, prevWord) < 21) {
            int prevStartPos = tokens[idx - 1].getStartPos();
            sugg1a = prevWord.substring(0, prevWord.length() - 1);
            sugg1b = prevWord.substring(prevWord.length() - 1) + word;
            if (sugg1a.length() > 1 && sugg1b.length() > 2 && !this.isMisspelled(this.speller1, sugg1a) && !this.isMisspelled(this.speller1, sugg1b) && this.getFrequency(this.speller1, sugg1a) + this.getFrequency(this.speller1, sugg1b) > this.getFrequency(this.speller1, prevWord)) {
                ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, startPos, word, sugg1a, sugg1b, prevStartPos);
                beforeSuggestionStr = prevWord + " ";
            }
            sugg2a = prevWord + word.substring(0, 1);
            sugg2b = word.substring(1);
            if (sugg2a.length() > 1 && sugg2b.length() > 2 && !this.isMisspelled(this.speller1, sugg2a) && !this.isMisspelled(this.speller1, sugg2b)) {
                if (ruleMatch == null) {
                    if (this.getFrequency(this.speller1, sugg2a) + this.getFrequency(this.speller1, sugg2b) > this.getFrequency(this.speller1, prevWord)) {
                        ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, startPos, word, sugg2a, sugg2b, prevStartPos);
                        beforeSuggestionStr = prevWord + " ";
                    }
                } else {
                    ruleMatch.addSuggestedReplacement((sugg2a + " " + sugg2b).trim());
                }
            }
            sugg = prevWord + word;
            if (word.equals(word.toLowerCase()) && !this.isMisspelled(this.speller1, sugg)) {
                if (ruleMatch == null) {
                    if (this.getFrequency(this.speller1, sugg) >= this.getFrequency(this.speller1, prevWord)) {
                        ruleMatch = new RuleMatch(this, sentence, prevStartPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                        beforeSuggestionStr = prevWord + " ";
                        ruleMatch.setSuggestedReplacement(sugg);
                    }
                } else {
                    ruleMatch.addSuggestedReplacement(sugg);
                }
            }
            if (ruleMatch != null && this.isMisspelled(this.speller1, prevWord)) {
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
        }
        if (ruleMatch == null && idx < tokens.length - 1 && (nextWord = tokens[idx + 1].getToken()).length() > 0 && !nextWord.matches(".*\\d.*") && this.getFrequency(this.speller1, nextWord) < 21) {
            int nextStartPos = tokens[idx + 1].getStartPos();
            sugg1a = word.substring(0, word.length() - 1);
            sugg1b = word.substring(word.length() - 1) + nextWord;
            if (sugg1a.length() > 1 && sugg1b.length() > 2 && !this.isMisspelled(this.speller1, sugg1a) && !this.isMisspelled(this.speller1, sugg1b) && this.getFrequency(this.speller1, sugg1a) + this.getFrequency(this.speller1, sugg1b) > this.getFrequency(this.speller1, nextWord)) {
                ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, nextStartPos, nextWord, sugg1a, sugg1b, startPos);
                afterSuggestionStr = " " + nextWord;
            }
            sugg2a = word + nextWord.substring(0, 1);
            sugg2b = nextWord.substring(1);
            if (sugg2a.length() > 1 && sugg2b.length() > 2 && !this.isMisspelled(this.speller1, sugg2a) && !this.isMisspelled(this.speller1, sugg2b)) {
                if (ruleMatch == null) {
                    if (this.getFrequency(this.speller1, sugg2a) + this.getFrequency(this.speller1, sugg2b) > this.getFrequency(this.speller1, nextWord)) {
                        ruleMatch = this.createWrongSplitMatch(sentence, ruleMatchesSoFar, nextStartPos, nextWord, sugg2a, sugg2b, startPos);
                        afterSuggestionStr = " " + nextWord;
                    }
                } else {
                    ruleMatch.addSuggestedReplacement((sugg2a + " " + sugg2b).trim());
                }
            }
            sugg = word + nextWord;
            if (nextWord.equals(nextWord.toLowerCase()) && !this.isMisspelled(this.speller1, sugg)) {
                if (ruleMatch == null) {
                    if (this.getFrequency(this.speller1, sugg) >= this.getFrequency(this.speller1, nextWord)) {
                        ruleMatch = new RuleMatch(this, sentence, startPos, nextStartPos + nextWord.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
                        afterSuggestionStr = " " + nextWord;
                        ruleMatch.setSuggestedReplacement(sugg);
                    }
                } else {
                    ruleMatch.addSuggestedReplacement(sugg);
                }
            }
            if (ruleMatch != null && this.isMisspelled(this.speller1, nextWord)) {
                ruleMatches.add(ruleMatch);
                return ruleMatches;
            }
        }
        int translationSuggestionCount = 0;
        boolean preventFurtherSuggestions = false;
        Translator translator = this.getTranslator(this.globalConfig);
        if (translator != null && ruleMatch == null && this.motherTongue != null && this.language.getShortCode().equals("en") && this.motherTongue.getShortCode().equals("de")) {
            Object nextWord2;
            ArrayList<PhraseToTranslate> phrasesToTranslate = new ArrayList<PhraseToTranslate>();
            if (idx + 1 < tokens.length && this.isMisspelled((String)(nextWord2 = tokens[idx + 1].getToken()))) {
                phrasesToTranslate.add(new PhraseToTranslate(word + " " + (String)nextWord2, tokens[idx + 1].getEndPos()));
            }
            phrasesToTranslate.add(new PhraseToTranslate(word, startPos + word.length()));
            for (PhraseToTranslate phraseToTranslate : phrasesToTranslate) {
                List<TranslationEntry> translations = translator.translate(phraseToTranslate.phrase, this.motherTongue.getShortCode(), this.language.getShortCode());
                if (translations.size() <= 0) continue;
                logger.info("Translated: " + word);
                ruleMatch = new RuleMatch(this, sentence, startPos, phraseToTranslate.endPos, translator.getMessage());
                ruleMatch.setType(RuleMatch.Type.Hint);
                ruleMatch.setSuggestedReplacements(new ArrayList<String>());
                ArrayList<SuggestedReplacement> l = new ArrayList<SuggestedReplacement>();
                String prevWord2 = idx > 0 ? tokens[idx - 1].getToken() : null;
                for (TranslationEntry translation : translations) {
                    for (String s : translation.getL2()) {
                        String suffix = translator.getTranslationSuffix(s);
                        SuggestedReplacement repl = new SuggestedReplacement(translator.cleanTranslationForReplace(s, prevWord2), String.join((CharSequence)", ", translation.getL1()), suffix.isEmpty() ? null : suffix);
                        repl.setType(SuggestedReplacement.SuggestionType.Translation);
                        l.add(repl);
                    }
                }
                List<SuggestedReplacement> mergedRepl = this.mergeSuggestionsWithSameTranslation(l);
                if (mergedRepl.size() <= 0) continue;
                ruleMatch.setSuggestedReplacementObjects(mergedRepl);
                translationSuggestionCount = mergedRepl.size();
                if (!phraseToTranslate.phrase.contains(" ")) break;
                preventFurtherSuggestions = true;
                break;
            }
        }
        if (ruleMatch == null) {
            Language acceptingLanguage = this.acceptedInAlternativeLanguage(word);
            if (acceptingLanguage != null) {
                ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), Tools.i18n(this.messages, "accepted_in_alt_language", word, this.messages.getString(acceptingLanguage.getShortCode())));
                ruleMatch.setType(RuleMatch.Type.Hint);
            } else {
                ruleMatch = new RuleMatch(this, sentence, startPos, startPos + word.length(), this.messages.getString("spelling"), this.messages.getString("desc_spelling_short"));
            }
        }
        boolean bl = fullResults = SuggestionsChanges.getInstance() != null && SuggestionsChanges.getInstance().getCurrentExperiment() != null && (Boolean)SuggestionsChanges.getInstance().getCurrentExperiment().parameters.getOrDefault("fullSuggestionCandidates", Boolean.FALSE) != false;
        if (this.userConfig == null || this.userConfig.getMaxSpellingSuggestions() == 0 || ruleMatchesSoFar.size() <= this.userConfig.getMaxSpellingSuggestions()) {
            List<String> defaultSuggestions = this.speller1.getSuggestionsFromDefaultDicts(word);
            List<String> userSuggestions = this.speller1.getSuggestionsFromUserDicts(word);
            if (word.length() >= 3 && (fullResults || defaultSuggestions.isEmpty())) {
                defaultSuggestions.addAll(this.speller2.getSuggestionsFromDefaultDicts(word));
                userSuggestions.addAll(this.speller2.getSuggestionsFromUserDicts(word));
                if (word.length() >= 5 && (fullResults || defaultSuggestions.isEmpty())) {
                    defaultSuggestions.addAll(this.speller3.getSuggestionsFromDefaultDicts(word));
                    userSuggestions.addAll(this.speller3.getSuggestionsFromUserDicts(word));
                }
            }
            defaultSuggestions.addAll(0, this.getAdditionalTopSuggestions(defaultSuggestions, word));
            defaultSuggestions.addAll(this.getAdditionalSuggestions(defaultSuggestions, word));
            if (!(defaultSuggestions.isEmpty() && userSuggestions.isEmpty() || preventFurtherSuggestions)) {
                defaultSuggestions = this.filterSuggestions(defaultSuggestions, sentence, idx);
                this.filterDupes(userSuggestions);
                defaultSuggestions = this.orderSuggestions(defaultSuggestions, word);
                defaultSuggestions = this.joinBeforeAfterSuggestions(defaultSuggestions, beforeSuggestionStr, afterSuggestionStr);
                userSuggestions = this.joinBeforeAfterSuggestions(userSuggestions, beforeSuggestionStr, afterSuggestionStr);
                if (this.runningExperiment) {
                    MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, this.suggestionsOrderer, ruleMatch);
                } else if (this.userConfig != null && this.userConfig.getAbTest() != null && this.userConfig.getAbTest().equals("SuggestionsRanker") && this.suggestionsOrderer.isMlAvailable() && this.userConfig.getTextSessionId() != null) {
                    boolean testingA;
                    boolean bl2 = testingA = this.userConfig.getTextSessionId() % 2L == 0L;
                    if (testingA) {
                        MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, null, ruleMatch);
                    } else {
                        MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, this.suggestionsOrderer, ruleMatch);
                    }
                } else {
                    MorfologikSpellerRule.addSuggestionsToRuleMatch(word, userSuggestions, defaultSuggestions, null, ruleMatch);
                }
                if (translationSuggestionCount > 0 && ruleMatch.getSuggestedReplacements().size() > translationSuggestionCount) {
                    RuleMatch newRuleMatch = new RuleMatch(ruleMatch.getRule(), ruleMatch.getSentence(), ruleMatch.getFromPos(), ruleMatch.getToPos(), this.messages.getString("spelling") + " Translations to English are also offered.");
                    newRuleMatch.setSuggestedReplacementObjects(ruleMatch.getSuggestedReplacementObjects());
                    ruleMatch = newRuleMatch;
                }
            }
        } else {
            ruleMatch.setSuggestedReplacement(this.messages.getString("too_many_errors"));
        }
        ruleMatches.add(ruleMatch);
        return ruleMatches;
    }

    @NotNull
    private List<SuggestedReplacement> mergeSuggestionsWithSameTranslation(List<SuggestedReplacement> l) {
        ArrayList<SuggestedReplacement> mergedRepl = new ArrayList<SuggestedReplacement>();
        HashSet<String> handledReplacements = new HashSet<String>();
        for (SuggestedReplacement repl : l) {
            List sameRepl = l.stream().filter(k -> k.getReplacement().equals(repl.getReplacement())).filter(k -> k.getSuffix() == null || k.getSuffix() != null && k.getSuffix().equals(repl.getSuffix())).collect(Collectors.toList());
            if (sameRepl.size() > 1) {
                if (handledReplacements.contains(repl.getReplacement())) continue;
                ArrayList<String> joinedRepls = new ArrayList<String>();
                for (SuggestedReplacement r : sameRepl) {
                    joinedRepls.add("* " + r.getShortDescription());
                }
                mergedRepl.add(new SuggestedReplacement(repl.getReplacement(), String.join((CharSequence)"\n", joinedRepls), repl.getSuffix()));
                handledReplacements.add(repl.getReplacement());
                continue;
            }
            mergedRepl.add(repl);
        }
        return mergedRepl;
    }

    @Nullable
    public Pattern tokenizingPattern() {
        return null;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        return suggestions;
    }

    private List<String> orderSuggestions(List<String> suggestions, String word, AnalyzedSentence sentence, int startPos) {
        List<String> orderedSuggestions;
        if (this.userConfig != null && this.userConfig.getAbTest() != null && this.userConfig.getAbTest().equals("SuggestionsOrderer") && this.suggestionsOrderer.isMlAvailable() && this.userConfig.getTextSessionId() != null) {
            boolean logGroup;
            boolean bl = logGroup = Math.random() < 0.01;
            if (logGroup) {
                System.out.print("Running A/B-Test for SuggestionsOrderer ->");
            }
            if (this.userConfig.getTextSessionId() % 2L == 0L) {
                if (logGroup) {
                    System.out.println("in group A (using new ordering)");
                }
                orderedSuggestions = this.suggestionsOrderer.orderSuggestionsUsingModel(suggestions, word, sentence, startPos);
            } else {
                if (logGroup) {
                    System.out.println("in group B (using old ordering)");
                }
                orderedSuggestions = this.orderSuggestions(suggestions, word);
            }
        } else {
            orderedSuggestions = this.suggestionsOrderer.isMlAvailable() ? this.suggestionsOrderer.orderSuggestionsUsingModel(suggestions, word, sentence, startPos) : this.orderSuggestions(suggestions, word);
        }
        return orderedSuggestions;
    }

    protected void setCheckCompound(boolean checkCompound) {
        this.checkCompound = checkCompound;
    }

    protected void setCompoundRegex(String compoundRegex) {
        this.compoundRegex = Pattern.compile(compoundRegex);
    }

    protected boolean isSurrogatePairCombination(String word) {
        if (word.length() > 1 && word.length() % 2 == 0 && word.codePointCount(0, word.length()) != word.length()) {
            boolean isSurrogatePairCombination = true;
            for (int i = 0; i < word.length() && isSurrogatePairCombination; isSurrogatePairCombination &= Character.isSurrogatePair(word.charAt(i), word.charAt(i + 1)), i += 2) {
            }
            return isSurrogatePairCombination;
        }
        return false;
    }

    @Override
    protected boolean ignoreWord(String word) throws IOException {
        return super.ignoreWord(word) || this.isSurrogatePairCombination(word);
    }

    private List<String> joinBeforeAfterSuggestions(List<String> suggestionsList, String beforeSuggestionStr, String afterSuggestionStr) {
        ArrayList<String> newSuggestionsList = new ArrayList<String>();
        for (String str : suggestionsList) {
            newSuggestionsList.add(beforeSuggestionStr + str + afterSuggestionStr);
        }
        return newSuggestionsList;
    }

    static class PhraseToTranslate {
        String phrase;
        int endPos;

        PhraseToTranslate(String phrase, int endPos) {
            this.phrase = phrase;
            this.endPos = endPos;
        }
    }
}

