/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.LinguServices;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;

public class Configuration {
    static final int DEFAULT_SERVER_PORT = 8081;
    static final int DEFAULT_NUM_CHECK_PARAS = 5;
    static final int FONT_STYLE_INVALID = -1;
    static final int FONT_SIZE_INVALID = -1;
    static final Color STYLE_COLOR = new Color(0, 175, 0);
    private static final String CONFIG_FILE = ".languagetool.cfg";
    private static final String CURRENT_PROFILE_KEY = "currentProfile";
    private static final String DEFINED_PROFILES_KEY = "definedProfiles";
    private static final String DISABLED_RULES_KEY = "disabledRules";
    private static final String ENABLED_RULES_KEY = "enabledRules";
    private static final String DISABLED_CATEGORIES_KEY = "disabledCategories";
    private static final String ENABLED_CATEGORIES_KEY = "enabledCategories";
    private static final String ENABLED_RULES_ONLY_KEY = "enabledRulesOnly";
    private static final String LANGUAGE_KEY = "language";
    private static final String MOTHER_TONGUE_KEY = "motherTongue";
    private static final String NGRAM_DIR_KEY = "ngramDir";
    private static final String WORD2VEC_DIR_KEY = "word2vecDir";
    private static final String AUTO_DETECT_KEY = "autoDetect";
    private static final String TAGGER_SHOWS_DISAMBIG_LOG_KEY = "taggerShowsDisambigLog";
    private static final String SERVER_RUN_KEY = "serverMode";
    private static final String SERVER_PORT_KEY = "serverPort";
    private static final String PARA_CHECK_KEY = "numberParagraphs";
    private static final String RESET_CHECK_KEY = "doResetCheck";
    private static final String NO_MULTI_RESET_KEY = "noMultiReset";
    private static final String DO_FULL_CHECK_AT_FIRST_KEY = "doFullCheckAtFirst";
    private static final String USE_DOC_LANG_KEY = "useDocumentLanguage";
    private static final String USE_GUI_KEY = "useGUIConfig";
    private static final String FONT_NAME_KEY = "font.name";
    private static final String FONT_STYLE_KEY = "font.style";
    private static final String FONT_SIZE_KEY = "font.size";
    private static final String LF_NAME_KEY = "lookAndFeelName";
    private static final String ERROR_COLORS_KEY = "errorColors";
    private static final String UNDERLINE_COLORS_KEY = "underlineColors";
    private static final String CONFIGURABLE_RULE_VALUES_KEY = "configurableRuleValues";
    private static final String LT_SWITCHED_OFF_KEY = "ltSwitchedOff";
    private static final String IS_MULTI_THREAD_LO_KEY = "isMultiThread";
    private static final String EXTERNAL_RULE_DIRECTORY = "extRulesDirectory";
    private static final String DO_REMOTE_CHECK_KEY = "doRemoteCheck";
    private static final String OTHER_SERVER_URL_KEY = "otherServerUrl";
    private static final String USE_OTHER_SERVER_KEY = "useOtherServer";
    private static final String USE_SERVER_CONFIGURATION_KEY = "useServerConfiguration";
    private static final String DELIMITER = ",";
    private static final String COLOR_SPLITTER_REGEXP = "(?<=:#[0-9A-Fa-f]{6}),\\s*";
    private static final String COLOR_SPLITTER_REGEXP_COLON = ":(?=#[0-9A-Fa-f]{6})";
    private static final String CONFIGURABLE_RULE_SPLITTER_REGEXP = "(?<=[0-9]),\\s*";
    private static final String BLANK = "[ \t]";
    private static final String BLANK_REPLACE = "_";
    private static final String PROFILE_DELIMITER = "__";
    private final Map<String, String> configForOtherProfiles = new HashMap<String, String>();
    private final Map<String, String> configForOtherLanguages = new HashMap<String, String>();
    private final Map<ITSIssueType, Color> errorColors = new EnumMap<ITSIssueType, Color>(ITSIssueType.class);
    private final Map<String, Color> underlineColors = new HashMap<String, Color>();
    private final Map<String, Integer> configurableRuleValues = new HashMap<String, Integer>();
    private final Set<String> styleLikeCategories = new HashSet<String>();
    private final Map<String, String> specialTabCategories = new HashMap<String, String>();
    private Set<String> disabledRuleIds = new HashSet<String>();
    private Set<String> enabledRuleIds = new HashSet<String>();
    private Set<String> disabledCategoryNames = new HashSet<String>();
    private Set<String> enabledCategoryNames = new HashSet<String>();
    private List<String> definedProfiles = new ArrayList<String>();
    private List<String> allProfileKeys = new ArrayList<String>();
    private List<String> allProfileLangKeys = new ArrayList<String>();
    private Language lang;
    private File configFile;
    private File oldConfigFile;
    private boolean enabledRulesOnly = false;
    private Language language;
    private Language motherTongue;
    private File ngramDirectory;
    private File word2vecDirectory;
    private boolean runServer;
    private boolean autoDetect;
    private boolean taggerShowsDisambigLog;
    private boolean guiConfig;
    private String fontName;
    private int fontStyle = -1;
    private int fontSize = -1;
    private int serverPort = 8081;
    private int numParasToCheck = 5;
    private boolean doResetCheck = false;
    private boolean noMultiReset = true;
    private boolean doFullCheckAtFirst = true;
    private String externalRuleDirectory;
    private String lookAndFeelName;
    private boolean switchOff = false;
    private boolean useDocLanguage = true;
    private boolean isMultiThreadLO = false;
    private String currentProfile = null;
    private boolean doRemoteCheck = false;
    private boolean useServerConfiguration = false;
    private boolean useOtherServer = false;
    private String otherServerUrl = null;

    public Configuration(Language lang) throws IOException {
        this(new File(System.getProperty("user.home")), CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, Language lang) throws IOException {
        this(baseDir, CONFIG_FILE, lang);
    }

    public Configuration(File baseDir, String filename, Language lang) throws IOException {
        this(baseDir, filename, lang, null);
    }

    public Configuration(File baseDir, String filename, Language lang, LinguServices linguServices) throws IOException {
        this(baseDir, filename, null, lang, linguServices);
    }

    public Configuration(File baseDir, String filename, File oldConfigFile, Language lang, LinguServices linguServices) throws IOException {
        if (baseDir == null || !baseDir.isDirectory()) {
            throw new IllegalArgumentException("Cannot open file " + filename + " in directory " + baseDir);
        }
        this.initOptions();
        this.lang = lang;
        this.configFile = new File(baseDir, filename);
        this.oldConfigFile = oldConfigFile;
        this.setAllProfileKeys();
        this.loadConfiguration();
    }

    private Configuration() {
        this.lang = null;
    }

    public void initOptions() {
        this.configForOtherLanguages.clear();
        this.underlineColors.clear();
        this.configurableRuleValues.clear();
        this.disabledRuleIds.clear();
        this.enabledRuleIds.clear();
        this.disabledCategoryNames.clear();
        this.enabledCategoryNames.clear();
        this.definedProfiles.clear();
        this.enabledRulesOnly = false;
        this.ngramDirectory = null;
        this.word2vecDirectory = null;
        this.runServer = false;
        this.autoDetect = false;
        this.taggerShowsDisambigLog = false;
        this.guiConfig = false;
        this.fontName = null;
        this.fontStyle = -1;
        this.fontSize = -1;
        this.serverPort = 8081;
        this.numParasToCheck = 5;
        this.doResetCheck = false;
        this.noMultiReset = true;
        this.doFullCheckAtFirst = true;
        this.externalRuleDirectory = null;
        this.lookAndFeelName = null;
        this.switchOff = false;
        this.useDocLanguage = true;
        this.isMultiThreadLO = false;
        this.currentProfile = null;
        this.doRemoteCheck = false;
        this.useServerConfiguration = false;
        this.useOtherServer = false;
        this.otherServerUrl = null;
    }

    Configuration copy(Configuration configuration) {
        Configuration copy = new Configuration();
        copy.restoreState(configuration);
        return copy;
    }

    void restoreState(Configuration configuration) {
        this.configFile = configuration.configFile;
        this.language = configuration.language;
        this.lang = configuration.lang;
        this.motherTongue = configuration.motherTongue;
        this.ngramDirectory = configuration.ngramDirectory;
        this.word2vecDirectory = configuration.word2vecDirectory;
        this.runServer = configuration.runServer;
        this.autoDetect = configuration.autoDetect;
        this.taggerShowsDisambigLog = configuration.taggerShowsDisambigLog;
        this.guiConfig = configuration.guiConfig;
        this.fontName = configuration.fontName;
        this.fontStyle = configuration.fontStyle;
        this.fontSize = configuration.fontSize;
        this.serverPort = configuration.serverPort;
        this.numParasToCheck = configuration.numParasToCheck;
        this.doResetCheck = configuration.doResetCheck;
        this.noMultiReset = configuration.noMultiReset;
        this.doFullCheckAtFirst = configuration.doFullCheckAtFirst;
        this.isMultiThreadLO = configuration.isMultiThreadLO;
        this.useDocLanguage = configuration.useDocLanguage;
        this.lookAndFeelName = configuration.lookAndFeelName;
        this.externalRuleDirectory = configuration.externalRuleDirectory;
        this.currentProfile = configuration.currentProfile;
        this.doRemoteCheck = configuration.doRemoteCheck;
        this.useServerConfiguration = configuration.useServerConfiguration;
        this.useOtherServer = configuration.useOtherServer;
        this.otherServerUrl = configuration.otherServerUrl;
        this.disabledRuleIds.clear();
        this.disabledRuleIds.addAll(configuration.disabledRuleIds);
        this.enabledRuleIds.clear();
        this.enabledRuleIds.addAll(configuration.enabledRuleIds);
        this.disabledCategoryNames.clear();
        this.disabledCategoryNames.addAll(configuration.disabledCategoryNames);
        this.enabledCategoryNames.clear();
        this.enabledCategoryNames.addAll(configuration.enabledCategoryNames);
        this.configForOtherLanguages.clear();
        for (String string : configuration.configForOtherLanguages.keySet()) {
            this.configForOtherLanguages.put(string, configuration.configForOtherLanguages.get(string));
        }
        this.underlineColors.clear();
        for (Map.Entry entry : configuration.underlineColors.entrySet()) {
            this.underlineColors.put((String)entry.getKey(), (Color)entry.getValue());
        }
        this.configurableRuleValues.clear();
        for (Map.Entry entry : configuration.configurableRuleValues.entrySet()) {
            this.configurableRuleValues.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        this.styleLikeCategories.clear();
        this.styleLikeCategories.addAll(configuration.styleLikeCategories);
        this.specialTabCategories.clear();
        for (Map.Entry entry : configuration.specialTabCategories.entrySet()) {
            this.specialTabCategories.put((String)entry.getKey(), (String)entry.getValue());
        }
        this.definedProfiles.clear();
        this.definedProfiles.addAll(configuration.definedProfiles);
        this.allProfileLangKeys.clear();
        this.allProfileLangKeys.addAll(configuration.allProfileLangKeys);
        this.allProfileKeys.clear();
        this.allProfileKeys.addAll(configuration.allProfileKeys);
        this.configForOtherProfiles.clear();
        for (Map.Entry entry : configuration.configForOtherProfiles.entrySet()) {
            this.configForOtherProfiles.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    public Set<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    public Set<String> getEnabledRuleIds() {
        return this.enabledRuleIds;
    }

    public Set<String> getDisabledCategoryNames() {
        return this.disabledCategoryNames;
    }

    public Set<String> getEnabledCategoryNames() {
        return this.enabledCategoryNames;
    }

    public void setDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds = ruleIds;
        this.enabledRuleIds.removeAll(ruleIds);
    }

    public void addDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds.addAll(ruleIds);
        this.enabledRuleIds.removeAll(ruleIds);
    }

    public void removeDisabledRuleIds(Set<String> ruleIds) {
        this.disabledRuleIds.removeAll(ruleIds);
        this.enabledRuleIds.addAll(ruleIds);
    }

    public void setEnabledRuleIds(Set<String> ruleIds) {
        this.enabledRuleIds = ruleIds;
    }

    public void setDisabledCategoryNames(Set<String> categoryNames) {
        this.disabledCategoryNames = categoryNames;
    }

    public void setEnabledCategoryNames(Set<String> categoryNames) {
        this.enabledCategoryNames = categoryNames;
    }

    public boolean getEnabledRulesOnly() {
        return this.enabledRulesOnly;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public Language getMotherTongue() {
        return this.motherTongue;
    }

    public void setMotherTongue(Language motherTongue) {
        this.motherTongue = motherTongue;
    }

    public Language getDefaultLanguage() {
        if (this.useDocLanguage) {
            return null;
        }
        return this.motherTongue;
    }

    public void setUseDocLanguage(boolean useDocLang) {
        this.useDocLanguage = useDocLang;
    }

    public boolean getUseDocLanguage() {
        return this.useDocLanguage;
    }

    public boolean getAutoDetect() {
        return this.autoDetect;
    }

    public void setAutoDetect(boolean autoDetect) {
        this.autoDetect = autoDetect;
    }

    public void setRemoteCheck(boolean doRemoteCheck) {
        this.doRemoteCheck = doRemoteCheck;
    }

    public boolean doRemoteCheck() {
        return this.doRemoteCheck;
    }

    public void setUseServerConfiguration(boolean useServerConfiguration) {
        this.useServerConfiguration = useServerConfiguration;
    }

    public boolean useServerConfiguration() {
        return this.useServerConfiguration;
    }

    public void setUseOtherServer(boolean useOtherServer) {
        this.useOtherServer = useOtherServer;
    }

    public boolean useOtherServer() {
        return this.useOtherServer;
    }

    public void setOtherServerUrl(String otherServerUrl) {
        this.otherServerUrl = otherServerUrl;
    }

    public String getServerUrl() {
        return this.useOtherServer ? this.otherServerUrl : null;
    }

    public boolean getTaggerShowsDisambigLog() {
        return this.taggerShowsDisambigLog;
    }

    public void setTaggerShowsDisambigLog(boolean taggerShowsDisambigLog) {
        this.taggerShowsDisambigLog = taggerShowsDisambigLog;
    }

    public boolean getRunServer() {
        return this.runServer;
    }

    public void setRunServer(boolean runServer) {
        this.runServer = runServer;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setUseGUIConfig(boolean useGUIConfig) {
        this.guiConfig = useGUIConfig;
    }

    public boolean getUseGUIConfig() {
        return this.guiConfig;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getExternalRuleDirectory() {
        return this.externalRuleDirectory;
    }

    public void setExternalRuleDirectory(String path) {
        this.externalRuleDirectory = path;
    }

    public int getNumParasToCheck() {
        return this.numParasToCheck;
    }

    public void setNumParasToCheck(int numParas) {
        this.numParasToCheck = numParas;
    }

    public boolean isResetCheck() {
        return this.doResetCheck;
    }

    public void setDoResetCheck(boolean resetCheck) {
        this.doResetCheck = resetCheck;
    }

    public boolean isNoMultiReset() {
        return this.noMultiReset;
    }

    public void setNoMultiReset(boolean noMultiReset) {
        this.noMultiReset = noMultiReset;
    }

    public void setFullCheckAtFirst(boolean doFullCheckAtFirst) {
        this.doFullCheckAtFirst = doFullCheckAtFirst;
    }

    public boolean doFullCheckAtFirst() {
        return this.doFullCheckAtFirst;
    }

    public String getCurrentProfile() {
        return this.currentProfile;
    }

    public void setCurrentProfile(String profile) {
        this.currentProfile = profile;
    }

    public List<String> getDefinedProfiles() {
        return this.definedProfiles;
    }

    public void addProfile(String profile) {
        this.definedProfiles.add(profile);
    }

    public void addProfiles(List<String> profiles) {
        this.definedProfiles.clear();
        this.definedProfiles.addAll(profiles);
    }

    public void removeProfile(String profile) {
        this.definedProfiles.remove(profile);
    }

    public void setMultiThreadLO(boolean isMultiThread) {
        this.isMultiThreadLO = isMultiThread;
    }

    public boolean isMultiThread() {
        return this.isMultiThreadLO;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }

    public void setLookAndFeelName(String lookAndFeelName) {
        this.lookAndFeelName = lookAndFeelName;
    }

    @Nullable
    public File getNgramDirectory() {
        return this.ngramDirectory;
    }

    public void setNgramDirectory(File dir) {
        this.ngramDirectory = dir;
    }

    @Nullable
    public File getWord2VecDirectory() {
        return this.word2vecDirectory;
    }

    public void setWord2VecDirectory(File dir) {
        this.word2vecDirectory = dir;
    }

    public Map<ITSIssueType, Color> getErrorColors() {
        return this.errorColors;
    }

    public boolean isStyleCategory(String category) {
        return this.styleLikeCategories.contains(category);
    }

    public void initStyleCategories(List<Rule> allRules) {
        for (Rule rule : allRules) {
            if (rule.getCategory().getTabName() != null && !this.specialTabCategories.containsKey(rule.getCategory().getName())) {
                this.specialTabCategories.put(rule.getCategory().getName(), rule.getCategory().getTabName());
            }
            if (!rule.getLocQualityIssueType().toString().equalsIgnoreCase("STYLE") && !rule.getLocQualityIssueType().toString().equalsIgnoreCase("REGISTER") && !rule.getCategory().getId().toString().equals("STYLE") && !rule.getCategory().getId().toString().equals("TYPOGRAPHY") || this.styleLikeCategories.contains(rule.getCategory().getName())) continue;
            this.styleLikeCategories.add(rule.getCategory().getName());
        }
    }

    public boolean isSpecialTabCategory(String category) {
        return this.specialTabCategories.containsKey(category);
    }

    public boolean isInSpecialTab(String category, String tabName) {
        if (this.specialTabCategories.containsKey(category)) {
            return this.specialTabCategories.get(category).equals(tabName);
        }
        return false;
    }

    public String[] getSpecialTabNames() {
        HashSet<String> tabNames = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.specialTabCategories.entrySet()) {
            if (tabNames.contains(entry.getValue())) continue;
            tabNames.add(entry.getValue());
        }
        return tabNames.toArray(new String[tabNames.size()]);
    }

    public Set<String> getSpecialTabCategories(String tabName) {
        HashSet<String> tabCategories = new HashSet<String>();
        for (Map.Entry<String, String> entry : this.specialTabCategories.entrySet()) {
            if (!entry.getKey().equals(tabName)) continue;
            tabCategories.add(entry.getKey());
        }
        return tabCategories;
    }

    public Map<String, Color> getUnderlineColors() {
        return this.underlineColors;
    }

    public Color getUnderlineColor(String category) {
        if (this.underlineColors.containsKey(category)) {
            return this.underlineColors.get(category);
        }
        if (this.styleLikeCategories.contains(category)) {
            return STYLE_COLOR;
        }
        return Color.blue;
    }

    public void setUnderlineColor(String category, Color col) {
        this.underlineColors.put(category, col);
    }

    public void setDefaultUnderlineColor(String category) {
        this.underlineColors.remove(category);
    }

    public Map<String, Integer> getConfigurableValues() {
        return this.configurableRuleValues;
    }

    public int getConfigurableValue(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return -1;
    }

    public void setConfigurableValue(String ruleID, int value) {
        this.configurableRuleValues.put(ruleID, value);
    }

    public boolean isSwitchedOff() {
        return this.switchOff;
    }

    public void setSwitchedOff(boolean switchOff, Language lang) throws IOException {
        this.switchOff = switchOff;
        this.saveConfiguration(lang);
    }

    private void loadConfiguration() throws IOException {
        this.loadConfiguration(null);
    }

    public void loadConfiguration(String profile) throws IOException {
        String qualifier = this.getQualifier(this.lang);
        File cfgFile = this.configFile.exists() || this.oldConfigFile == null ? this.configFile : this.oldConfigFile;
        try (FileInputStream fis = new FileInputStream(cfgFile);){
            String useOtherServerString;
            String useServerConfigurationString;
            String doRemoteCheckString;
            String isMultiThreadString;
            String switchOffString;
            String useDocLangString;
            String doFullCheckAtFirstString;
            String noMultiResetString;
            String resetCheckString;
            String paraCheckString;
            String extRules;
            String word2vecDir;
            String ngramDir;
            String motherTongueStr;
            Properties props = new Properties();
            props.load(fis);
            if (profile == null) {
                String curProfileStr = (String)props.get(CURRENT_PROFILE_KEY);
                if (curProfileStr != null) {
                    this.currentProfile = curProfileStr;
                }
            } else {
                this.currentProfile = profile;
            }
            this.definedProfiles.addAll(this.getListFromProperties(props, DEFINED_PROFILES_KEY));
            this.storeConfigforAllProfiles(props);
            String prefix = this.currentProfile == null ? new String("") : new String(this.currentProfile);
            if (!prefix.isEmpty()) {
                prefix = prefix.replaceAll(BLANK, BLANK_REPLACE);
                prefix = prefix + PROFILE_DELIMITER;
            }
            this.disabledRuleIds.addAll(this.getListFromProperties(props, prefix + DISABLED_RULES_KEY + qualifier));
            this.enabledRuleIds.addAll(this.getListFromProperties(props, prefix + ENABLED_RULES_KEY + qualifier));
            this.disabledCategoryNames.addAll(this.getListFromProperties(props, prefix + DISABLED_CATEGORIES_KEY + qualifier));
            this.enabledCategoryNames.addAll(this.getListFromProperties(props, prefix + ENABLED_CATEGORIES_KEY + qualifier));
            this.enabledRulesOnly = "true".equals(props.get(prefix + ENABLED_RULES_ONLY_KEY));
            String languageStr = (String)props.get(prefix + LANGUAGE_KEY);
            if (languageStr != null) {
                this.language = Languages.getLanguageForShortCode((String)languageStr);
            }
            if ((motherTongueStr = (String)props.get(prefix + MOTHER_TONGUE_KEY)) != null && !motherTongueStr.equals("xx")) {
                this.motherTongue = Languages.getLanguageForShortCode((String)motherTongueStr);
            }
            if ((ngramDir = (String)props.get(prefix + NGRAM_DIR_KEY)) != null) {
                this.ngramDirectory = new File(ngramDir);
            }
            if ((word2vecDir = (String)props.get(prefix + WORD2VEC_DIR_KEY)) != null) {
                this.word2vecDirectory = new File(word2vecDir);
            }
            this.autoDetect = "true".equals(props.get(prefix + AUTO_DETECT_KEY));
            this.taggerShowsDisambigLog = "true".equals(props.get(prefix + TAGGER_SHOWS_DISAMBIG_LOG_KEY));
            this.guiConfig = "true".equals(props.get(prefix + USE_GUI_KEY));
            this.runServer = "true".equals(props.get(prefix + SERVER_RUN_KEY));
            this.fontName = (String)props.get(prefix + FONT_NAME_KEY);
            if (props.get(prefix + FONT_STYLE_KEY) != null) {
                try {
                    this.fontStyle = Integer.parseInt((String)props.get(prefix + FONT_STYLE_KEY));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (props.get(prefix + FONT_SIZE_KEY) != null) {
                try {
                    this.fontSize = Integer.parseInt((String)props.get(prefix + FONT_SIZE_KEY));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.lookAndFeelName = (String)props.get(prefix + LF_NAME_KEY);
            String serverPortString = (String)props.get(prefix + SERVER_PORT_KEY);
            if (serverPortString != null) {
                this.serverPort = Integer.parseInt(serverPortString);
            }
            if ((extRules = (String)props.get(prefix + EXTERNAL_RULE_DIRECTORY)) != null) {
                this.externalRuleDirectory = extRules;
            }
            if ((paraCheckString = (String)props.get(prefix + PARA_CHECK_KEY)) != null) {
                this.numParasToCheck = Integer.parseInt(paraCheckString);
            }
            if ((resetCheckString = (String)props.get(prefix + RESET_CHECK_KEY)) != null) {
                this.doResetCheck = Boolean.parseBoolean(resetCheckString);
            }
            if ((noMultiResetString = (String)props.get(prefix + NO_MULTI_RESET_KEY)) != null) {
                this.noMultiReset = Boolean.parseBoolean(noMultiResetString);
            }
            if ((doFullCheckAtFirstString = (String)props.get(prefix + DO_FULL_CHECK_AT_FIRST_KEY)) != null) {
                this.doFullCheckAtFirst = Boolean.parseBoolean(doFullCheckAtFirstString);
            }
            if ((useDocLangString = (String)props.get(prefix + USE_DOC_LANG_KEY)) != null) {
                this.useDocLanguage = Boolean.parseBoolean(useDocLangString);
            }
            if ((switchOffString = (String)props.get(prefix + LT_SWITCHED_OFF_KEY)) != null) {
                this.switchOff = Boolean.parseBoolean(switchOffString);
            }
            if ((isMultiThreadString = (String)props.get(prefix + IS_MULTI_THREAD_LO_KEY)) != null) {
                this.isMultiThreadLO = Boolean.parseBoolean(isMultiThreadString);
            }
            if ((doRemoteCheckString = (String)props.get(prefix + DO_REMOTE_CHECK_KEY)) != null) {
                this.doRemoteCheck = Boolean.parseBoolean(doRemoteCheckString);
            }
            if ((useServerConfigurationString = (String)props.get(prefix + USE_SERVER_CONFIGURATION_KEY)) != null) {
                this.useServerConfiguration = Boolean.parseBoolean(useServerConfigurationString);
            }
            if ((useOtherServerString = (String)props.get(prefix + USE_OTHER_SERVER_KEY)) != null) {
                this.useOtherServer = Boolean.parseBoolean(useOtherServerString);
            }
            this.otherServerUrl = (String)props.get(prefix + OTHER_SERVER_URL_KEY);
            String rulesValuesString = (String)props.get(prefix + CONFIGURABLE_RULE_VALUES_KEY + qualifier);
            if (rulesValuesString == null) {
                rulesValuesString = (String)props.get(prefix + CONFIGURABLE_RULE_VALUES_KEY);
            }
            this.parseConfigurableRuleValues(rulesValuesString);
            String colorsString = (String)props.get(prefix + ERROR_COLORS_KEY);
            this.parseErrorColors(colorsString);
            String underlineColorsString = (String)props.get(prefix + UNDERLINE_COLORS_KEY);
            this.parseUnderlineColors(underlineColorsString);
            this.loadConfigForOtherLanguages(this.lang, props, prefix);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void parseErrorColors(String colorsString) {
        if (StringUtils.isNotEmpty((CharSequence)colorsString)) {
            String[] typeToColorList;
            for (String typeToColor : typeToColorList = colorsString.split(COLOR_SPLITTER_REGEXP)) {
                String[] typeAndColor = typeToColor.split(COLOR_SPLITTER_REGEXP_COLON);
                if (typeAndColor.length != 2) {
                    throw new RuntimeException("Could not parse type and color, colon expected: '" + typeToColor + "'");
                }
                ITSIssueType type = ITSIssueType.getIssueType((String)typeAndColor[0]);
                String hexColor = typeAndColor[1];
                this.errorColors.put(type, Color.decode(hexColor));
            }
        }
    }

    private void parseUnderlineColors(String colorsString) {
        if (StringUtils.isNotEmpty((CharSequence)colorsString)) {
            String[] typeToColorList;
            for (String typeToColor : typeToColorList = colorsString.split(COLOR_SPLITTER_REGEXP)) {
                String[] typeAndColor = typeToColor.split(COLOR_SPLITTER_REGEXP_COLON);
                if (typeAndColor.length != 2) {
                    throw new RuntimeException("Could not parse type and color, colon expected: '" + typeToColor + "'");
                }
                this.underlineColors.put(typeAndColor[0], Color.decode(typeAndColor[1]));
            }
        }
    }

    private void parseConfigurableRuleValues(String rulesValueString) {
        if (StringUtils.isNotEmpty((CharSequence)rulesValueString)) {
            String[] ruleToValueList;
            for (String ruleToValue : ruleToValueList = rulesValueString.split(CONFIGURABLE_RULE_SPLITTER_REGEXP)) {
                String[] ruleAndValue = ruleToValue.split(":");
                if (ruleAndValue.length != 2) {
                    throw new RuntimeException("Could not parse rule and value, colon expected: '" + ruleToValue + "'");
                }
                this.configurableRuleValues.put(ruleAndValue[0], Integer.parseInt(ruleAndValue[1]));
            }
        }
    }

    private String getQualifier(Language lang) {
        String qualifier = "";
        if (lang != null) {
            qualifier = "." + lang.getShortCodeWithCountryAndVariant();
        }
        return qualifier;
    }

    private void loadConfigForOtherLanguages(Language lang, Properties prop, String prefix) {
        for (Language otherLang : Languages.get()) {
            if (otherLang.equals((Object)lang)) continue;
            String languageSuffix = "." + otherLang.getShortCodeWithCountryAndVariant();
            this.storeConfigKeyFromProp(prop, prefix + DISABLED_RULES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + ENABLED_RULES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + DISABLED_CATEGORIES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + ENABLED_CATEGORIES_KEY + languageSuffix);
            this.storeConfigKeyFromProp(prop, prefix + CONFIGURABLE_RULE_VALUES_KEY + languageSuffix);
        }
    }

    private void storeConfigKeyFromProp(Properties prop, String key) {
        if (prop.containsKey(key)) {
            this.configForOtherLanguages.put(key, prop.getProperty(key));
        }
    }

    private Collection<? extends String> getListFromProperties(Properties props, String key) {
        String value = (String)props.get(key);
        ArrayList<String> list = new ArrayList<String>();
        if (value != null && !value.isEmpty()) {
            String[] names = value.split(DELIMITER);
            list.addAll(Arrays.asList(names));
        }
        return list;
    }

    public void saveConfiguration(Language lang) throws IOException {
        Properties props = new Properties();
        String qualifier = this.getQualifier(lang);
        if (this.currentProfile != null && !this.currentProfile.isEmpty()) {
            props.setProperty(CURRENT_PROFILE_KEY, this.currentProfile);
        }
        if (!this.definedProfiles.isEmpty()) {
            props.setProperty(DEFINED_PROFILES_KEY, String.join((CharSequence)DELIMITER, this.definedProfiles));
        }
        FileOutputStream fos = new FileOutputStream(this.configFile);
        Object object = null;
        try {
            props.store(fos, "LanguageTool configuration (4.7/" + JLanguageTool.BUILD_DATE + ")");
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (fos != null) {
                if (object != null) {
                    try {
                        fos.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    fos.close();
                }
            }
        }
        ArrayList<String> prefixes = new ArrayList<String>();
        prefixes.add("");
        for (String profile : this.definedProfiles) {
            String prefix = new String(profile);
            prefixes.add(prefix.replaceAll(BLANK, BLANK_REPLACE) + PROFILE_DELIMITER);
        }
        String currentPrefix = this.currentProfile == null ? new String("") : new String(this.currentProfile);
        if (!currentPrefix.isEmpty()) {
            currentPrefix = currentPrefix.replaceAll(BLANK, BLANK_REPLACE);
            currentPrefix = currentPrefix + PROFILE_DELIMITER;
        }
        for (String prefix : prefixes) {
            props = new Properties();
            if (currentPrefix.equals(prefix)) {
                this.addListToProperties(props, prefix + DISABLED_RULES_KEY + qualifier, this.disabledRuleIds);
                this.addListToProperties(props, prefix + ENABLED_RULES_KEY + qualifier, this.enabledRuleIds);
                this.addListToProperties(props, prefix + DISABLED_CATEGORIES_KEY + qualifier, this.disabledCategoryNames);
                this.addListToProperties(props, prefix + ENABLED_CATEGORIES_KEY + qualifier, this.enabledCategoryNames);
                if (this.language != null && !this.language.isExternal()) {
                    props.setProperty(prefix + LANGUAGE_KEY, this.language.getShortCodeWithCountryAndVariant());
                }
                if (this.motherTongue != null) {
                    props.setProperty(prefix + MOTHER_TONGUE_KEY, this.motherTongue.getShortCode());
                }
                if (this.ngramDirectory != null) {
                    props.setProperty(prefix + NGRAM_DIR_KEY, this.ngramDirectory.getAbsolutePath());
                }
                if (this.word2vecDirectory != null) {
                    props.setProperty(prefix + WORD2VEC_DIR_KEY, this.word2vecDirectory.getAbsolutePath());
                }
                props.setProperty(prefix + AUTO_DETECT_KEY, Boolean.toString(this.autoDetect));
                props.setProperty(prefix + TAGGER_SHOWS_DISAMBIG_LOG_KEY, Boolean.toString(this.taggerShowsDisambigLog));
                props.setProperty(prefix + USE_GUI_KEY, Boolean.toString(this.guiConfig));
                props.setProperty(prefix + SERVER_RUN_KEY, Boolean.toString(this.runServer));
                props.setProperty(prefix + SERVER_PORT_KEY, Integer.toString(this.serverPort));
                props.setProperty(prefix + PARA_CHECK_KEY, Integer.toString(this.numParasToCheck));
                props.setProperty(prefix + RESET_CHECK_KEY, Boolean.toString(this.doResetCheck));
                props.setProperty(prefix + NO_MULTI_RESET_KEY, Boolean.toString(this.noMultiReset));
                if (!this.doFullCheckAtFirst) {
                    props.setProperty(prefix + DO_FULL_CHECK_AT_FIRST_KEY, Boolean.toString(this.doFullCheckAtFirst));
                }
                if (!this.useDocLanguage) {
                    props.setProperty(prefix + USE_DOC_LANG_KEY, Boolean.toString(this.useDocLanguage));
                }
                if (this.switchOff) {
                    props.setProperty(prefix + LT_SWITCHED_OFF_KEY, Boolean.toString(this.switchOff));
                }
                if (this.isMultiThreadLO) {
                    props.setProperty(prefix + IS_MULTI_THREAD_LO_KEY, Boolean.toString(this.isMultiThreadLO));
                }
                if (this.doRemoteCheck) {
                    props.setProperty(prefix + DO_REMOTE_CHECK_KEY, Boolean.toString(this.doRemoteCheck));
                }
                if (this.useServerConfiguration) {
                    props.setProperty(prefix + USE_SERVER_CONFIGURATION_KEY, Boolean.toString(this.useServerConfiguration));
                }
                if (this.useOtherServer) {
                    props.setProperty(prefix + USE_OTHER_SERVER_KEY, Boolean.toString(this.useOtherServer));
                }
                if (this.otherServerUrl != null) {
                    props.setProperty(prefix + OTHER_SERVER_URL_KEY, this.otherServerUrl);
                }
                if (this.fontName != null) {
                    props.setProperty(prefix + FONT_NAME_KEY, this.fontName);
                }
                if (this.fontStyle != -1) {
                    props.setProperty(prefix + FONT_STYLE_KEY, Integer.toString(this.fontStyle));
                }
                if (this.fontSize != -1) {
                    props.setProperty(prefix + FONT_SIZE_KEY, Integer.toString(this.fontSize));
                }
                if (this.lookAndFeelName != null) {
                    props.setProperty(prefix + LF_NAME_KEY, this.lookAndFeelName);
                }
                if (this.externalRuleDirectory != null) {
                    props.setProperty(prefix + EXTERNAL_RULE_DIRECTORY, this.externalRuleDirectory);
                }
                StringBuilder sbRV = new StringBuilder();
                for (Map.Entry throwable : this.configurableRuleValues.entrySet()) {
                    sbRV.append((String)throwable.getKey()).append(":").append(Integer.toString((Integer)throwable.getValue())).append(", ");
                }
                props.setProperty(prefix + CONFIGURABLE_RULE_VALUES_KEY + qualifier, sbRV.toString());
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<ITSIssueType, Color> entry3 : this.errorColors.entrySet()) {
                    String rgb = Integer.toHexString(entry3.getValue().getRGB());
                    rgb = rgb.substring(2, rgb.length());
                    sb.append(entry3.getKey()).append(":#").append(rgb).append(", ");
                }
                props.setProperty(prefix + ERROR_COLORS_KEY, sb.toString());
                StringBuilder stringBuilder = new StringBuilder();
                for (Map.Entry<String, Color> entry4 : this.underlineColors.entrySet()) {
                    String rgb = Integer.toHexString(entry4.getValue().getRGB());
                    rgb = rgb.substring(2, rgb.length());
                    stringBuilder.append(entry4.getKey()).append(":#").append(rgb).append(", ");
                }
                props.setProperty(prefix + UNDERLINE_COLORS_KEY, stringBuilder.toString());
                for (String key : this.configForOtherLanguages.keySet()) {
                    props.setProperty(key, this.configForOtherLanguages.get(key));
                }
            } else {
                this.saveConfigforProfile(props, prefix);
            }
            FileOutputStream fos2 = new FileOutputStream(this.configFile, true);
            Object object2 = null;
            try {
                props.store(fos2, "Profile: " + (prefix.isEmpty() ? "Default" : prefix.substring(0, prefix.length() - 2)));
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (fos2 == null) continue;
                if (object2 != null) {
                    try {
                        fos2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    continue;
                }
                fos2.close();
            }
        }
        if (this.oldConfigFile != null && this.oldConfigFile.exists()) {
            this.oldConfigFile.delete();
        }
    }

    private void addListToProperties(Properties props, String key, Set<String> list) {
        if (list == null) {
            props.setProperty(key, "");
        } else {
            props.setProperty(key, String.join((CharSequence)DELIMITER, list));
        }
    }

    private void setAllProfileKeys() {
        this.allProfileKeys.add(LANGUAGE_KEY);
        this.allProfileKeys.add(MOTHER_TONGUE_KEY);
        this.allProfileKeys.add(NGRAM_DIR_KEY);
        this.allProfileKeys.add(WORD2VEC_DIR_KEY);
        this.allProfileKeys.add(AUTO_DETECT_KEY);
        this.allProfileKeys.add(TAGGER_SHOWS_DISAMBIG_LOG_KEY);
        this.allProfileKeys.add(SERVER_RUN_KEY);
        this.allProfileKeys.add(SERVER_PORT_KEY);
        this.allProfileKeys.add(PARA_CHECK_KEY);
        this.allProfileKeys.add(RESET_CHECK_KEY);
        this.allProfileKeys.add(NO_MULTI_RESET_KEY);
        this.allProfileKeys.add(DO_FULL_CHECK_AT_FIRST_KEY);
        this.allProfileKeys.add(USE_DOC_LANG_KEY);
        this.allProfileKeys.add(USE_GUI_KEY);
        this.allProfileKeys.add(FONT_NAME_KEY);
        this.allProfileKeys.add(FONT_STYLE_KEY);
        this.allProfileKeys.add(FONT_SIZE_KEY);
        this.allProfileKeys.add(LF_NAME_KEY);
        this.allProfileKeys.add(ERROR_COLORS_KEY);
        this.allProfileKeys.add(UNDERLINE_COLORS_KEY);
        this.allProfileKeys.add(LT_SWITCHED_OFF_KEY);
        this.allProfileKeys.add(IS_MULTI_THREAD_LO_KEY);
        this.allProfileKeys.add(EXTERNAL_RULE_DIRECTORY);
        this.allProfileKeys.add(DO_REMOTE_CHECK_KEY);
        this.allProfileKeys.add(OTHER_SERVER_URL_KEY);
        this.allProfileKeys.add(USE_OTHER_SERVER_KEY);
        this.allProfileKeys.add(USE_SERVER_CONFIGURATION_KEY);
        this.allProfileLangKeys.add(DISABLED_RULES_KEY);
        this.allProfileLangKeys.add(ENABLED_RULES_KEY);
        this.allProfileLangKeys.add(DISABLED_CATEGORIES_KEY);
        this.allProfileLangKeys.add(ENABLED_CATEGORIES_KEY);
        this.allProfileLangKeys.add(CONFIGURABLE_RULE_VALUES_KEY);
    }

    private void storeConfigforAllProfiles(Properties props) {
        ArrayList<String> prefix = new ArrayList<String>();
        prefix.add("");
        for (String profile : this.definedProfiles) {
            String sPrefix = new String(profile);
            prefix.add(sPrefix.replaceAll(BLANK, BLANK_REPLACE) + PROFILE_DELIMITER);
        }
        for (String sPrefix : prefix) {
            for (String key : this.allProfileLangKeys) {
                for (Language lang : Languages.get()) {
                    String preKey = sPrefix + key + "." + lang.getShortCodeWithCountryAndVariant();
                    if (!props.containsKey(preKey)) continue;
                    this.configForOtherProfiles.put(preKey, props.getProperty(preKey));
                }
            }
        }
        for (String sPrefix : prefix) {
            for (String key : this.allProfileKeys) {
                String preKey = sPrefix + key;
                if (!props.containsKey(preKey)) continue;
                this.configForOtherProfiles.put(preKey, props.getProperty(preKey));
            }
        }
    }

    private void saveConfigforProfile(Properties props, String prefix) {
        for (String key : this.allProfileLangKeys) {
            for (Language lang : Languages.get()) {
                String preKey = prefix + key + "." + lang.getShortCodeWithCountryAndVariant();
                if (!this.configForOtherProfiles.containsKey(preKey)) continue;
                props.setProperty(preKey, this.configForOtherProfiles.get(preKey));
            }
        }
        for (String key : this.allProfileKeys) {
            String preKey = prefix + key;
            if (!this.configForOtherProfiles.containsKey(preKey)) continue;
            props.setProperty(preKey, this.configForOtherProfiles.get(preKey));
        }
    }
}

