/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.databroker.ResourceDataBroker;

public class CommonWords {
    private static final Map<String, List<Language>> word2langs = Collections.synchronizedMap(new HashMap());
    private static final Pattern numberPattern = Pattern.compile("[0-9-.,]+");

    public CommonWords() {
        if (word2langs.size() == 0) {
            for (Language lang : Languages.get()) {
                String path;
                ResourceDataBroker dataBroker;
                if (lang.isVariant() || !(dataBroker = JLanguageTool.getDataBroker()).resourceExists(path = lang.getShortCode() + "/common_words.txt")) continue;
                try {
                    InputStream inputStream = dataBroker.getFromResourceDirAsStream(path);
                    Throwable throwable = null;
                    try {
                        Scanner scanner = new Scanner(inputStream, "utf-8");
                        Throwable throwable2 = null;
                        try {
                            while (scanner.hasNextLine()) {
                                String line = scanner.nextLine();
                                if (line.isEmpty() || line.startsWith("#")) continue;
                                String key = line.toLowerCase();
                                List<Language> languages = word2langs.get(key);
                                if (languages == null) {
                                    List<Language> l = Collections.synchronizedList(new LinkedList());
                                    l.add(lang);
                                    word2langs.put(key, l);
                                    continue;
                                }
                                languages.add(lang);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (scanner == null) continue;
                            if (throwable2 != null) {
                                try {
                                    scanner.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            scanner.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Map<Language, Integer> getKnownWordsPerLanguage(String text) {
        String[] words;
        HashMap<Language, Integer> result = new HashMap<Language, Integer>();
        if (!text.endsWith(" ")) {
            text = text.replaceFirst("\\p{L}+$", "");
        }
        for (String word : words = text.split("[(),.:;!?\u201e\u201c\"\u00a1\u00bf\\s-]")) {
            List<Language> languages;
            if (numberPattern.matcher(word).matches() || (languages = word2langs.get(word.toLowerCase())) == null) continue;
            for (Language lang : languages) {
                if (result.containsKey(lang)) {
                    result.put(lang, (Integer)result.get(lang) + 1);
                    continue;
                }
                result.put(lang, 1);
            }
        }
        return result;
    }
}

