/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.util;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Stack;

public class Logger {
    private static LogInterface instance = new NullLogger();

    public static synchronized void setGlobalLogger(LogInterface logger) {
        instance = logger;
    }

    public static synchronized LogInterface getGlobalLogger() {
        return instance;
    }

    public static LogInterface i() {
        return instance;
    }

    public static void setLogger(LogInterface i) {
        instance = i;
    }

    public static void logs(String s) {
        Logger.i().logs(s, new Object[0]);
    }

    public static void logs(String s, Object ... args) {
        Logger.i().logs(s, args);
    }

    public static void logss(String s) {
        Logger.i().logss(s);
    }

    public static void startTrack(String s, Object ... args) {
        Logger.i().startTrack(String.format(s, args));
    }

    public static void endTrack() {
        Logger.i().endTrack();
    }

    public static void dbg(String s) {
        Logger.i().dbg(s);
    }

    public static void err(String s) {
        Logger.i().err(s);
    }

    public static void err(String s, Object ... args) {
        Logger.i().err(s, args);
    }

    public static void warn(String s) {
        Logger.i().warn(s);
    }

    public static void warn(String string, Object ... args) {
        Logger.i().warn(string, args);
    }

    public static void logss(String string, Object ... args) {
        Logger.i().logss(string, args);
    }

    public static class CompoundLogger
    implements LogInterface {
        private final LogInterface[] loggers;

        public CompoundLogger(LogInterface ... loggers) {
            this.loggers = loggers;
        }

        @Override
        public void logs(String s, Object ... args) {
            for (LogInterface logger : this.loggers) {
                logger.logs(s, args);
            }
        }

        @Override
        public void logss(String s) {
            for (LogInterface logger : this.loggers) {
                logger.logss(s);
            }
        }

        @Override
        public void startTrack(String s) {
            for (LogInterface logger : this.loggers) {
                logger.startTrack(s);
            }
        }

        @Override
        public void endTrack() {
            for (LogInterface logger : this.loggers) {
                logger.endTrack();
            }
        }

        @Override
        public void dbg(String s) {
            for (LogInterface logger : this.loggers) {
                logger.dbg(s);
            }
        }

        @Override
        public void err(String s) {
            for (LogInterface logger : this.loggers) {
                logger.err(s);
            }
        }

        @Override
        public void err(String s, Object ... args) {
            for (LogInterface logger : this.loggers) {
                logger.err(s, args);
            }
        }

        @Override
        public void warn(String s) {
            for (LogInterface logger : this.loggers) {
                logger.warn(s);
            }
        }

        @Override
        public void warn(String string, Object ... args) {
            for (LogInterface logger : this.loggers) {
                logger.warn(string, args);
            }
        }

        @Override
        public void logss(String string, Object ... args) {
            for (LogInterface logger : this.loggers) {
                logger.logss(string, args);
            }
        }
    }

    public static class NullLogger
    implements LogInterface {
        @Override
        public void logs(String s, Object ... args) {
        }

        @Override
        public void logss(String s) {
        }

        @Override
        public void startTrack(String s) {
        }

        @Override
        public void endTrack() {
        }

        @Override
        public void dbg(String s) {
        }

        @Override
        public void err(String s) {
        }

        @Override
        public void err(String s, Object ... args) {
        }

        @Override
        public void warn(String s) {
        }

        @Override
        public void warn(String string, Object ... args) {
        }

        @Override
        public void logss(String string, Object ... args) {
        }
    }

    public static class SystemLogger
    implements LogInterface {
        private final PrintStream out;
        private final PrintStream err;
        private int trackLevel = 0;
        private final boolean debug = true;
        private final Stack<Long> trackStartTimes = new Stack();

        public SystemLogger(PrintStream out, PrintStream err) {
            this.out = out;
            this.err = err;
        }

        public void close() {
            if (this.out != null) {
                this.out.close();
            }
            if (this.err != null) {
                this.err.close();
            }
        }

        public SystemLogger(String outFile, String errFile) throws FileNotFoundException {
            this(outFile != null ? new PrintStream(new FileOutputStream(outFile)) : null, errFile != null ? new PrintStream(new FileOutputStream(errFile)) : null);
        }

        public SystemLogger() {
            this(System.out, System.err);
        }

        private String getIndentPrefix() {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.trackLevel; ++i) {
                builder.append("\t");
            }
            return builder.toString();
        }

        private void output(PrintStream o, String txt) {
            if (o == null) {
                return;
            }
            String[] lines = txt.split("\n");
            String prefix = this.getIndentPrefix();
            for (String line : lines) {
                o.println(prefix + line);
            }
        }

        @Override
        public void dbg(String s) {
            this.output(this.out, "[dbg] " + s);
        }

        private String timeString(double milliSecs_) {
            int mins;
            double milliSecs = milliSecs_;
            String timeStr = "";
            int hours = (int)(milliSecs / 3600000.0);
            if (hours > 0) {
                milliSecs -= (double)(hours * 1000 * 60 * 60);
                timeStr = timeStr + hours + "h";
            }
            if ((mins = (int)(milliSecs / 60000.0)) > 0) {
                milliSecs -= (double)mins * 1000.0 * 60.0;
                timeStr = timeStr + mins + "m";
            }
            int secs = (int)(milliSecs / 1000.0);
            timeStr = timeStr + secs + "s";
            return timeStr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endTrack() {
            String timeStr = null;
            SystemLogger systemLogger = this;
            synchronized (systemLogger) {
                --this.trackLevel;
                double milliSecs = System.currentTimeMillis() - this.trackStartTimes.pop();
                timeStr = this.timeString(milliSecs);
            }
            this.output(this.out, "} " + (timeStr != null ? "[" + timeStr + "]" : ""));
        }

        @Override
        public void err(String s) {
            this.err.println(s);
        }

        public void logs(String s) {
            this.output(this.out, s);
        }

        @Override
        public void logss(String s) {
            this.output(this.out, s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startTrack(String s) {
            this.output(this.out, s + " {");
            SystemLogger systemLogger = this;
            synchronized (systemLogger) {
                ++this.trackLevel;
                this.trackStartTimes.push(System.currentTimeMillis());
            }
        }

        @Override
        public void warn(String s) {
            this.output(this.err, "[warn] " + s);
        }

        @Override
        public void logs(String s, Object ... args) {
            this.logs(String.format(s, args));
        }

        @Override
        public void err(String s, Object ... args) {
            this.output(this.err, "[err] " + String.format(s, args));
        }

        @Override
        public void warn(String string, Object ... args) {
            this.warn(String.format(string, args));
        }

        @Override
        public void logss(String string, Object ... args) {
            this.logss(String.format(string, args));
        }
    }

    public static interface LogInterface {
        public void logs(String var1, Object ... var2);

        public void logss(String var1);

        public void logss(String var1, Object ... var2);

        public void startTrack(String var1);

        public void endTrack();

        public void dbg(String var1);

        public void err(String var1);

        public void err(String var1, Object ... var2);

        public void warn(String var1);

        public void warn(String var1, Object ... var2);
    }
}

