/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.bits;

import edu.berkeley.nlp.lm.bits.BitList;
import edu.berkeley.nlp.lm.bits.BitStream;
import edu.berkeley.nlp.lm.bits.CompressionUtils;
import java.io.Serializable;

public final class VariableLengthBitCompressor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int radix;

    public VariableLengthBitCompressor(int radix) {
        this.radix = radix;
    }

    public BitList compress(long n) {
        return CompressionUtils.variableCompress(n, this.radix);
    }

    public long decompress(BitStream bits) {
        return CompressionUtils.variableDecompress(bits, this.radix);
    }
}

