/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.ErrorRateTooHighException;
import org.languagetool.server.ApiV2;
import org.languagetool.server.AuthException;
import org.languagetool.server.DatabaseAccess;
import org.languagetool.server.DatabaseLogger;
import org.languagetool.server.DatabaseMiscLogEntry;
import org.languagetool.server.ErrorRequestLimiter;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.RequestCounter;
import org.languagetool.server.RequestLimiter;
import org.languagetool.server.ServerTools;
import org.languagetool.server.TextChecker;
import org.languagetool.server.TextTooLongException;
import org.languagetool.server.TooManyRequestsException;
import org.languagetool.server.V2TextChecker;
import org.languagetool.tools.StringTools;

class LanguageToolHttpHandler
implements HttpHandler {
    private static final String ENCODING = "utf-8";
    private final Set<String> allowedIps;
    private final RequestLimiter requestLimiter;
    private final ErrorRequestLimiter errorRequestLimiter;
    private final LinkedBlockingQueue<Runnable> workQueue;
    private final TextChecker textCheckerV2;
    private final HTTPServerConfig config;
    private final RequestCounter reqCounter = new RequestCounter();

    LanguageToolHttpHandler(HTTPServerConfig config, Set<String> allowedIps, boolean internal, RequestLimiter requestLimiter, ErrorRequestLimiter errorLimiter, LinkedBlockingQueue<Runnable> workQueue) {
        this.config = config;
        this.allowedIps = allowedIps;
        this.requestLimiter = requestLimiter;
        this.errorRequestLimiter = errorLimiter;
        this.workQueue = workQueue;
        this.textCheckerV2 = new V2TextChecker(config, internal, workQueue, this.reqCounter);
    }

    void shutdown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        block41: {
            long startTime = System.currentTimeMillis();
            String remoteAddress = null;
            Map<String, String> parameters = new HashMap<String, String>();
            int reqId = this.reqCounter.incrementRequestCount();
            boolean incrementHandleCount = false;
            try {
                String errorMessage;
                String pathWithoutVersion;
                URI requestedUri = httpExchange.getRequestURI();
                if (requestedUri.getRawPath().startsWith("/v2/") && (pathWithoutVersion = requestedUri.getRawPath().substring("/v2/".length())).equals("healthcheck")) {
                    if (this.workQueueFull(httpExchange, "Healthcheck failed: There are currently too many parallel requests.")) {
                        return;
                    }
                    String ok = "OK";
                    httpExchange.getResponseHeaders().set("Content-Type", "text/plain");
                    httpExchange.sendResponseHeaders(200, ok.getBytes(ENCODING).length);
                    httpExchange.getResponseBody().write(ok.getBytes(ENCODING));
                    return;
                }
                String referrer = httpExchange.getRequestHeaders().getFirst("Referer");
                String origin = httpExchange.getRequestHeaders().getFirst("Origin");
                for (String ref : this.config.getBlockedReferrers()) {
                    errorMessage = null;
                    if (ref != null && !ref.isEmpty()) {
                        if (referrer != null && this.siteMatches(referrer, ref)) {
                            errorMessage = "Error: Access with referrer " + referrer + " denied.";
                        } else if (origin != null && this.siteMatches(origin, ref)) {
                            errorMessage = "Error: Access with origin " + origin + " denied.";
                        }
                    }
                    if (errorMessage == null) continue;
                    this.sendError(httpExchange, 403, errorMessage);
                    this.logError(errorMessage, 403, parameters, httpExchange);
                    return;
                }
                String origAddress = httpExchange.getRemoteAddress().getAddress().getHostAddress();
                String realAddressOrNull = this.getRealRemoteAddressOrNull(httpExchange);
                remoteAddress = realAddressOrNull != null ? realAddressOrNull : origAddress;
                this.reqCounter.incrementHandleCount(remoteAddress, reqId);
                incrementHandleCount = true;
                parameters = this.getRequestQuery(httpExchange, requestedUri);
                if (this.requestLimiter != null) {
                    try {
                        this.requestLimiter.checkAccess(remoteAddress, parameters);
                    }
                    catch (TooManyRequestsException e) {
                        String errorMessage2 = "Error: Access from " + remoteAddress + " denied: " + e.getMessage();
                        int code = 403;
                        this.sendError(httpExchange, code, errorMessage2);
                        this.logError(errorMessage2, code, parameters, httpExchange);
                        httpExchange.close();
                        if (incrementHandleCount) {
                            this.reqCounter.decrementHandleCount(reqId);
                        }
                        return;
                    }
                }
                if (this.errorRequestLimiter != null && !this.errorRequestLimiter.wouldAccessBeOkay(remoteAddress)) {
                    String textSizeMessage = this.getTextOrDataSizeMessage(parameters);
                    String errorMessage3 = "Error: Access from " + remoteAddress + " denied - too many recent timeouts. " + textSizeMessage + " Allowed maximum timeouts: " + this.errorRequestLimiter.getRequestLimit() + " per " + this.errorRequestLimiter.getRequestLimitPeriodInSeconds() + " seconds";
                    int code = 403;
                    this.sendError(httpExchange, code, errorMessage3);
                    this.logError(errorMessage3, code, parameters, httpExchange);
                    return;
                }
                if (this.workQueueFull(httpExchange, "Error: There are currently too many parallel requests. Please try again later.")) {
                    return;
                }
                if (this.allowedIps == null || this.allowedIps.contains(origAddress)) {
                    if (requestedUri.getRawPath().startsWith("/v2/")) {
                        ApiV2 apiV2 = new ApiV2(this.textCheckerV2, this.config.getAllowOriginUrl());
                        String pathWithoutVersion2 = requestedUri.getRawPath().substring("/v2/".length());
                        apiV2.handleRequest(pathWithoutVersion2, httpExchange, parameters, this.errorRequestLimiter, remoteAddress, this.config);
                        break block41;
                    }
                    if (requestedUri.getRawPath().endsWith("/Languages")) {
                        throw new IllegalArgumentException("You're using an old version of our API that's not supported anymore. Please see https://languagetool.org/http-api/migration.php");
                    }
                    if (requestedUri.getRawPath().equals("/")) {
                        throw new IllegalArgumentException("Missing arguments for LanguageTool API. Please see https://languagetool.org/http-api/swagger-ui/#/default");
                    }
                    if (requestedUri.getRawPath().contains("/v2/")) {
                        throw new IllegalArgumentException("You have '/v2/' in your path, but not at the root. Try an URL like 'http://server/v2/...' ");
                    }
                    if (requestedUri.getRawPath().equals("/favicon.ico")) {
                        this.sendError(httpExchange, 404, "Not found");
                        break block41;
                    }
                    throw new IllegalArgumentException("Seems like you're using an old version of our API that's not supported anymore. Please see https://languagetool.org/http-api/migration.php");
                }
                errorMessage = "Error: Access from " + StringTools.escapeXML(origAddress) + " denied";
                this.sendError(httpExchange, 403, errorMessage);
                throw new RuntimeException(errorMessage);
            }
            catch (Exception e) {
                String response;
                int errorCode;
                boolean textLoggingAllowed = false;
                boolean logStacktrace = true;
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (e instanceof TextTooLongException || rootCause instanceof TextTooLongException) {
                    errorCode = 413;
                    response = e.getMessage();
                    logStacktrace = false;
                } else if (e instanceof ErrorRateTooHighException || rootCause instanceof ErrorRateTooHighException) {
                    errorCode = 400;
                    response = ExceptionUtils.getRootCause(e).getMessage();
                    logStacktrace = false;
                } else if (e instanceof AuthException || rootCause instanceof AuthException) {
                    errorCode = 403;
                    response = e.getMessage();
                } else if (e instanceof IllegalArgumentException || rootCause instanceof IllegalArgumentException) {
                    errorCode = 400;
                    response = e.getMessage();
                } else if (e instanceof TimeoutException || rootCause instanceof TimeoutException) {
                    errorCode = 500;
                    response = "Checking took longer than " + (float)this.config.getMaxCheckTimeMillis() / 1000.0f + " seconds, which is this server's limit. Please make sure you have selected the proper language or consider submitting a shorter text.";
                } else {
                    response = "Internal Error: " + e.getMessage();
                    errorCode = 500;
                    textLoggingAllowed = true;
                }
                long endTime = System.currentTimeMillis();
                this.logError(remoteAddress, e, errorCode, httpExchange, parameters, textLoggingAllowed, logStacktrace, endTime - startTime);
                this.sendError(httpExchange, errorCode, "Error: " + response);
            }
            finally {
                httpExchange.close();
                if (incrementHandleCount) {
                    this.reqCounter.decrementHandleCount(reqId);
                }
            }
        }
    }

    private boolean siteMatches(String referrer, String blockedRef) {
        return referrer.startsWith(blockedRef) || referrer.startsWith("http://" + blockedRef) || referrer.startsWith("https://" + blockedRef) || referrer.startsWith("http://www." + blockedRef) || referrer.startsWith("https://www." + blockedRef);
    }

    private boolean workQueueFull(HttpExchange httpExchange, String response) throws IOException {
        if (this.config.getMaxWorkQueueSize() != 0 && this.workQueue.size() > this.config.getMaxWorkQueueSize()) {
            ServerTools.print(response + ", sending code 503. Queue size: " + this.workQueue.size() + ", maximum size: " + this.config.getMaxWorkQueueSize() + ", handlers:" + this.reqCounter.getHandleCount() + ", r:" + this.reqCounter.getRequestCount());
            this.sendError(httpExchange, 503, "Error: " + response);
            return true;
        }
        return false;
    }

    @NotNull
    private String getTextOrDataSizeMessage(Map<String, String> parameters) {
        String text = parameters.get("text");
        if (text != null) {
            return "Text size: " + text.length() + ".";
        }
        String data = parameters.get("data");
        if (data != null) {
            return "Data size: " + data.length() + ".";
        }
        return "";
    }

    private void logError(String errorMessage, int code, Map<String, String> params, HttpExchange httpExchange) {
        String message = errorMessage + ", sending code " + code + " - useragent: " + params.get("useragent") + " - HTTP UserAgent: " + this.getHttpUserAgent(httpExchange) + ", r:" + this.reqCounter.getRequestCount();
        if (params.get("username") != null) {
            message = message + ", user: " + params.get("username");
        }
        if (params.get("apiKey") != null) {
            message = message + ", apiKey: " + params.get("apiKey");
        }
        this.logToDatabase(params, message);
        ServerTools.print(message);
    }

    private void logError(String remoteAddress, Exception e, int errorCode, HttpExchange httpExchange, Map<String, String> params, boolean textLoggingAllowed, boolean logStacktrace, long runtimeMillis) {
        String message = "An error has occurred: '" + e.getMessage() + "', sending HTTP code " + errorCode + ". ";
        message = message + "Access from " + remoteAddress + ", ";
        message = message + "HTTP user agent: " + this.getHttpUserAgent(httpExchange) + ", ";
        message = message + "User agent param: " + params.get("useragent") + ", ";
        message = message + "Referrer: " + this.getHttpReferrer(httpExchange) + ", ";
        message = message + "language: " + params.get("language") + ", ";
        message = message + "h: " + this.reqCounter.getHandleCount() + ", ";
        message = message + "r: " + this.reqCounter.getRequestCount() + ", ";
        if (params.get("username") != null) {
            message = message + "user: " + params.get("username") + ", ";
        }
        if (params.get("apiKey") != null) {
            message = message + "apiKey: " + params.get("apiKey") + ", ";
        }
        message = message + "time: " + runtimeMillis + ", ";
        String text = params.get("text");
        if (text != null) {
            message = message + "text length: " + text.length() + ", ";
        }
        if (logStacktrace) {
            message = message + "Stacktrace follows:";
            ServerTools.print(message, System.err);
            e.printStackTrace();
        } else {
            message = message + "(no stacktrace logged)";
            ServerTools.print(message, System.err);
        }
        if (this.config.isVerbose() && text != null && textLoggingAllowed) {
            ServerTools.print("Exception was caused by this text (" + text.length() + " chars, showing up to 500):\n" + StringUtils.abbreviate(text, 500), System.err);
            this.logToDatabase(params, message + StringUtils.abbreviate(text, 500));
        } else {
            this.logToDatabase(params, message);
        }
    }

    private void logToDatabase(Map<String, String> params, String message) {
        DatabaseLogger logger = DatabaseLogger.getInstance();
        if (!logger.isLogging()) {
            return;
        }
        DatabaseAccess db = DatabaseAccess.getInstance();
        Long server = db.getOrCreateServerId();
        Long client = db.getOrCreateClientId(params.get("agent"));
        Long user = null;
        try {
            user = db.getUserId(params.get("username"), params.get("apiKey"));
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {
            // empty catch block
        }
        logger.log(new DatabaseMiscLogEntry(server, client, user, message));
    }

    @Nullable
    private String getHttpUserAgent(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("User-Agent");
    }

    @Nullable
    private String getHttpReferrer(HttpExchange httpExchange) {
        return httpExchange.getRequestHeaders().getFirst("Referer");
    }

    @Nullable
    private String getRealRemoteAddressOrNull(HttpExchange httpExchange) {
        Object forwardedIpsStr;
        if (this.config.getTrustXForwardForHeader() && (forwardedIpsStr = httpExchange.getRequestHeaders().get("X-forwarded-for")) != null && forwardedIpsStr.size() > 0) {
            return (String)forwardedIpsStr.get(0);
        }
        return null;
    }

    private void sendError(HttpExchange httpExchange, int httpReturnCode, String response) throws IOException {
        ServerTools.setAllowOrigin(httpExchange, this.config.getAllowOriginUrl());
        httpExchange.sendResponseHeaders(httpReturnCode, response.getBytes(ENCODING).length);
        httpExchange.getResponseBody().write(response.getBytes(ENCODING));
    }

    private Map<String, String> getRequestQuery(HttpExchange httpExchange, URI requestedUri) throws IOException {
        String query;
        if ("post".equalsIgnoreCase(httpExchange.getRequestMethod())) {
            try (InputStreamReader isr = new InputStreamReader(httpExchange.getRequestBody(), ENCODING);){
                query = this.readerToString(isr, this.config.getMaxTextHardLength());
            }
        } else {
            query = requestedUri.getRawQuery();
        }
        return this.parseQuery(query, httpExchange);
    }

    private String readerToString(Reader reader, int maxTextLength) throws IOException {
        int readBytes;
        StringBuilder sb = new StringBuilder();
        char[] chars = new char[4000];
        while ((readBytes = reader.read(chars, 0, 4000)) > 0) {
            int generousMaxLength = maxTextLength * 3 + 1000;
            if (generousMaxLength < 0) {
                generousMaxLength = Integer.MAX_VALUE;
            }
            if (sb.length() > 0 && sb.length() > generousMaxLength) {
                throw new TextTooLongException("Your text's length exceeds this server's hard limit of " + maxTextLength + " characters.");
            }
            sb.append(new String(chars, 0, readBytes));
        }
        return sb.toString();
    }

    private Map<String, String> parseQuery(String query, HttpExchange httpExchange) throws UnsupportedEncodingException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query != null) {
            Map<String, String> parameterMap = this.getParameterMap(query, httpExchange);
            parameters.putAll(parameterMap);
        }
        return parameters;
    }

    private Map<String, String> getParameterMap(String query, HttpExchange httpExchange) throws UnsupportedEncodingException {
        String[] pairs = query.split("[&]");
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String pair : pairs) {
            int delimPos = pair.indexOf(61);
            if (delimPos == -1) continue;
            String param = pair.substring(0, delimPos);
            String key = URLDecoder.decode(param, ENCODING);
            try {
                String value = URLDecoder.decode(pair.substring(delimPos + 1), ENCODING);
                parameters.put(key, value);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException("Could not decode query. Query length: " + query.length() + " Request method: " + httpExchange.getRequestMethod(), e);
            }
        }
        return parameters;
    }
}

