/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Categories;
import org.languagetool.rules.CorrectExample;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tools.StringTools;

public class CommaWhitespaceRule
extends Rule {
    public CommaWhitespaceRule(ResourceBundle messages, IncorrectExample incorrectExample, CorrectExample correctExample) {
        super(messages);
        super.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Whitespace);
        if (incorrectExample != null && correctExample != null) {
            this.addExamplePair(incorrectExample, correctExample);
        }
    }

    public CommaWhitespaceRule(ResourceBundle messages) {
        this(messages, null, null);
    }

    @Override
    public String getId() {
        return "COMMA_PARENTHESIS_WHITESPACE";
    }

    @Override
    public final String getDescription() {
        return this.messages.getString("desc_comma_whitespace");
    }

    public String getCommaCharacter() {
        return ",";
    }

    @Override
    public final RuleMatch[] match(AnalyzedSentence sentence) {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokens();
        String prevToken = "";
        String prevPrevToken = "";
        boolean prevWhite = false;
        for (int i = 0; i < tokens.length; ++i) {
            boolean isException;
            String token = tokens[i].getToken();
            boolean isWhitespace = (tokens[i].isWhitespace() || StringTools.isNonBreakingWhitespace(token) || tokens[i].isFieldCode()) && !token.equals("\u200b");
            String msg = null;
            String suggestionText = null;
            if (isWhitespace && CommaWhitespaceRule.isLeftBracket(prevToken)) {
                boolean bl = isException = i + 1 < tokens.length && prevToken.equals("[") && token.equals(" ") && tokens[i + 1].getToken().equals("]");
                if (!isException) {
                    msg = this.messages.getString("no_space_after");
                    suggestionText = prevToken;
                }
            } else if (!(isWhitespace || !prevToken.equals(this.getCommaCharacter()) || CommaWhitespaceRule.isQuoteOrHyphenOrComma(token) || CommaWhitespaceRule.containsDigit(prevPrevToken) || CommaWhitespaceRule.containsDigit(token) || ",".equals(prevPrevToken))) {
                msg = this.messages.getString("missing_space_after_comma");
                suggestionText = this.getCommaCharacter() + " " + tokens[i].getToken();
            } else if (prevWhite) {
                if (CommaWhitespaceRule.isRightBracket(token)) {
                    boolean bl = isException = token.equals("]") && prevToken.equals(" ") && prevPrevToken.equals("[");
                    if (!isException) {
                        msg = this.messages.getString("no_space_before");
                        suggestionText = token;
                    }
                } else if (token.equals(this.getCommaCharacter())) {
                    msg = this.messages.getString("space_after_comma");
                    suggestionText = this.getCommaCharacter();
                    if (i + 1 < tokens.length && this.getCommaCharacter().equals(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                } else if (token.equals(".")) {
                    msg = this.messages.getString("no_space_before_dot");
                    suggestionText = ".";
                    if (i + 1 < tokens.length && CommaWhitespaceRule.isDigitOrDot(tokens[i + 1].getToken())) {
                        msg = null;
                    }
                }
            }
            if (msg != null) {
                int fromPos = tokens[i - 1].getStartPos();
                int toPos = tokens[i].getEndPos();
                RuleMatch ruleMatch = new RuleMatch((Rule)this, sentence, fromPos, toPos, msg);
                ruleMatch.setSuggestedReplacement(suggestionText);
                ruleMatches.add(ruleMatch);
            }
            prevPrevToken = prevToken;
            prevToken = token;
            prevWhite = isWhitespace && !tokens[i].isFieldCode();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    private static boolean isQuoteOrHyphenOrComma(String str) {
        char c;
        return str.length() == 1 && ((c = str.charAt(0)) == '\'' || c == '-' || c == '\u201d' || c == '\u2019' || c == '\"' || c == '\u201c' || c == ',' || c == '\u00bb');
    }

    private static boolean isDigitOrDot(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == '.' || Character.isDigit(c);
    }

    private static boolean isLeftBracket(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == '(' || c == '[' || c == '{';
    }

    private static boolean isRightBracket(String str) {
        if (StringTools.isEmpty(str)) {
            return false;
        }
        char c = str.charAt(0);
        return c == ')' || c == ']' || c == '}';
    }

    private static boolean containsDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isDigit(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

