/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.cache;

import edu.berkeley.nlp.lm.AbstractArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.ArrayEncodedNgramLanguageModel;
import edu.berkeley.nlp.lm.bits.BitUtils;
import edu.berkeley.nlp.lm.cache.ArrayEncodedDirectMappedLmCache;
import edu.berkeley.nlp.lm.cache.ArrayEncodedLmCache;
import edu.berkeley.nlp.lm.util.MurmurHash;

public class ArrayEncodedCachingLmWrapper<W>
extends AbstractArrayEncodedNgramLanguageModel<W> {
    private static final long serialVersionUID = 1L;
    private final ArrayEncodedLmCache cache;
    private final ArrayEncodedNgramLanguageModel<W> lm;
    private final int capacity;

    public static <W> ArrayEncodedCachingLmWrapper<W> wrapWithCacheNotThreadSafe(ArrayEncodedNgramLanguageModel<W> lm) {
        return ArrayEncodedCachingLmWrapper.wrapWithCacheNotThreadSafe(lm, 18);
    }

    public static <W> ArrayEncodedCachingLmWrapper<W> wrapWithCacheNotThreadSafe(ArrayEncodedNgramLanguageModel<W> lm, int cacheBits) {
        return new ArrayEncodedCachingLmWrapper<W>(lm, false, cacheBits);
    }

    public static <W> ArrayEncodedCachingLmWrapper<W> wrapWithCacheThreadSafe(ArrayEncodedNgramLanguageModel<W> lm) {
        return ArrayEncodedCachingLmWrapper.wrapWithCacheThreadSafe(lm, 16);
    }

    public static <W> ArrayEncodedCachingLmWrapper<W> wrapWithCacheThreadSafe(ArrayEncodedNgramLanguageModel<W> lm, int cacheBits) {
        return new ArrayEncodedCachingLmWrapper<W>(lm, true, cacheBits);
    }

    private ArrayEncodedCachingLmWrapper(ArrayEncodedNgramLanguageModel<W> lm, boolean threadSafe, int cacheBits) {
        this(lm, new ArrayEncodedDirectMappedLmCache(cacheBits, lm.getLmOrder(), threadSafe));
    }

    private ArrayEncodedCachingLmWrapper(ArrayEncodedNgramLanguageModel<W> lm, ArrayEncodedLmCache cache) {
        super(lm.getLmOrder(), lm.getWordIndexer(), Float.NaN);
        this.cache = cache;
        this.lm = lm;
        this.capacity = cache.capacity();
    }

    @Override
    public float getLogProb(int[] ngram, int startPos, int endPos) {
        if (endPos - startPos <= 1) {
            return this.lm.getLogProb(ngram, startPos, endPos);
        }
        int hash = ArrayEncodedCachingLmWrapper.hash(ngram, startPos, endPos) % this.capacity;
        float f = this.cache.getCached(ngram, startPos, endPos, hash);
        if (!Float.isNaN(f)) {
            return f;
        }
        f = this.lm.getLogProb(ngram, startPos, endPos);
        this.cache.putCached(ngram, startPos, endPos, f, hash);
        return f;
    }

    private static int hash(int[] key, int startPos, int endPos) {
        int hash = MurmurHash.hash32(key, startPos, endPos);
        return BitUtils.abs(hash);
    }
}

