/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.languagetool.server.HTTPServerConfig;
import org.languagetool.server.UserLimits;

final class ServerTools {
    private ServerTools() {
    }

    static void print(String s) {
        ServerTools.print(s, System.out);
    }

    static void print(String s, PrintStream outputStream) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String now = dateFormat.format(new Date());
        outputStream.println(now + " " + s);
    }

    static void setCommonHeaders(HttpExchange httpExchange, String contentType, String allowOriginUrl) {
        httpExchange.getResponseHeaders().set("Content-Type", contentType);
        ServerTools.setAllowOrigin(httpExchange, allowOriginUrl);
    }

    static void setAllowOrigin(HttpExchange httpExchange, String allowOriginUrl) {
        if (allowOriginUrl != null) {
            httpExchange.getResponseHeaders().set("Access-Control-Allow-Origin", allowOriginUrl);
        }
    }

    static UserLimits getUserLimits(Map<String, String> params, HTTPServerConfig config) {
        if (params.get("token") != null) {
            return UserLimits.getLimitsFromToken(config, params.get("token"));
        }
        if (params.get("username") != null) {
            if (params.get("apikey") != null) {
                return UserLimits.getLimitsByApiKey(config, params.get("username"), params.get("apikey"));
            }
            if (params.get("password") != null) {
                return UserLimits.getLimitsFromUserAccount(config, params.get("username"), params.get("password"));
            }
            throw new IllegalArgumentException("With 'username' set, you also need to specify either 'apikey' or 'password'");
        }
        return UserLimits.getDefaultLimits(config);
    }
}

