/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.map;

import edu.berkeley.nlp.lm.WordIndexer;
import edu.berkeley.nlp.lm.collections.Iterators;
import edu.berkeley.nlp.lm.map.NgramMap;
import edu.berkeley.nlp.lm.map.NgramMapWrapper;
import edu.berkeley.nlp.lm.map.NgramsForOrderIterableWrapper;
import edu.berkeley.nlp.lm.util.Logger;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NgramIterableWrapper<W, V>
implements Iterable<Map.Entry<List<W>, V>> {
    private final NgramsForOrderIterableWrapper<W, V>[] ngramsForOrder;

    public NgramIterableWrapper(NgramMap<V> map, WordIndexer<W> wordIndexer) {
        this(map, wordIndexer, map.getMaxNgramOrder());
    }

    public NgramIterableWrapper(NgramMap<V> map, WordIndexer<W> wordIndexer, int maxOrder) {
        NgramsForOrderIterableWrapper[] maps = new NgramsForOrderIterableWrapper[maxOrder];
        this.ngramsForOrder = maps;
        for (int ngramOrder = 0; ngramOrder < maxOrder; ++ngramOrder) {
            this.ngramsForOrder[ngramOrder] = new NgramsForOrderIterableWrapper<W, V>(map, wordIndexer, ngramOrder);
        }
    }

    @Override
    public Iterator<Map.Entry<List<W>, V>> iterator() {
        Iterators.Transform transform = new Iterators.Transform<NgramsForOrderIterableWrapper<W, V>, Iterator<Map.Entry<List<W>, V>>>(Arrays.asList(this.ngramsForOrder).iterator()){

            @Override
            protected Iterator<Map.Entry<List<W>, V>> transform(NgramsForOrderIterableWrapper<W, V> next) {
                return next.iterator();
            }
        };
        return new Iterators.IteratorIterator<Map.Entry<List<W>, V>>(transform);
    }

    public long size() {
        long size = 0L;
        for (NgramsForOrderIterableWrapper<W, V> map : this.ngramsForOrder) {
            size += map.size();
        }
        if (size > Integer.MAX_VALUE) {
            Logger.warn(NgramMapWrapper.class.getSimpleName() + " doesn't like maps with size greater than Integer.MAX_VALUE");
        }
        return (int)size;
    }
}

