//
//  LaTeXiTTypes.h
//  LaTeXiT
//
//  Created by Pierre Chatelier on 25/09/08.
//  Copyright 2005, 2006, 2007, 2008, 2009, 2010, 2011 Pierre Chatelier. All rights reserved.
//
//

//useful to differenciate the different latex modes : EQNARRAY, DISPLAY (\[...\]), INLINE ($...$) and TEXT (text)
typedef enum {LATEX_MODE_DISPLAY, LATEX_MODE_INLINE, LATEX_MODE_TEXT, LATEX_MODE_EQNARRAY, LATEX_MODE_ALIGN} latex_mode_t;

typedef enum {EXPORT_FORMAT_PDF, EXPORT_FORMAT_PDF_NOT_EMBEDDED_FONTS,
              EXPORT_FORMAT_EPS, EXPORT_FORMAT_TIFF, EXPORT_FORMAT_PNG, EXPORT_FORMAT_JPEG,
              EXPORT_FORMAT_MATHML,
              EXPORT_FORMAT_SVG} export_format_t;

typedef enum {COMPOSITION_MODE_PDFLATEX, COMPOSITION_MODE_LATEXDVIPDF, COMPOSITION_MODE_XELATEX} composition_mode_t;
typedef enum {SCRIPT_SOURCE_STRING, SCRIPT_SOURCE_FILE} script_source_t;
typedef enum {SCRIPT_PLACE_PREPROCESSING, SCRIPT_PLACE_MIDDLEPROCESSING, SCRIPT_PLACE_POSTPROCESSING} script_place_t;

typedef enum {DOCUMENT_STYLE_UNDEFINED=-1, DOCUMENT_STYLE_NORMAL=0, DOCUMENT_STYLE_MINI=1} document_style_t;

typedef enum {LIBRARY_ROW_IMAGE_AND_TEXT, LIBRARY_ROW_IMAGE_LARGE} library_row_t;

typedef enum {CHANGE_SERVICE_SHORTCUTS_FALLBACK_IGNORE,
              CHANGE_SERVICE_SHORTCUTS_FALLBACK_APPLY_USERDEFAULTS,
              CHANGE_SERVICE_SHORTCUTS_FALLBACK_REPLACE_USERDEFAULTS,
              CHANGE_SERVICE_SHORTCUTS_FALLBACK_ASK} change_service_shortcuts_fallback_t;
              
typedef enum {SERVICE_LATEXIZE_EQNARRAY, SERVICE_LATEXIZE_DISPLAY, SERVICE_LATEXIZE_INLINE, SERVICE_LATEXIZE_TEXT,
              SERVICE_MULTILATEXIZE, SERVICE_DELATEXIZE, SERVICE_LATEXIZE_ALIGN} service_identifier_t;

extern latex_mode_t validateLatexMode(latex_mode_t mode);
