/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ant_deb_task;

import com.googlecode.ant_deb_task.BuildDeb;
import com.googlecode.ant_deb_task.GZipOutputStream;
import com.googlecode.ant_deb_task.UnixPrintWriter;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.TarFileSet;
import org.apache.tools.tar.TarOutputStream;

public class Deb
extends Task {
    private static final Pattern PACKAGE_NAME_PATTERN = Pattern.compile("[a-z0-9][a-z0-9+\\-.]+");
    private File _toDir;
    private String _debFilenameProperty = "";
    private String _package;
    private String _version;
    private Version _versionObj;
    private String _section;
    private String _priority = "extra";
    private String _architecture = "all";
    private String _depends;
    private String _preDepends;
    private String _recommends;
    private String _suggests;
    private String _enhances;
    private String _conflicts;
    private String _provides;
    private String _maintainer;
    private URL _homepage;
    private Maintainer _maintainerObj;
    private Description _description;
    private Set _conffiles = new HashSet();
    private Set _changelogs = new HashSet();
    private List _data = new ArrayList();
    private File _preinst;
    private File _postinst;
    private File _prerm;
    private File _postrm;
    private File _config;
    private File _templates;
    private File _triggers;
    private File _tempFolder;
    private long _installedSize = 0L;
    private SortedSet _dataFolders;
    private static final Tar.TarCompressionMethod GZIP_COMPRESSION_METHOD = new Tar.TarCompressionMethod();
    private static final Tar.TarLongFileMode GNU_LONGFILE_MODE = new Tar.TarLongFileMode();

    public void setToDir(File toDir) {
        this._toDir = toDir;
    }

    public void setDebFilenameProperty(String debFilenameProperty) {
        this._debFilenameProperty = debFilenameProperty.trim();
    }

    public void setPackage(String packageName) {
        if (!PACKAGE_NAME_PATTERN.matcher(packageName).matches()) {
            throw new BuildException("Invalid package name!");
        }
        this._package = packageName;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setSection(Section section) {
        this._section = section.getValue();
    }

    public void setPriority(Priority priority) {
        this._priority = priority.getValue();
    }

    public void setArchitecture(String architecture) {
        this._architecture = architecture;
    }

    public void setDepends(String depends) {
        this._depends = depends;
    }

    public void setPreDepends(String preDepends) {
        this._preDepends = preDepends;
    }

    public void setRecommends(String recommends) {
        this._recommends = recommends;
    }

    public void setSuggests(String suggests) {
        this._suggests = suggests;
    }

    public void setEnhances(String enhances) {
        this._enhances = enhances;
    }

    public void setConflicts(String conflicts) {
        this._conflicts = conflicts;
    }

    public void setProvides(String provides) {
        this._provides = provides;
    }

    public void setMaintainer(String maintainer) {
        this._maintainer = maintainer;
    }

    public void setHomepage(String homepage) {
        try {
            this._homepage = new URL(homepage);
        }
        catch (MalformedURLException e) {
            throw new BuildException("Invalid homepage, must be a URL: " + homepage, (Throwable)e);
        }
    }

    public void setPreinst(File preinst) {
        this._preinst = preinst;
    }

    public void setPostinst(File postinst) {
        this._postinst = postinst;
    }

    public void setPrerm(File prerm) {
        this._prerm = prerm;
    }

    public void setPostrm(File postrm) {
        this._postrm = postrm;
    }

    public void setConfig(File config) {
        this._config = config;
    }

    public void setTemplates(File templates) {
        this._templates = templates;
    }

    public void setTriggers(File triggers) {
        this._triggers = triggers;
    }

    public void addConfFiles(TarFileSet conffiles) {
        this._conffiles.add(conffiles);
        this._data.add(conffiles);
    }

    public void addChangelog(Changelog changelog) {
        this._changelogs.add(changelog);
    }

    public void addDescription(Description description) {
        this._description = description;
    }

    public void add(TarFileSet resourceCollection) {
        this._data.add(resourceCollection);
    }

    public void addVersion(Version version) {
        this._versionObj = version;
    }

    public void addMaintainer(Maintainer maintainer) {
        this._maintainerObj = maintainer;
    }

    private void writeControlFile(File controlFile, long installedSize) throws FileNotFoundException {
        this.log("Generating control file to: " + controlFile.getAbsolutePath(), 3);
        UnixPrintWriter control = new UnixPrintWriter(controlFile);
        control.print("Package: ");
        control.println(this._package);
        control.print("Version: ");
        control.println(this._version);
        if (this._section != null) {
            control.print("Section: ");
            control.println(this._section);
        }
        if (this._priority != null) {
            control.print("Priority: ");
            control.println(this._priority);
        }
        control.print("Architecture: ");
        control.println(this._architecture);
        if (this._depends != null) {
            control.print("Depends: ");
            control.println(this._depends);
        }
        if (this._preDepends != null) {
            control.print("Pre-Depends: ");
            control.println(this._preDepends);
        }
        if (this._recommends != null) {
            control.print("Recommends: ");
            control.println(this._recommends);
        }
        if (this._suggests != null) {
            control.print("Suggests: ");
            control.println(this._suggests);
        }
        if (this._enhances != null) {
            control.print("Enhances: ");
            control.println(this._enhances);
        }
        if (this._conflicts != null) {
            control.print("Conflicts: ");
            control.println(this._conflicts);
        }
        if (this._provides != null) {
            control.print("Provides: ");
            control.println(this._provides);
        }
        if (installedSize > 0L) {
            control.print("Installed-Size: ");
            control.println(installedSize / 1024L);
        }
        control.print("Maintainer: ");
        control.println(this._maintainer);
        if (this._homepage != null) {
            control.print("Homepage: ");
            control.println(this._homepage.toExternalForm());
        }
        control.print("Description: ");
        control.println(this._description.getSynopsis());
        control.println(this._description.getExtendedFormatted());
        control.close();
    }

    private File createMasterControlFile() throws IOException {
        File controlFile = new File(this._tempFolder, "control");
        this.writeControlFile(controlFile, this._installedSize);
        File md5sumsFile = new File(this._tempFolder, "md5sums");
        File conffilesFile = new File(this._tempFolder, "conffiles");
        File masterControlFile = new File(this._tempFolder, "control.tar.gz");
        Tar controlTar = new Tar();
        controlTar.setProject(this.getProject());
        controlTar.setTaskName(this.getTaskName());
        controlTar.setDestFile(masterControlFile);
        controlTar.setCompression(GZIP_COMPRESSION_METHOD);
        this.addFileToTar(controlTar, controlFile, "control", "644");
        this.addFileToTar(controlTar, md5sumsFile, "md5sums", "644");
        if (conffilesFile.length() > 0L) {
            this.addFileToTar(controlTar, conffilesFile, "conffiles", "644");
        }
        if (this._preinst != null) {
            this.addFileToTar(controlTar, this._preinst, "preinst", "755");
        }
        if (this._postinst != null) {
            this.addFileToTar(controlTar, this._postinst, "postinst", "755");
        }
        if (this._prerm != null) {
            this.addFileToTar(controlTar, this._prerm, "prerm", "755");
        }
        if (this._postrm != null) {
            this.addFileToTar(controlTar, this._postrm, "postrm", "755");
        }
        if (this._config != null) {
            this.addFileToTar(controlTar, this._config, "config", "755");
        }
        if (this._templates != null) {
            this.addFileToTar(controlTar, this._templates, "templates", "644");
        }
        if (this._triggers != null) {
            this.addFileToTar(controlTar, this._triggers, "triggers", "644");
        }
        controlTar.perform();
        this.deleteFileCheck(controlFile);
        return masterControlFile;
    }

    private void addFileToTar(Tar tar, File file, String fullpath, String fileMode) {
        Tar.TarFileSet controlFileSet = tar.createTarFileSet();
        controlFileSet.setFile(file);
        controlFileSet.setFullpath("./" + fullpath);
        controlFileSet.setFileMode(fileMode);
        controlFileSet.setUserName("root");
        controlFileSet.setGroup("root");
    }

    public void execute() throws BuildException {
        try {
            if (this._versionObj != null) {
                this._version = this._versionObj.toString();
            }
            if (this._maintainerObj != null) {
                this._maintainer = this._maintainerObj.toString();
            }
            this._tempFolder = this.createTempFolder();
            this.processChangelogs();
            this.scanData();
            File debFile = new File(this._toDir, this._package + "_" + this._version + "_" + this._architecture + ".deb");
            File dataFile = this.createDataFile();
            File masterControlFile = this.createMasterControlFile();
            this.log("Writing deb file to: " + debFile.getAbsolutePath());
            BuildDeb.buildDeb(debFile, masterControlFile, dataFile);
            if (this._debFilenameProperty.length() > 0) {
                this.getProject().setProperty(this._debFilenameProperty, debFile.getAbsolutePath());
            }
            this.deleteFileCheck(masterControlFile);
            this.deleteFileCheck(dataFile);
            this.deleteFolderCheck(this._tempFolder);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private File createDataFile() throws IOException {
        File dataFile = new File(this._tempFolder, "data.tar.gz");
        Tar dataTar = new Tar();
        dataTar.setProject(this.getProject());
        dataTar.setTaskName(this.getTaskName());
        dataTar.setDestFile(dataFile);
        dataTar.setCompression(GZIP_COMPRESSION_METHOD);
        dataTar.setLongfile(GNU_LONGFILE_MODE);
        if (this._data.size() > 0) {
            Iterator dataFoldersIter = this._dataFolders.iterator();
            while (dataFoldersIter.hasNext()) {
                String targetFolder = (String)dataFoldersIter.next();
                Tar.TarFileSet targetFolderSet = dataTar.createTarFileSet();
                targetFolderSet.setFile(this._tempFolder);
                targetFolderSet.setFullpath(targetFolder);
                targetFolderSet.setUserName("root");
                targetFolderSet.setGroup("root");
            }
            for (int i = 0; i < this._data.size(); ++i) {
                TarFileSet data = (TarFileSet)this._data.get(i);
                if (data.getUserName() == null || data.getUserName().trim().length() == 0) {
                    data.setUserName("root");
                }
                if (data.getGroup() == null || data.getGroup().trim().length() == 0) {
                    data.setGroup("root");
                }
                dataTar.add((ResourceCollection)data);
            }
            dataTar.execute();
        } else {
            TarOutputStream tarStream = new TarOutputStream((OutputStream)new GZipOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(dataFile)), 9));
            tarStream.close();
        }
        return dataFile;
    }

    private File createTempFolder() throws IOException {
        File tempFile = File.createTempFile("deb", ".dir");
        String tempFolderName = tempFile.getAbsolutePath();
        this.deleteFileCheck(tempFile);
        tempFile = new File(tempFolderName, "removeme");
        if (!tempFile.mkdirs()) {
            throw new IOException("Cannot create folder(s): " + tempFile.getAbsolutePath());
        }
        this.deleteFileCheck(tempFile);
        this.log("Temp folder: " + tempFolderName, 3);
        return new File(tempFolderName);
    }

    private void scanData() {
        try {
            HashSet<String> existingDirs = new HashSet<String>();
            this._installedSize = 0L;
            UnixPrintWriter md5sums = new UnixPrintWriter(new File(this._tempFolder, "md5sums"));
            UnixPrintWriter conffiles = new UnixPrintWriter(new File(this._tempFolder, "conffiles"));
            this._dataFolders = new TreeSet();
            Iterator filesets = this._data.iterator();
            while (filesets.hasNext()) {
                TarFileSet fileset = (TarFileSet)filesets.next();
                this.normalizeTargetFolder(fileset);
                String fullPath = fileset.getFullpath(this.getProject());
                String prefix = fileset.getPrefix(this.getProject());
                String[] fileNames = this.getFileNames((FileSet)fileset);
                for (int i = 0; i < fileNames.length; ++i) {
                    String fileName = fileNames[i];
                    File file = new File(fileset.getDir(this.getProject()), fileName);
                    String targetName = fullPath.length() > 0 ? fullPath : prefix + fileName;
                    if (file.isDirectory()) {
                        this.log("existing dir: " + targetName, 4);
                        existingDirs.add(targetName);
                        continue;
                    }
                    this._installedSize += file.length();
                    md5sums.print(this.getFileMd5(file));
                    md5sums.print(' ');
                    md5sums.println(targetName.substring(2));
                    File targetFile = new File(targetName);
                    for (File parentFolder = targetFile.getParentFile(); parentFolder != null; parentFolder = parentFolder.getParentFile()) {
                        String parentFolderPath = parentFolder.getPath();
                        if (".".equals(parentFolderPath)) {
                            parentFolderPath = "./";
                        }
                        if (existingDirs.contains(parentFolderPath) || this._dataFolders.contains(parentFolderPath)) continue;
                        this.log("adding dir: " + parentFolderPath + " for " + targetName, 4);
                        this._dataFolders.add(parentFolderPath);
                    }
                    if (!this._conffiles.contains(fileset)) continue;
                    conffiles.println(targetName.substring(1));
                }
            }
            Iterator iterator = existingDirs.iterator();
            while (iterator.hasNext()) {
                String existingDir = (String)iterator.next();
                if (!this._dataFolders.contains(existingDir)) continue;
                this.log("removing existing dir " + existingDir, 4);
                this._dataFolders.remove(existingDir);
            }
            md5sums.close();
            conffiles.close();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void normalizeTargetFolder(TarFileSet fileset) {
        String fullPath = fileset.getFullpath(this.getProject());
        String prefix = fileset.getPrefix(this.getProject());
        if (fullPath.length() > 0) {
            if (fullPath.startsWith("/")) {
                fullPath = "." + fullPath;
            } else if (!fullPath.startsWith("./")) {
                fullPath = "./" + fullPath;
            }
            fileset.setFullpath(fullPath.replace('\\', '/'));
        }
        if (prefix.length() > 0) {
            if (!prefix.endsWith("/")) {
                prefix = prefix + '/';
            }
            if (prefix.startsWith("/")) {
                prefix = "." + prefix;
            } else if (!prefix.startsWith("./")) {
                prefix = "./" + prefix;
            }
            fileset.setPrefix(prefix.replace('\\', '/'));
        }
    }

    private String[] getFileNames(FileSet fs) {
        DirectoryScanner ds = fs.getDirectoryScanner(fs.getProject());
        String[] directories = ds.getIncludedDirectories();
        String[] filesPerSe = ds.getIncludedFiles();
        String[] files = new String[directories.length + filesPerSe.length];
        System.arraycopy(directories, 0, files, 0, directories.length);
        System.arraycopy(filesPerSe, 0, files, directories.length, filesPerSe.length);
        return files;
    }

    private String getFileMd5(File file) {
        try {
            int read;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            FileInputStream inputStream = new FileInputStream(file);
            byte[] buffer = new byte[1024];
            while ((read = inputStream.read(buffer)) != -1) {
                md5.update(buffer, 0, read);
            }
            inputStream.close();
            byte[] md5Bytes = md5.digest();
            StringBuffer md5Buffer = new StringBuffer(md5Bytes.length * 2);
            for (int i = 0; i < md5Bytes.length; ++i) {
                String hex = Integer.toHexString(md5Bytes[i] & 0xFF);
                if (hex.length() == 1) {
                    md5Buffer.append('0');
                }
                md5Buffer.append(hex);
            }
            return md5Buffer.toString();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void processChangelogs() throws IOException {
        Iterator iter = this._changelogs.iterator();
        while (iter.hasNext()) {
            this.processChangelog((Changelog)((Object)iter.next()));
        }
    }

    private void processChangelog(Changelog changelog) throws IOException {
        File file = new File(changelog.getFile());
        File temp = File.createTempFile("changelog", ".gz");
        Deb.gzip(file, temp, 9, (byte)3);
        StringBuffer path = new StringBuffer("usr/share/doc/");
        path.append(this._package).append('/');
        path.append(changelog.getTargetFilename());
        TarFileSet fileSet = new TarFileSet();
        fileSet.setProject(this.getProject());
        fileSet.setFullpath(path.toString());
        fileSet.setFile(temp);
        fileSet.setFileMode("0644");
        this._data.add(fileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzip(File input, File output, int level, byte fileSystem) throws IOException {
        GZipOutputStream out = null;
        InputStream in = null;
        try {
            int len;
            out = new GZipOutputStream((OutputStream)new FileOutputStream(output), level);
            out.setFileSystem(fileSystem);
            in = new FileInputStream(input);
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer, 0, buffer.length)) > 0) {
                out.write(buffer, 0, len);
            }
            out.finish();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    private boolean deleteFolder(File folder) {
        if (folder.isDirectory()) {
            File[] children = folder.listFiles();
            for (int i = 0; i < children.length; ++i) {
                if (this.deleteFolder(children[i])) continue;
                return false;
            }
        }
        return folder.delete();
    }

    private void deleteFolderCheck(File folder) throws IOException {
        if (!this.deleteFolder(folder)) {
            throw new IOException("Cannot delete file: " + folder.getAbsolutePath());
        }
    }

    private void deleteFileCheck(File file) throws IOException {
        if (!file.delete()) {
            throw new IOException("Cannot delete file: " + file.getAbsolutePath());
        }
    }

    static {
        GZIP_COMPRESSION_METHOD.setValue("gzip");
        GNU_LONGFILE_MODE.setValue("gnu");
    }

    public static class Priority
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"required", "important", "standard", "optional", "extra"};
        }
    }

    public static class Section
    extends EnumeratedAttribute {
        private static final String[] PREFIXES = new String[]{"", "contrib/", "non-free/"};
        private static final String[] BASIC_SECTIONS = new String[]{"admin", "base", "comm", "devel", "doc", "editors", "electronics", "embedded", "games", "gnome", "graphics", "hamradio", "interpreters", "kde", "libs", "libdevel", "mail", "math", "misc", "net", "news", "oldlibs", "otherosfs", "perl", "python", "science", "shells", "sound", "tex", "text", "utils", "web", "x11"};
        private List sections = new ArrayList(PREFIXES.length * BASIC_SECTIONS.length);

        public Section() {
            for (int i = 0; i < PREFIXES.length; ++i) {
                String prefix = PREFIXES[i];
                for (int j = 0; j < BASIC_SECTIONS.length; ++j) {
                    String basicSection = BASIC_SECTIONS[j];
                    this.sections.add(prefix + basicSection);
                }
            }
        }

        public String[] getValues() {
            return this.sections.toArray(new String[this.sections.size()]);
        }
    }

    public static class Changelog
    extends ProjectComponent {
        private static final String STANDARD_FILENAME = "changelog.gz";
        private static final String DEBIAN_FILENAME = "changelog.Debian.gz";
        private String _file;
        private Format _format = new Format();
        private boolean _debian = false;

        public Changelog() {
            this._format.setValue("plain");
        }

        public void setFile(String file) {
            this._file = file.trim();
        }

        public String getFile() {
            return this._file;
        }

        public void setFormat(Format format) {
            this._format = format;
        }

        public Format getFormat() {
            return this._format;
        }

        public void setDebian(boolean debian) {
            this._debian = debian;
        }

        public boolean isDebian() {
            return this._debian;
        }

        public String getTargetFilename() {
            return this._debian ? DEBIAN_FILENAME : STANDARD_FILENAME;
        }

        public static class Format
        extends EnumeratedAttribute {
            public String[] getValues() {
                return new String[]{"plain"};
            }
        }
    }

    public static class Maintainer
    extends ProjectComponent {
        private String _name;
        private String _email;

        public void setName(String name) {
            this._name = name.trim();
        }

        public void setEmail(String email) {
            this._email = email.trim();
        }

        public String toString() {
            if (this._name == null || this._name.length() == 0) {
                return this._email;
            }
            StringBuffer buffer = new StringBuffer(this._name);
            buffer.append(" <");
            buffer.append(this._email);
            buffer.append(">");
            return buffer.toString();
        }
    }

    public static class Version
    extends ProjectComponent {
        private static final Pattern UPSTREAM_VERSION_PATTERN = Pattern.compile("[0-9][A-Za-z0-9.+\\-:~]*");
        private static final Pattern DEBIAN_VERSION_PATTERN = Pattern.compile("[A-Za-z0-9+.~]+");
        private int _epoch = 0;
        private String _upstream;
        private String _debian = "1";

        public void setEpoch(int epoch) {
            this._epoch = epoch;
        }

        public void setUpstream(String upstream) {
            this._upstream = upstream.trim();
            if (!UPSTREAM_VERSION_PATTERN.matcher(this._upstream).matches()) {
                throw new BuildException("Invalid upstream version number!");
            }
        }

        public void setDebian(String debian) {
            this._debian = debian.trim();
            if (this._debian.length() > 0 && !DEBIAN_VERSION_PATTERN.matcher(this._debian).matches()) {
                throw new BuildException("Invalid debian version number!");
            }
        }

        public String toString() {
            StringBuffer version = new StringBuffer();
            if (this._epoch > 0) {
                version.append(this._epoch);
                version.append(':');
            } else if (this._upstream.indexOf(58) > -1) {
                throw new BuildException("Upstream version can contain colons only if epoch is specified!");
            }
            version.append(this._upstream);
            if (this._debian.length() > 0) {
                version.append('-');
                version.append(this._debian);
            } else if (this._upstream.indexOf(45) > -1) {
                throw new BuildException("Upstream version can contain hyphens only if debian version is specified!");
            }
            return version.toString();
        }
    }

    public static class Description
    extends ProjectComponent {
        private String _synopsis;
        private String _extended = "";

        public String getSynopsis() {
            return this._synopsis;
        }

        public void setSynopsis(String synopsis) {
            this._synopsis = synopsis.trim();
        }

        public void addText(String text) {
            this._extended = this._extended + this.getProject().replaceProperties(text);
        }

        public String getExtended() {
            return this._extended;
        }

        public String getExtendedFormatted() {
            String line;
            int i;
            String line2;
            StringBuffer buffer = new StringBuffer(this._extended.length());
            String[] lines = this._extended.split("\n");
            int start = 0;
            for (int i2 = 0; i2 < lines.length && (line2 = lines[i2].trim()).length() <= 0; ++i2) {
                ++start;
            }
            int end = lines.length;
            for (i = lines.length - 1; i >= 0 && (line = lines[i].trim()).length() <= 0; --i) {
                --end;
            }
            for (i = start; i < end; ++i) {
                line = lines[i].trim();
                buffer.append(' ');
                buffer.append(line.length() == 0 ? "." : line);
                buffer.append('\n');
            }
            buffer.deleteCharAt(buffer.length() - 1);
            return buffer.toString();
        }
    }
}

