/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DataSetMerger;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.io.OsmServerObjectReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;

public class OsmServerBackreferenceReader
extends OsmServerReader {
    private final long id;
    private final OsmPrimitiveType primitiveType;
    private boolean readFull;
    private boolean allowIncompleteParentWays;

    public OsmServerBackreferenceReader(OsmPrimitive primitive) {
        CheckParameterUtil.ensureThat(primitive.getUniqueId() > 0L, "id > 0");
        this.id = primitive.getId();
        this.primitiveType = OsmPrimitiveType.from(primitive);
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(long id, OsmPrimitiveType type) {
        if (id <= 0L) {
            throw new IllegalArgumentException(MessageFormat.format("Parameter ''{0}'' > 0 expected. Got ''{1}''.", "id", id));
        }
        CheckParameterUtil.ensureParameterNotNull((Object)type, "type");
        this.id = id;
        this.primitiveType = type;
        this.readFull = false;
    }

    public OsmServerBackreferenceReader(OsmPrimitive primitive, boolean readFull) {
        this(primitive);
        this.readFull = readFull;
    }

    public OsmServerBackreferenceReader(long id, OsmPrimitiveType type, boolean readFull) {
        this(id, type);
        this.readFull = readFull;
    }

    public boolean isReadFull() {
        return this.readFull;
    }

    public OsmServerBackreferenceReader setReadFull(boolean readFull) {
        this.readFull = readFull;
        return this;
    }

    public boolean isAllowIncompleteParentWays() {
        return this.allowIncompleteParentWays;
    }

    public OsmServerBackreferenceReader setAllowIncompleteParentWays(boolean allowIncompleteWays) {
        this.allowIncompleteParentWays = allowIncompleteWays;
        return this;
    }

    /*
     * Loose catch block
     */
    private DataSet getReferringPrimitives(ProgressMonitor progressMonitor, String type, String message) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            DataSet dataSet;
            Throwable throwable;
            InputStream in;
            block27: {
                block28: {
                    block24: {
                        DataSet dataSet2;
                        block25: {
                            block26: {
                                progressMonitor.subTask(I18n.tr("Contacting OSM Server...", new Object[0]));
                                StringBuilder sb = new StringBuilder();
                                sb.append(this.primitiveType.getAPIName()).append('/').append(this.id).append(type);
                                in = this.getInputStream(sb.toString(), progressMonitor.createSubTaskMonitor(1, true));
                                throwable = null;
                                if (in != null) break block24;
                                dataSet2 = null;
                                if (in == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block25;
                            }
                            in.close();
                        }
                        return dataSet2;
                    }
                    progressMonitor.subTask(message);
                    dataSet = OsmReader.parseDataSet(in, progressMonitor.createSubTaskMonitor(1, true));
                    if (in == null) break block27;
                    if (throwable == null) break block28;
                    try {
                        in.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block27;
                }
                in.close();
            }
            return dataSet;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (in != null) {
                            if (throwable != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                in.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (OsmTransferException e) {
                    throw e;
                }
                catch (IOException | IllegalDataException e) {
                    if (this.cancel) {
                        DataSet dataSet3 = null;
                        return dataSet3;
                    }
                    throw new OsmTransferException(e);
                }
            }
        }
        finally {
            progressMonitor.finishTask();
            this.activeConnection = null;
        }
    }

    protected DataSet getReferringWays(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getReferringPrimitives(progressMonitor, "/ways", I18n.tr("Downloading referring ways ...", new Object[0]));
    }

    protected DataSet getReferringRelations(ProgressMonitor progressMonitor) throws OsmTransferException {
        return this.getReferringPrimitives(progressMonitor, "/relations", I18n.tr("Downloading referring relations ...", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSet readIncompletePrimitives(DataSet ds, ProgressMonitor progressMonitor) throws OsmTransferException {
        progressMonitor.beginTask(null, 2);
        try {
            ArrayList<Way> waysToCheck = new ArrayList<Way>(ds.getWays());
            if (this.isReadFull() || this.primitiveType == OsmPrimitiveType.NODE && !this.isAllowIncompleteParentWays()) {
                for (Way way : waysToCheck) {
                    if (way.isNew() || !way.hasIncompleteNodes()) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(way.getId(), OsmPrimitiveType.from(way), true);
                    DataSet wayDs = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    DataSetMerger visitor = new DataSetMerger(ds, wayDs);
                    visitor.merge();
                }
            }
            if (this.isReadFull()) {
                ArrayList<Relation> relationsToCheck = new ArrayList<Relation>(ds.getRelations());
                for (Relation relation : relationsToCheck) {
                    if (relation.isNew() || !relation.hasIncompleteMembers()) continue;
                    OsmServerObjectReader reader = new OsmServerObjectReader(relation.getId(), OsmPrimitiveType.from(relation), true);
                    DataSet wayDs = reader.parseOsm(progressMonitor.createSubTaskMonitor(1, false));
                    DataSetMerger visitor = new DataSetMerger(ds, wayDs);
                    visitor.merge();
                }
            }
            DataSet dataSet = ds;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataSet parseOsm(ProgressMonitor progressMonitor) throws OsmTransferException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        try {
            DataSetMerger visitor;
            DataSet ds;
            progressMonitor.beginTask(null, 3);
            DataSet ret = new DataSet();
            if (this.primitiveType == OsmPrimitiveType.NODE) {
                ds = this.getReferringWays(progressMonitor.createSubTaskMonitor(1, false));
                visitor = new DataSetMerger(ret, ds);
                visitor.merge();
                ret = visitor.getTargetDataSet();
            }
            ds = this.getReferringRelations(progressMonitor.createSubTaskMonitor(1, false));
            visitor = new DataSetMerger(ret, ds);
            visitor.merge();
            ret = visitor.getTargetDataSet();
            if (ret != null) {
                this.readIncompletePrimitives(ret, progressMonitor.createSubTaskMonitor(1, false));
                ret.deleteInvisible();
            }
            DataSet dataSet = ret;
            return dataSet;
        }
        finally {
            progressMonitor.finishTask();
        }
    }
}

