/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParsingException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.TagMap;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.io.OsmReader;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.DefaultGeoProperty;
import org.openstreetmap.josm.tools.GeoPropertyIndex;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.RightAndLefthandTraffic;
import org.openstreetmap.josm.tools.TaginfoRegionalInstance;

public final class Territories {
    public static final String FILENAME = "boundaries.osm";
    private static final String ISO3166_1 = "ISO3166-1:alpha2";
    private static final String ISO3166_2 = "ISO3166-2";
    private static final String ISO3166_1_LC = "ISO3166-1:alpha2".toLowerCase(Locale.ENGLISH);
    private static final String ISO3166_2_LC = "ISO3166-2".toLowerCase(Locale.ENGLISH);
    private static final String TAGINFO = "taginfo";
    private static DataSet dataSet;
    static volatile Map<String, GeoPropertyIndex<Boolean>> iso3166Cache;
    static volatile Map<String, TaginfoRegionalInstance> taginfoCache;
    static volatile Map<String, TaginfoRegionalInstance> taginfoGeofabrikCache;
    static volatile Map<String, TagMap> customTagsCache;
    private static final List<String> KNOWN_KEYS;

    private Territories() {
    }

    public static synchronized Set<String> getKnownIso3166Codes() {
        return iso3166Cache.keySet();
    }

    public static GeoPropertyIndex<Boolean> getGeoPropertyIndex(String code) {
        return iso3166Cache.get(code);
    }

    public static synchronized boolean isIso3166Code(String code, LatLon ll) {
        GeoPropertyIndex<Boolean> gpi = iso3166Cache.get(code);
        if (gpi == null) {
            Logging.warn(I18n.tr("Unknown territory id: {0}", code));
            return false;
        }
        return Boolean.TRUE.equals(gpi.get(ll));
    }

    public static synchronized DataSet getOriginalDataSet() {
        return dataSet;
    }

    public static synchronized void initialize() {
        Territories.initializeInternalData();
        Territories.initializeExternalData();
    }

    public static void initializeInternalData() {
        iso3166Cache = new HashMap<String, GeoPropertyIndex<Boolean>>();
        taginfoCache = new TreeMap<String, TaginfoRegionalInstance>();
        customTagsCache = new TreeMap<String, TagMap>();
        ArrayList<Way> traffic = new ArrayList<Way>();
        try {
            try (CachedFile cf = new CachedFile("resource://data/boundaries.osm");
                 InputStream is = cf.getInputStream();){
                dataSet = OsmReader.parseDataSet(is, null);
                for (OsmPrimitive osm : dataSet.allPrimitives()) {
                    if (osm instanceof Node) continue;
                    String iso1 = osm.get(ISO3166_1);
                    String iso2 = osm.get(ISO3166_2);
                    if (iso1 != null || iso2 != null) {
                        String taginfo;
                        TagMap tags = osm.getKeys();
                        KNOWN_KEYS.forEach(tags::remove);
                        DefaultGeoProperty gp = osm instanceof Way ? new DefaultGeoProperty(Collections.singleton((Way)osm)) : new DefaultGeoProperty((Relation)osm);
                        GeoPropertyIndex<Boolean> gpi = new GeoPropertyIndex<Boolean>(gp, 24);
                        Territories.addInCache(iso1, gpi, tags);
                        Territories.addInCache(iso2, gpi, tags);
                        if (iso1 != null && (taginfo = osm.get(TAGINFO)) != null) {
                            taginfoCache.put(iso1, new TaginfoRegionalInstance(taginfo, Collections.singleton(iso1)));
                        }
                    }
                    RightAndLefthandTraffic.appendLeftDrivingBoundaries(osm, traffic);
                }
                RightAndLefthandTraffic.initialize(new DefaultGeoProperty(traffic));
            }
            MultipolygonCache.getInstance().clear(dataSet);
        }
        catch (IOException | IllegalDataException ex) {
            try {
                throw new JosmRuntimeException(ex);
            }
            catch (Throwable throwable) {
                MultipolygonCache.getInstance().clear(dataSet);
                if (!Logging.isDebugEnabled()) {
                    dataSet = null;
                } else {
                    Logging.debug("Retaining {0} to allow editing via advanced preferences", FILENAME);
                }
                throw throwable;
            }
        }
        if (!Logging.isDebugEnabled()) {
            dataSet = null;
        } else {
            Logging.debug("Retaining {0} to allow editing via advanced preferences", FILENAME);
        }
    }

    private static void addInCache(String code, GeoPropertyIndex<Boolean> gpi, TagMap tags) {
        if (code != null) {
            iso3166Cache.put(code, gpi);
            if (!tags.isEmpty()) {
                customTagsCache.put(code, tags);
            }
        }
    }

    private static void initializeExternalData() {
        taginfoGeofabrikCache = new TreeMap<String, TaginfoRegionalInstance>();
        Territories.initializeExternalData(taginfoGeofabrikCache, "Geofabrik", Config.getUrls().getJOSMWebsite() + "/remote/geofabrik-index-v1-nogeom.json");
    }

    static void initializeExternalData(Map<String, TaginfoRegionalInstance> cache, String source, String path) {
        try (CachedFile cf = new CachedFile(path);
             InputStream is = cf.getInputStream();
             JsonParser json = Json.createParser(is);){
            while (json.hasNext()) {
                JsonParser.Event event = json.next();
                if (event != JsonParser.Event.START_OBJECT) continue;
                for (JsonValue feature : json.getObject().getJsonArray("features")) {
                    Optional.ofNullable(feature.asJsonObject().getJsonObject("properties")).ifPresent(props -> Optional.ofNullable(props.getJsonObject("urls")).ifPresent(urls -> Optional.ofNullable(urls.getString(TAGINFO)).ifPresent(taginfo -> {
                        JsonArray iso1 = props.getJsonArray(ISO3166_1_LC);
                        JsonArray iso2 = props.getJsonArray(ISO3166_2_LC);
                        if (iso1 != null) {
                            Territories.readExternalTaginfo(cache, taginfo, iso1, source);
                        } else if (iso2 != null) {
                            Territories.readExternalTaginfo(cache, taginfo, iso2, source);
                        }
                    })));
                }
            }
        }
        catch (IOException | JsonParsingException e) {
            Logging.debug(e);
            Logging.warn(I18n.tr("Failed to parse external taginfo data at {0}: {1}", path, e.getMessage()));
        }
    }

    private static void readExternalTaginfo(Map<String, TaginfoRegionalInstance> cache, String taginfo, JsonArray jsonCodes, String source) {
        Set<String> isoCodes = jsonCodes.getValuesAs(JsonString.class).stream().map(JsonString::getString).collect(Collectors.toSet());
        isoCodes.forEach(s -> cache.put((String)s, new TaginfoRegionalInstance(taginfo, isoCodes, source)));
    }

    public static List<TaginfoRegionalInstance> getRegionalTaginfoUrls(LatLon ll) {
        if (iso3166Cache == null) {
            return Collections.emptyList();
        }
        return iso3166Cache.entrySet().parallelStream().distinct().filter(e -> Boolean.TRUE.equals(((GeoPropertyIndex)e.getValue()).get(ll))).map(Map.Entry::getKey).distinct().flatMap(code -> Stream.of(taginfoCache, taginfoGeofabrikCache).map(cache -> (TaginfoRegionalInstance)cache.get(code))).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static TagMap getCustomTags(String code) {
        return code != null ? customTagsCache.get(code) : null;
    }

    static {
        KNOWN_KEYS = Arrays.asList(ISO3166_1, ISO3166_2, TAGINFO, "type", "driving_side", "note");
    }
}

