/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntry;
import org.openstreetmap.josm.data.cache.CacheEntryAttributes;
import org.openstreetmap.josm.data.cache.ICachedLoaderListener;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.data.preferences.LongProperty;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class TMSCachedTileLoaderJob
extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry>
implements TileJob,
ICachedLoaderListener {
    public static final LongProperty MAXIMUM_EXPIRES = new LongProperty("imagery.generic.maximum_expires", TimeUnit.DAYS.toMillis(30L));
    public static final LongProperty MINIMUM_EXPIRES = new LongProperty("imagery.generic.minimum_expires", TimeUnit.HOURS.toMillis(1L));
    static final Pattern SERVICE_EXCEPTION_PATTERN = Pattern.compile("(?s).+<ServiceException[^>]*>(.+)</ServiceException>.+");
    static final Pattern CDATA_PATTERN = Pattern.compile("(?s)\\s*<!\\[CDATA\\[(.+)\\]\\]>\\s*");
    static final Pattern JSON_PATTERN = Pattern.compile("\\{\"message\":\"(.+)\"\\}");
    protected final Tile tile;
    private volatile URL url;
    private final TileJobOptions options;
    private static final ConcurrentMap<String, Set<TileLoaderListener>> inProgress = new ConcurrentHashMap<String, Set<TileLoaderListener>>();

    public TMSCachedTileLoaderJob(TileLoaderListener listener, Tile tile, ICacheAccess<String, BufferedImageCacheEntry> cache, TileJobOptions options, ThreadPoolExecutor downloadExecutor) {
        super(cache, options, downloadExecutor);
        this.tile = tile;
        this.options = options;
        if (listener != null) {
            inProgress.computeIfAbsent(this.getCacheKey(), k -> new HashSet()).add(listener);
        }
    }

    @Override
    public String getCacheKey() {
        if (this.tile != null) {
            TileSource tileSource = this.tile.getTileSource();
            return Optional.ofNullable(tileSource.getName()).orElse("").replace(':', '_') + ':' + tileSource.getTileId(this.tile.getZoom(), this.tile.getXtile(), this.tile.getYtile());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getUrl() throws IOException {
        if (this.url == null) {
            TMSCachedTileLoaderJob tMSCachedTileLoaderJob = this;
            synchronized (tMSCachedTileLoaderJob) {
                String sUrl;
                if (this.url == null && !"".equals(sUrl = this.tile.getUrl())) {
                    this.url = new URL(sUrl);
                }
            }
        }
        return this.url;
    }

    @Override
    public boolean isObjectLoadable() {
        if (this.cacheData != null) {
            byte[] content = ((BufferedImageCacheEntry)this.cacheData).getContent();
            try {
                return content.length > 0 || ((BufferedImageCacheEntry)this.cacheData).getImage() != null || this.isNoTileAtZoom();
            }
            catch (IOException e) {
                Logging.logWithStackTrace(Logging.LEVEL_WARN, e, "JCS TMS - error loading from cache for tile {0}: {1}", this.tile.getKey(), e.getMessage());
            }
        }
        return false;
    }

    @Override
    protected boolean isResponseLoadable(Map<String, List<String>> headers, int statusCode, byte[] content) {
        this.attributes.setMetadata(this.tile.getTileSource().getMetadata(headers));
        if (this.tile.getTileSource().isNoTileAtZoom(headers, statusCode, content)) {
            this.attributes.setNoTileAtZoom(true);
            return false;
        }
        return super.isResponseLoadable(headers, statusCode, content);
    }

    @Override
    protected boolean cacheAsEmpty() {
        return this.isNoTileAtZoom() || super.cacheAsEmpty();
    }

    @Override
    public void submit(boolean force) {
        this.tile.initLoading();
        try {
            super.submit(this, force);
        }
        catch (IOException | IllegalArgumentException e) {
            Logging.log(Logging.LEVEL_WARN, e);
            this.tile.finishLoading();
            this.tile.setError(e.getMessage());
        }
    }

    @Override
    public void loadingFinished(CacheEntry object, CacheEntryAttributes attributes, ICachedLoaderListener.LoadResult result) {
        block12: {
            this.attributes = attributes;
            Set listeners = (Set)inProgress.remove(this.getCacheKey());
            boolean status = result == ICachedLoaderListener.LoadResult.SUCCESS;
            try {
                this.tile.finishLoading();
                if (this.attributes != null) {
                    for (Map.Entry<String, String> e : this.attributes.getMetadata().entrySet()) {
                        this.tile.putValue(e.getKey(), e.getValue());
                    }
                }
                switch (result) {
                    case SUCCESS: {
                        int httpStatusCode;
                        this.handleNoTileAtZoom();
                        if (attributes != null && (httpStatusCode = attributes.getResponseCode()) >= 400 && !this.isNoTileAtZoom()) {
                            status = false;
                            this.handleError(attributes);
                        }
                        status &= this.tryLoadTileImage(object);
                        break;
                    }
                    case FAILURE: {
                        this.handleError(attributes);
                        this.tryLoadTileImage(object);
                        break;
                    }
                    case CANCELED: {
                        this.tile.loadingCanceled();
                    }
                }
                if (listeners == null) break block12;
                for (TileLoaderListener l : listeners) {
                    l.tileLoadingFinished(this.tile, status);
                }
            }
            catch (IOException e) {
                Logging.warn("JCS TMS - error loading object for tile {0}: {1}", this.tile.getKey(), e.getMessage());
                this.tile.setError(e);
                this.tile.setLoaded(false);
                if (listeners == null) break block12;
                for (TileLoaderListener l : listeners) {
                    l.tileLoadingFinished(this.tile, false);
                }
            }
        }
    }

    private void handleError(CacheEntryAttributes attributes) {
        if (attributes != null) {
            int httpStatusCode = attributes.getResponseCode();
            if (attributes.getErrorMessage() == null) {
                this.tile.setError(I18n.tr("HTTP error {0} when loading tiles", httpStatusCode));
            } else {
                this.tile.setError(I18n.tr("Error downloading tiles: {0}", attributes.getErrorMessage()));
            }
            if (httpStatusCode >= 500 && httpStatusCode != 599) {
                this.tile.setLoaded(false);
            }
            attributes.getException().filter(x -> x.isAssignableFrom(SocketTimeoutException.class)).ifPresent(x -> this.tile.setLoaded(false));
        } else {
            this.tile.setError(I18n.tr("Problem loading tile", new Object[0]));
        }
    }

    @Override
    protected String getServerKey() {
        TileSource ts = this.tile.getSource();
        if (ts instanceof AbstractTMSTileSource) {
            return ((AbstractTMSTileSource)ts).getBaseUrl();
        }
        return super.getServerKey();
    }

    @Override
    protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
        return new BufferedImageCacheEntry(content);
    }

    @Override
    public void submit() {
        this.submit(false);
    }

    @Override
    protected CacheEntryAttributes parseHeaders(HttpClient.Response urlConn) {
        CacheEntryAttributes ret = super.parseHeaders(urlConn);
        ret.setExpirationTime((long)Utils.clamp(ret.getExpirationTime(), this.now + Math.max(MINIMUM_EXPIRES.get(), TimeUnit.SECONDS.toMillis(this.options.getMinimumExpiryTime())), this.now + Math.max(MAXIMUM_EXPIRES.get(), TimeUnit.SECONDS.toMillis(this.options.getMinimumExpiryTime()))));
        return ret;
    }

    private boolean handleNoTileAtZoom() {
        if (this.isNoTileAtZoom()) {
            Logging.debug("JCS TMS - Tile valid, but no file, as no tiles at this level {0}", this.tile);
            this.tile.setError(I18n.tr("No tiles at this zoom level", new Object[0]));
            this.tile.putValue("tile-info", "no-tile");
            return true;
        }
        return false;
    }

    private boolean isNoTileAtZoom() {
        if (this.attributes == null) {
            Logging.warn("Cache attributes are null");
        }
        return this.attributes != null && this.attributes.isNoTileAtZoom();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryLoadTileImage(CacheEntry object) throws IOException {
        if (object == null) return true;
        byte[] content = object.getContent();
        if (content.length <= 0) return true;
        try (ByteArrayInputStream in = new ByteArrayInputStream(content);){
            this.tile.loadImage(in);
            if (this.tile.getImage() != null) return true;
            String s = new String(content, StandardCharsets.UTF_8);
            Matcher m = SERVICE_EXCEPTION_PATTERN.matcher(s);
            if (m.matches()) {
                String message = Utils.strip(m.group(1));
                this.tile.setError(message);
                Logging.error(message);
                Logging.debug(s);
            } else {
                this.tile.setError(I18n.tr("Could not load image from tile server", new Object[0]));
            }
            boolean bl = false;
            return bl;
        }
        catch (SecurityException | UnsatisfiedLinkError e) {
            throw new IOException(e);
        }
    }

    @Override
    public String detectErrorMessage(String data) {
        Matcher xml = SERVICE_EXCEPTION_PATTERN.matcher(data);
        Matcher json = JSON_PATTERN.matcher(data);
        return xml.matches() ? TMSCachedTileLoaderJob.removeCdata(Utils.strip(xml.group(1))) : (json.matches() ? Utils.strip(json.group(1)) : super.detectErrorMessage(data));
    }

    private static String removeCdata(String msg) {
        Matcher m = CDATA_PATTERN.matcher(msg);
        return m.matches() ? Utils.strip(m.group(1)) : msg;
    }
}

