/*
 * Decompiled with CFR 0.152.
 */
package ch.poole.openinghoursparser;

import ch.poole.openinghoursparser.Element;
import ch.poole.openinghoursparser.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class Holiday
extends Element {
    Type type = null;
    int offset = 0;
    boolean useAsWeekDay = true;

    public Holiday() {
    }

    public Holiday(@NotNull Holiday h) {
        this.type = h.type;
        this.offset = h.offset;
        this.useAsWeekDay = h.useAsWeekDay;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.type != null) {
            b.append(this.type.toString());
            if (this.offset != 0) {
                b.append(this.offset > 0 ? " +" : " -");
                b.append(String.format(Locale.US, "%d", Math.abs(this.offset)));
                b.append(" day");
                if (Math.abs(this.offset) > 1) {
                    b.append("s");
                }
            }
        }
        return b.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof Holiday) {
            Holiday o = (Holiday)other;
            return Util.equals((Object)this.type, (Object)o.type) && this.offset == o.offset;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 37 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 37 * result + this.offset;
        return result;
    }

    public Type getType() {
        return this.type;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setUseAsWeekDay(boolean useAsWeekDay) {
        this.useAsWeekDay = useAsWeekDay;
    }

    public boolean getUseAsWeekDay() {
        return this.useAsWeekDay;
    }

    public Holiday copy() {
        return new Holiday(this);
    }

    public static enum Type {
        PH,
        SH;


        public static List<String> nameValues() {
            ArrayList<String> result = new ArrayList<String>();
            for (Type t : Type.values()) {
                result.add(t.toString());
            }
            return result;
        }
    }
}

