/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.TileSourceInfo;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.InputSource;

public class CachedAttributionBingAerialTileSource
extends BingAerialTileSource {
    private Runnable attributionDownloadedTask;

    public CachedAttributionBingAerialTileSource(ImageryInfo info) {
        this(info, null);
    }

    public CachedAttributionBingAerialTileSource(TileSourceInfo info, Runnable attributionDownloadedTask) {
        super(info);
        this.attributionDownloadedTask = attributionDownloadedTask;
        super.setLayer("AerialOSM");
    }

    @Override
    protected Callable<List<BingAerialTileSource.Attribution>> getAttributionLoaderCallable() {
        AtomicReference attributions = new AtomicReference();
        AtomicBoolean finished = new AtomicBoolean();
        return () -> {
            PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor();
            monitor.beginTask(I18n.tr("Attempting to fetch Bing attribution information", new Object[0]), -1);
            Timer timer = new Timer(Thread.currentThread().getName() + "-timer", true);
            timer.schedule((TimerTask)new AttributionTimerTask(monitor, timer, 1, attributions, finished), 0L);
            AtomicBoolean atomicBoolean = finished;
            synchronized (atomicBoolean) {
                while (!finished.get() && !monitor.isCanceled()) {
                    finished.wait(1000L);
                }
            }
            monitor.finishTask();
            monitor.close();
            return (List)attributions.get();
        };
    }

    private class AttributionTimerTask
    extends TimerTask {
        private final ProgressMonitor monitor;
        private final Timer timer;
        private final int waitTimeSec;
        private final AtomicReference<List<BingAerialTileSource.Attribution>> attributions;
        private final AtomicBoolean finished;

        AttributionTimerTask(ProgressMonitor monitor, Timer timer, int waitTimeSec, AtomicReference<List<BingAerialTileSource.Attribution>> attributions, AtomicBoolean finished) {
            this.monitor = monitor;
            this.timer = timer;
            this.waitTimeSec = waitTimeSec;
            this.attributions = attributions;
            this.finished = finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BingAttributionData attributionLoader = new BingAttributionData();
            try {
                List ret;
                String xml = attributionLoader.updateIfRequiredString();
                try (StringReader sr = new StringReader(xml);){
                    ret = CachedAttributionBingAerialTileSource.this.parseAttributionText(new InputSource(sr));
                }
                if (CachedAttributionBingAerialTileSource.this.attributionDownloadedTask != null) {
                    GuiHelper.runInEDT(CachedAttributionBingAerialTileSource.this.attributionDownloadedTask);
                    CachedAttributionBingAerialTileSource.this.attributionDownloadedTask = null;
                }
                this.attributions.set(ret);
                this.finished.set(true);
            }
            catch (IOException ex) {
                String message = I18n.tr("Could not connect to Bing API. Will retry in {0} seconds.", this.waitTimeSec);
                Logging.log(Logging.LEVEL_WARN, message, ex);
                if (this.monitor.isCanceled()) {
                    this.finished.set(true);
                    return;
                }
                this.monitor.setCustomText(message);
                this.monitor.worked(1);
                int newWaitTimeSec = 2 * this.waitTimeSec;
                this.timer.schedule((TimerTask)new AttributionTimerTask(this.monitor, this.timer, newWaitTimeSec, this.attributions, this.finished), (long)newWaitTimeSec * 1000L);
            }
            finally {
                AtomicBoolean sr = this.finished;
                synchronized (sr) {
                    this.finished.notifyAll();
                }
            }
        }
    }

    class BingAttributionData
    extends CacheCustomContent<IOException> {
        BingAttributionData() {
            super("bing.attribution.xml", CacheCustomContent.INTERVAL_HOURLY);
        }

        @Override
        protected byte[] updateData() throws IOException {
            URL u = CachedAttributionBingAerialTileSource.this.getAttributionUrl();
            String r = HttpClient.create(u).connect().fetchContent();
            Logging.info("Successfully loaded Bing attribution data.");
            return r.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected boolean isOffline() {
            try {
                return NetworkManager.isOffline(CachedAttributionBingAerialTileSource.this.getAttributionUrl().toExternalForm());
            }
            catch (MalformedURLException e) {
                Logging.error(e);
                return false;
            }
        }
    }
}

