/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import org.openstreetmap.josm.plugins.DynamicURLClassLoader;
import org.openstreetmap.josm.tools.Logging;

public class PluginClassLoader
extends DynamicURLClassLoader {
    private final Collection<PluginClassLoader> dependencies;

    public PluginClassLoader(URL[] urls, ClassLoader parent, Collection<PluginClassLoader> dependencies) {
        super(urls, parent);
        this.dependencies = dependencies == null ? new ArrayList<PluginClassLoader>() : new ArrayList<PluginClassLoader>(dependencies);
    }

    public boolean addDependency(PluginClassLoader dependency) {
        boolean result;
        boolean bl = result = !this.dependencies.contains(Objects.requireNonNull(dependency, "dependency")) && this.dependencies.stream().noneMatch(pcl -> pcl.dependencies.contains(dependency)) && this.dependencies.add(dependency);
        if (result) {
            this.dependencies.removeIf(pcl -> pcl.dependencies.isEmpty() && dependency.dependencies.contains(pcl));
        }
        return result;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(name);
        if (result == null) {
            for (PluginClassLoader dep : this.dependencies) {
                try {
                    result = dep.loadClass(name, resolve);
                    if (result == null) continue;
                    return result;
                }
                catch (ClassNotFoundException e) {
                    Logging.trace("Plugin class not found in dep {0}: {1}", dep, e.getMessage());
                    Logging.trace(e);
                }
            }
            try {
                result = super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                Logging.trace("Plugin class not found in super {0}: {1}", this, e.getMessage());
                Logging.trace(e);
            }
        }
        if (result == null && this.getParent() != null) {
            try {
                result = this.getParent().loadClass(name);
            }
            catch (ClassNotFoundException e) {
                Logging.trace("Plugin class not found in parent {0}: {1}", this.getParent(), e.getMessage());
                Logging.trace(e);
            }
        }
        if (result != null) {
            return result;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL findResource(String name) {
        URL resource;
        block1: {
            PluginClassLoader dep;
            resource = super.findResource(name);
            if (resource != null) break block1;
            Iterator<PluginClassLoader> iterator = this.dependencies.iterator();
            while (iterator.hasNext() && (resource = (dep = iterator.next()).findResource(name)) == null) {
            }
        }
        return resource;
    }

    public String toString() {
        return "PluginClassLoader [urls=" + Arrays.toString(this.getURLs()) + (String)(this.dependencies.isEmpty() ? "" : ", dependencies=" + String.valueOf(this.dependencies)) + "]";
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

