/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Objects;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelation;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelationSettings;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.geoimage.CorrelateGpxWithImages;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDirectionPositionPanel;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class EditImagesSequenceAction
extends JosmAction {
    private final transient GeoImageLayer yLayer;
    private final ImageDirectionPositionPanel pDirectionPosition;

    public EditImagesSequenceAction(GeoImageLayer layer) {
        super(I18n.tr("Edit images sequence", new Object[0]), "dialogs/geoimage/gpx2img", "geoimage_editsequence", Shortcut.registerShortcut("geoimage:editsequence", I18n.tr("Edit images sequence", new Object[0]), 65535, 5000), false);
        this.yLayer = Objects.requireNonNull(layer);
        this.pDirectionPosition = ImageDirectionPositionPanel.forImageSequence();
        Updater updater = new Updater();
        this.pDirectionPosition.addFocusListenerOnComponent(new CorrelateGpxWithImages.RepaintTheMapListener(this.yLayer));
        this.pDirectionPosition.addChangeListenerOnComponents(updater);
        this.pDirectionPosition.addItemListenerOnComponents(updater);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Edit images sequence", new Object[0]), I18n.tr("Apply", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(this.pDirectionPosition).setButtonIcons("ok", "cancel");
        ed.setResizable(false);
        if (ed.showDialog().getValue() == 1) {
            this.yLayer.applyTmp();
        } else {
            this.yLayer.discardTmp();
        }
        this.yLayer.updateBufferAndRepaint();
    }

    class Updater
    implements ChangeListener,
    ItemListener {
        Updater() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.matchAndUpdate();
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.matchAndUpdate();
        }

        void matchAndUpdate() {
            EditImagesSequenceAction.this.yLayer.discardTmp();
            List<ImageEntry> dateImgLst = EditImagesSequenceAction.this.yLayer.getSortedImgList(true, true);
            dateImgLst.forEach(ie -> ie.createTmp().unflagNewGpsData());
            GpxImageCorrelation.matchGpxTrack(dateImgLst, EditImagesSequenceAction.this.yLayer.getFauxGpxData(), new GpxImageCorrelationSettings(0L, false, EditImagesSequenceAction.this.pDirectionPosition.getSettings()));
            EditImagesSequenceAction.this.yLayer.updateBufferAndRepaint();
        }
    }
}

