/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.downloadtasks.AbstractDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.DataSource;
import org.openstreetmap.josm.data.ProjectionBounds;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.io.UpdatePrimitivesTask;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.OsmServerLocationReader;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OverpassDownloadReader;
import org.openstreetmap.josm.io.UrlPatterns;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

public class DownloadOsmTask
extends AbstractDownloadTask<DataSet> {
    protected Bounds currentBounds;
    protected DownloadTask downloadTask;
    protected String newLayerName;
    protected boolean warnAboutEmptyArea = true;
    protected static final String OVERPASS_INTERPRETER_DATA = "interpreter?data=";
    private static final String NO_DATA_FOUND = I18n.tr("No data found in this area.", new Object[0]);

    @Override
    public String[] getPatterns() {
        if (this.getClass() == DownloadOsmTask.class) {
            return DownloadOsmTask.patterns(UrlPatterns.OsmUrlPattern.class);
        }
        return super.getPatterns();
    }

    @Override
    public String getTitle() {
        if (this.getClass() == DownloadOsmTask.class) {
            return I18n.tr("Download OSM", new Object[0]);
        }
        return super.getTitle();
    }

    @Override
    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download(new BoundingBoxDownloader(downloadArea), settings, downloadArea, progressMonitor);
    }

    public Future<?> download(OsmServerReader reader, DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        return this.download(new DownloadTask(settings, reader, progressMonitor, this.zoomAfterDownload), downloadArea);
    }

    protected Future<?> download(DownloadTask downloadTask, Bounds downloadArea) {
        this.downloadTask = downloadTask;
        this.currentBounds = new Bounds(downloadArea);
        return MainApplication.worker.submit(downloadTask);
    }

    protected String modifyUrlBeforeLoad(String url) {
        return url;
    }

    @Override
    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        String newUrl = this.modifyUrlBeforeLoad(url);
        Optional<UrlPatterns.OsmUrlPattern> urlPattern = Arrays.stream(UrlPatterns.OsmUrlPattern.values()).filter(p -> p.matches(newUrl)).findFirst();
        this.downloadTask = new DownloadTask(settings, this.getOsmServerReader(newUrl), progressMonitor, true, Compression.byExtension(newUrl));
        this.currentBounds = null;
        this.extractOsmFilename(settings, urlPattern.orElse(UrlPatterns.OsmUrlPattern.EXTERNAL_OSM_FILE).pattern(), newUrl);
        return MainApplication.worker.submit(this.downloadTask);
    }

    protected OsmServerReader getOsmServerReader(String url) {
        try {
            String host = new URL(url).getHost();
            Iterator iterator = OverpassDownloadReader.OVERPASS_SERVER_HISTORY.get().iterator();
            while (iterator.hasNext()) {
                int index;
                String knownOverpassServer = (String)iterator.next();
                if (!host.equals(new URL(knownOverpassServer).getHost()) || (index = url.indexOf(OVERPASS_INTERPRETER_DATA)) <= 0) continue;
                return new OverpassDownloadReader(new Bounds(LatLon.ZERO), knownOverpassServer, Utils.decodeUrl(url.substring(index + OVERPASS_INTERPRETER_DATA.length())));
            }
        }
        catch (MalformedURLException e) {
            Logging.error(e);
        }
        return new OsmServerLocationReader(url);
    }

    protected final void extractOsmFilename(DownloadParams settings, String pattern, String url) {
        this.newLayerName = settings.getLayerName();
        if (Utils.isEmpty(this.newLayerName)) {
            Matcher matcher = Pattern.compile(pattern).matcher(url);
            this.newLayerName = matcher.matches() && matcher.groupCount() > 0 ? Utils.decodeUrl(matcher.group(1)) : null;
        }
    }

    @Override
    public void cancel() {
        if (this.downloadTask != null) {
            this.downloadTask.cancel();
        }
    }

    @Override
    public boolean isSafeForRemotecontrolRequests() {
        return true;
    }

    @Override
    public ProjectionBounds getDownloadProjectionBounds() {
        return this.downloadTask != null ? (ProjectionBounds)this.downloadTask.computeBbox(this.currentBounds).orElse(null) : null;
    }

    protected Collection<OsmPrimitive> searchPotentiallyDeletedPrimitives(DataSet ds) {
        return this.downloadTask.searchPrimitivesToUpdate(this.currentBounds, ds);
    }

    protected final void rememberDownloadedBounds(Bounds bounds) {
        if (bounds != null) {
            Config.getPref().put("osm-download.bounds", bounds.encodeAsString(";"));
        }
    }

    @Override
    public String getConfirmationMessage(URL url) {
        if (UrlPatterns.OsmUrlPattern.OSM_API_URL.matches(url)) {
            ArrayList<Object> items = new ArrayList<Object>();
            items.add(I18n.tr("OSM Server URL:", new Object[0]) + " " + url.getHost());
            items.add(I18n.tr("Command", new Object[0]) + ": " + url.getPath());
            if (url.getQuery() != null) {
                items.add(I18n.tr("Request details: {0}", url.getQuery().replaceAll(",\\s*", ", ")));
            }
            return Utils.joinAsHtmlUnorderedList(items);
        }
        return null;
    }

    static {
        PostDownloadHandler.addNoDataErrorMessage(NO_DATA_FOUND);
    }

    protected class DownloadTask
    extends AbstractInternalTask {
        protected final OsmServerReader reader;
        protected final Compression compression;

        public DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor) {
            this(settings, reader, progressMonitor, true);
        }

        public DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor, boolean zoomAfterDownload) {
            this(settings, reader, progressMonitor, zoomAfterDownload, Compression.NONE);
        }

        public DownloadTask(DownloadParams settings, OsmServerReader reader, ProgressMonitor progressMonitor, boolean zoomAfterDownload, Compression compression) {
            super(settings, I18n.tr("Downloading data", new Object[0]), progressMonitor, false, zoomAfterDownload);
            this.reader = Objects.requireNonNull(reader);
            this.compression = compression;
        }

        protected DataSet parseDataSet() throws OsmTransferException {
            ProgressMonitor subTaskMonitor = this.progressMonitor.createSubTaskMonitor(-1, false);
            return this.compression != null && this.compression != Compression.NONE ? this.reader.parseOsm(subTaskMonitor, this.compression) : this.reader.parseOsm(subTaskMonitor);
        }

        @Override
        public void realRun() throws IOException, SAXException, OsmTransferException {
            try {
                if (DownloadOsmTask.this.isCanceled()) {
                    return;
                }
                this.dataSet = this.parseDataSet();
            }
            catch (OsmTransferException e) {
                if (DownloadOsmTask.this.isCanceled()) {
                    Logging.info(I18n.tr("Ignoring exception because download has been canceled. Exception was: {0}", e.toString()));
                    return;
                }
                if (e instanceof OsmTransferCanceledException) {
                    DownloadOsmTask.this.setCanceled(true);
                    return;
                }
                DownloadOsmTask.this.rememberException(e);
                DownloadOsmTask.this.setFailed(true);
            }
        }

        @Override
        protected void finish() {
            if (DownloadOsmTask.this.isFailed() || DownloadOsmTask.this.isCanceled()) {
                return;
            }
            if (this.dataSet == null) {
                return;
            }
            if (this.dataSet.allPrimitives().isEmpty()) {
                String remark;
                if (DownloadOsmTask.this.warnAboutEmptyArea) {
                    DownloadOsmTask.this.rememberErrorMessage(NO_DATA_FOUND);
                }
                if (!Utils.isEmpty(remark = this.dataSet.getRemark())) {
                    DownloadOsmTask.this.rememberErrorMessage(remark);
                }
                if (!(this.reader instanceof BoundingBoxDownloader) || ((BoundingBoxDownloader)this.reader).considerAsFullDownload()) {
                    this.dataSet.addDataSource(new DataSource(DownloadOsmTask.this.currentBounds != null ? DownloadOsmTask.this.currentBounds : new Bounds(LatLon.ZERO), "OpenStreetMap server"));
                }
            }
            DownloadOsmTask.this.rememberDownloadedBounds(DownloadOsmTask.this.currentBounds);
            DownloadOsmTask.this.rememberDownloadedData(this.dataSet);
            this.loadData(DownloadOsmTask.this.newLayerName, DownloadOsmTask.this.currentBounds);
        }

        @Override
        protected void cancel() {
            DownloadOsmTask.this.setCanceled(true);
            if (this.reader != null) {
                this.reader.cancel();
            }
        }
    }

    public static abstract class AbstractInternalTask
    extends PleaseWaitRunnable {
        protected final DownloadParams settings;
        protected final boolean zoomAfterDownload;
        protected DataSet dataSet;

        protected AbstractInternalTask(DownloadParams settings, String title, boolean ignoreException, boolean zoomAfterDownload) {
            super(title, ignoreException);
            this.settings = Objects.requireNonNull(settings);
            this.zoomAfterDownload = zoomAfterDownload;
        }

        protected AbstractInternalTask(DownloadParams settings, String title, ProgressMonitor progressMonitor, boolean ignoreException, boolean zoomAfterDownload) {
            super(title, progressMonitor, ignoreException);
            this.settings = Objects.requireNonNull(settings);
            this.zoomAfterDownload = zoomAfterDownload;
        }

        protected OsmDataLayer getEditLayer() {
            return MainApplication.getLayerManager().getEditLayer();
        }

        private static Stream<OsmDataLayer> getModifiableDataLayers() {
            return MainApplication.getLayerManager().getLayersOfType(OsmDataLayer.class).stream().filter(OsmDataLayer::isDownloadable);
        }

        protected long getNumModifiableDataLayers() {
            return AbstractInternalTask.getModifiableDataLayers().count();
        }

        protected OsmDataLayer getFirstModifiableDataLayer() {
            return AbstractInternalTask.getModifiableDataLayers().findFirst().orElse(null);
        }

        protected String generateLayerName() {
            return Optional.ofNullable(this.settings.getLayerName()).filter(layerName -> !Utils.isStripEmpty(layerName)).orElse(OsmDataLayer.createNewName());
        }

        protected OsmDataLayer createNewLayer(DataSet ds, Optional<String> layerName) {
            if (layerName.filter(Utils::isStripEmpty).isPresent()) {
                throw new IllegalArgumentException("Blank layer name!");
            }
            return new OsmDataLayer(Objects.requireNonNull(ds, "dataset parameter"), layerName.orElseGet(this::generateLayerName), null);
        }

        protected final OsmDataLayer createNewLayer(Optional<String> layerName) {
            Optional.ofNullable(this.settings.getDownloadPolicy()).ifPresent(this.dataSet::setDownloadPolicy);
            Optional.ofNullable(this.settings.getUploadPolicy()).ifPresent(this.dataSet::setUploadPolicy);
            if (this.dataSet.isLocked() && !this.settings.isLocked()) {
                this.dataSet.unlock();
            } else if (!this.dataSet.isLocked() && this.settings.isLocked()) {
                this.dataSet.lock();
            }
            return this.createNewLayer(this.dataSet, layerName);
        }

        protected Optional<ProjectionBounds> computeBbox(Bounds bounds) {
            BoundingXYVisitor v = new BoundingXYVisitor();
            if (bounds != null) {
                v.visit(bounds);
            } else {
                v.computeBoundingBox(this.dataSet.getNodes());
            }
            return Optional.ofNullable(v.getBounds());
        }

        protected OsmDataLayer addNewLayerIfRequired(String newLayerName) {
            long numDataLayers = this.getNumModifiableDataLayers();
            if (this.settings.isNewLayer() || numDataLayers == 0L || numDataLayers > 1L && this.getEditLayer() == null) {
                OsmDataLayer layer = this.createNewLayer(Optional.ofNullable(newLayerName).filter(it -> !Utils.isStripEmpty(it)));
                MainApplication.getLayerManager().addLayer(layer, this.zoomAfterDownload);
                return layer;
            }
            return null;
        }

        protected void loadData(String newLayerName, Bounds bounds) {
            OsmDataLayer layer = this.addNewLayerIfRequired(newLayerName);
            if (layer == null) {
                layer = this.getEditLayer();
                if (layer == null || !layer.isDownloadable()) {
                    layer = this.getFirstModifiableDataLayer();
                }
                Collection<OsmPrimitive> primitivesToUpdate = this.searchPrimitivesToUpdate(bounds, layer.getDataSet());
                layer.mergeFrom(this.dataSet);
                MapFrame map = MainApplication.getMap();
                if (map != null && this.zoomAfterDownload) {
                    this.computeBbox(bounds).map(ViewportData::new).ifPresent(map.mapView::zoomTo);
                }
                if (!primitivesToUpdate.isEmpty()) {
                    MainApplication.worker.submit(new UpdatePrimitivesTask(layer, primitivesToUpdate));
                }
            }
            layer.onPostDownloadFromServer();
        }

        protected Collection<OsmPrimitive> searchPrimitivesToUpdate(Bounds bounds, DataSet ds) {
            if (bounds == null) {
                return Collections.emptySet();
            }
            ArrayList col = new ArrayList();
            ds.searchNodes(bounds.toBBox()).stream().filter(n -> !n.isNew() && !this.dataSet.containsNode((Node)n)).forEachOrdered(col::add);
            if (!col.isEmpty()) {
                HashSet<Way> ways = new HashSet<Way>();
                HashSet<Relation> rels = new HashSet<Relation>();
                for (OsmPrimitive n2 : col) {
                    for (OsmPrimitive ref : n2.getReferrers()) {
                        if (ref.isNew()) continue;
                        if (ref instanceof Way) {
                            ways.add((Way)ref);
                            continue;
                        }
                        if (!(ref instanceof Relation)) continue;
                        rels.add((Relation)ref);
                    }
                }
                ways.stream().filter(w -> !this.dataSet.containsWay((Way)w)).forEachOrdered(col::add);
                rels.stream().filter(r -> !this.dataSet.containsRelation((Relation)r)).forEachOrdered(col::add);
            }
            return Collections.unmodifiableCollection(col);
        }
    }
}

