/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.util.imagery;

import java.awt.geom.Point2D;
import org.openstreetmap.josm.gui.util.imagery.Vector3D;

public final class UVMapping {
    private static final double TWO_PI = Math.PI * 2;

    private UVMapping() {
    }

    public static Point2D.Double getTextureCoordinate(Vector3D vector) {
        double u = 0.5 + Math.atan2(vector.getX(), vector.getZ()) / (Math.PI * 2);
        double v = 0.5 + Math.asin(vector.getY()) / Math.PI;
        return new Point2D.Double(u, v);
    }

    public static Vector3D getVector(double u, double v) {
        if (u > 1.0 || u < 0.0 || v > 1.0 || v < 0.0) {
            throw new IllegalArgumentException("u and v must be between or equal to 0 and 1");
        }
        double vectorY = Math.cos(v * Math.PI);
        double vectorYSquared = Math.pow(vectorY, 2.0);
        return new Vector3D(-Math.sin(Math.PI * 2 * u) * Math.sqrt(1.0 - vectorYSquared), -vectorY, -Math.cos(Math.PI * 2 * u) * Math.sqrt(1.0 - vectorYSquared));
    }
}

