/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.protobuf;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.openstreetmap.josm.data.protobuf.ProtobufRecord;
import org.openstreetmap.josm.data.protobuf.WireType;
import org.openstreetmap.josm.tools.Logging;

public class ProtobufParser
implements AutoCloseable {
    public static final byte BYTE_SIZE = 8;
    public static final byte VAR_INT_BYTE_SIZE = 7;
    static final byte MOST_SIGNIFICANT_BYTE = -128;
    private final InputStream inputStream;

    public static Number convertByteArray(byte[] bytes, byte byteSize) {
        long number = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            number += Byte.toUnsignedLong(bytes[i]) << byteSize * i;
        }
        return ProtobufParser.convertLong(number);
    }

    public static Number convertLong(long number) {
        if (number <= 127L && number >= -128L) {
            return (byte)number;
        }
        if (number <= 32767L && number >= -32768L) {
            return (short)number;
        }
        if (number <= Integer.MAX_VALUE && number >= Integer.MIN_VALUE) {
            return (int)number;
        }
        return number;
    }

    public static Number decodeZigZag(Number signed) {
        long value = signed.longValue();
        return ProtobufParser.convertLong(value >> 1 ^ -(value & 1L));
    }

    public static Number encodeZigZag(Number signed) {
        long value = signed.longValue();
        int shift = (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE ? 8 : 4) * 8 - 1;
        return ProtobufParser.convertLong(value << 1 ^ value >> shift);
    }

    public ProtobufParser(byte[] bytes) {
        this(new ByteArrayInputStream(bytes));
    }

    public ProtobufParser(InputStream inputStream) {
        this.inputStream = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
    }

    public Collection<ProtobufRecord> allRecords() throws IOException {
        ArrayList<ProtobufRecord> records = new ArrayList<ProtobufRecord>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        while (this.hasNext()) {
            records.add(new ProtobufRecord(byteArrayOutputStream, this));
        }
        return records;
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (IOException e) {
            Logging.error(e);
        }
    }

    public boolean hasNext() throws IOException {
        return this.inputStream.available() > 0;
    }

    public WireType next() throws IOException {
        this.inputStream.mark(16);
        try {
            WireType wireType = WireType.getAllValues()[this.inputStream.read() << 3];
            return wireType;
        }
        finally {
            this.inputStream.reset();
        }
    }

    public int nextByte() throws IOException {
        return this.inputStream.read();
    }

    public byte[] nextFixed32() throws IOException {
        return this.readNextBytes(4);
    }

    public byte[] nextFixed64() throws IOException {
        return this.readNextBytes(8);
    }

    public byte[] nextLengthDelimited(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int length = ProtobufParser.convertByteArray(this.nextVarInt(byteArrayOutputStream), (byte)7).intValue();
        return this.readNextBytes(length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] nextVarInt(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int currentByte = this.nextByte();
        while ((byte)(currentByte & 0xFFFFFF80) == -128 && currentByte > 0) {
            byteArrayOutputStream.write(currentByte ^ 0xFFFFFF80);
            currentByte = this.nextByte();
        }
        byteArrayOutputStream.write(currentByte);
        try {
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            byteArrayOutputStream.reset();
        }
    }

    private byte[] readNextBytes(int size) throws IOException {
        byte[] bytesRead = new byte[size];
        for (int i = 0; i < bytesRead.length; ++i) {
            bytesRead[i] = (byte)this.nextByte();
        }
        return bytesRead;
    }
}

