/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.preferences;

import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.CachingProperty;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public abstract class AbstractToStringProperty<T>
extends AbstractProperty<T> {
    protected AbstractToStringProperty(String key, T defaultValue) {
        super(key, defaultValue);
        this.storeDefaultValue();
    }

    @Override
    public T get() {
        String string = this.getAsString();
        if (!string.isEmpty()) {
            try {
                return this.fromString(string);
            }
            catch (AbstractProperty.InvalidPreferenceValueException e) {
                Logging.warn(BugReport.intercept(e).put("key", this.key).put("value", string));
            }
        }
        return this.getDefaultValue();
    }

    protected abstract T fromString(String var1);

    @Override
    public boolean put(T value) {
        String string = value == null ? null : this.toString(value);
        return this.getPreferences().put(this.getKey(), string);
    }

    protected abstract String toString(T var1);

    protected String getAsString() {
        Object def = this.getDefaultValue();
        String sdef = def == null ? "" : this.toString(def);
        return this.getPreferences() != null ? this.getPreferences().get(this.key, sdef) : sdef;
    }

    public AbstractToStringProperty<T> getSpecialized(String spec) {
        return this.getChildProperty(this.getKey() + "." + spec);
    }

    protected AbstractToStringProperty<T> getChildProperty(String key) {
        return new ChildProperty(this, key);
    }

    public static class ChildProperty<T>
    extends AbstractToStringProperty<T> {
        private final AbstractToStringProperty<T> parent;

        ChildProperty(AbstractToStringProperty<T> parent, String key) {
            super(key, null);
            CheckParameterUtil.ensureParameterNotNull(parent, "parent");
            this.parent = parent;
        }

        @Override
        protected void storeDefaultValue() {
        }

        @Override
        public T getDefaultValue() {
            return this.parent.get();
        }

        @Override
        protected T fromString(String string) {
            return this.parent.fromString(string);
        }

        @Override
        protected String toString(T t) {
            return this.parent.toString(t);
        }

        @Override
        protected void addListenerImpl(PreferenceChangedListener adapter) {
            super.addListenerImpl(adapter);
            this.parent.addListenerImpl(adapter);
        }

        @Override
        protected void removeListenerImpl(PreferenceChangedListener adapter) {
            super.removeListenerImpl(adapter);
            this.parent.removeListenerImpl(adapter);
        }

        @Override
        public CachingProperty<T> cached() {
            throw new UnsupportedOperationException("Not implemented yet.");
        }
    }
}

